/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

public class SubstitutorComputer {
    private static final Logger LOG = Logger.getInstance(SubstitutorComputer.class);
    protected final PsiElement myPlace;
    private final PsiType myThisType;
    @Nullable
    private final PsiType[] myArgumentTypes;
    @Nullable
    private final PsiType[] myTypeArguments;
    private final PsiElement myPlaceToInferContext;
    private final NotNullLazyValue<Collection<PsiElement>> myExitPoints;
    private final PsiResolveHelper myHelper;

    public SubstitutorComputer(PsiType thisType, @Nullable PsiType[] argumentTypes, @Nullable PsiType[] typeArguments, PsiElement place, PsiElement placeToInferContext) {
        this.myThisType = thisType;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myPlace = place;
        this.myPlaceToInferContext = placeToInferContext;
        this.myExitPoints = VolatileNotNullLazyValue.createValue(() -> {
            if (SubstitutorComputer.canBeExitPoint(place)) {
                GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(place);
                return ContainerUtil.newHashSet(ControlFlowUtils.collectReturns(flowOwner));
            }
            return ContainerUtil.emptyList();
        });
        this.myHelper = JavaPsiFacade.getInstance((Project)this.myPlace.getProject()).getResolveHelper();
    }

    @Nullable
    protected PsiType inferContextType() {
        PsiElement parent = this.myPlaceToInferContext.getParent();
        if (parent instanceof GrReturnStatement || ((Collection)this.myExitPoints.getValue()).contains(this.myPlaceToInferContext)) {
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, GrMethod.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class});
            if (method != null) {
                return method.getReturnType();
            }
        } else {
            if (parent instanceof GrAssignmentExpression && this.myPlaceToInferContext.equals(((GrAssignmentExpression)parent).getRValue())) {
                PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent).getLValue(), false);
                if (lValue instanceof GrExpression && !(lValue instanceof GrIndexProperty)) {
                    return ((GrExpression)lValue).getNominalType();
                }
                return null;
            }
            if (parent instanceof GrVariable) {
                return ((GrVariable)parent).getDeclaredType();
            }
        }
        return null;
    }

    private static boolean canBeExitPoint(PsiElement place) {
        while (place != null) {
            if (place instanceof GrMethod || place instanceof GrClosableBlock || place instanceof GrClassInitializer) {
                return true;
            }
            if (place instanceof GrThrowStatement || place instanceof GrTypeDefinitionBody || place instanceof GroovyFile) {
                return false;
            }
            place = place.getParent();
        }
        return false;
    }

    public PsiSubstitutor obtainSubstitutor(@NotNull PsiSubstitutor substitutor, @NotNull PsiMethod method, @Nullable PsiElement resolveContext) {
        if (substitutor == null) {
            SubstitutorComputer.$$$reportNull$$$0(0);
        }
        if (method == null) {
            SubstitutorComputer.$$$reportNull$$$0(1);
        }
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (this.myTypeArguments != null && this.myTypeArguments.length == typeParameters.length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters[i];
                PsiType typeArgument = this.myTypeArguments[i];
                substitutor = substitutor.put(typeParameter, typeArgument);
            }
            return substitutor;
        }
        if (this.myArgumentTypes != null && method.hasTypeParameters()) {
            PsiType[] argTypes = this.myArgumentTypes;
            if (method instanceof GrGdkMethod) {
                PsiType[] newArgTypes = PsiType.createArray((int)(argTypes.length + 1));
                newArgTypes[0] = GdkMethodUtil.isInWithContext(resolveContext) ? ((GrExpression)resolveContext).getType() : this.myThisType;
                System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
                argTypes = newArgTypes;
                method = ((GrGdkMethod)method).getStaticMethod();
                LOG.assertTrue(method.isValid());
            }
            return this.inferMethodTypeParameters(method, substitutor, typeParameters, argTypes);
        }
        return substitutor;
    }

    private PsiSubstitutor inferMethodTypeParameters(@NotNull PsiMethod method, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] argTypes) {
        if (method == null) {
            SubstitutorComputer.$$$reportNull$$$0(2);
        }
        if (partialSubstitutor == null) {
            SubstitutorComputer.$$$reportNull$$$0(3);
        }
        if (typeParameters == null) {
            SubstitutorComputer.$$$reportNull$$$0(4);
        }
        if (argTypes == null) {
            SubstitutorComputer.$$$reportNull$$$0(5);
        }
        if (typeParameters.length == 0 || this.myArgumentTypes == null) {
            return partialSubstitutor;
        }
        GrClosureSignature erasedSignature = GrClosureSignatureUtil.createSignature(method, partialSubstitutor, true);
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, partialSubstitutor);
        GrClosureParameter[] params = signature.getParameters();
        GrClosureSignatureUtil.ArgInfo<PsiType>[] argInfos = GrClosureSignatureUtil.mapArgTypesToParameters(erasedSignature, argTypes, this.myPlace, true);
        if (argInfos == null || params.length > argInfos.length) {
            return partialSubstitutor;
        }
        Deque<InferenceStep> inferenceQueue = this.buildInferenceQueue(method, typeParameters, params, argInfos);
        PsiSubstitutor substitutor = partialSubstitutor;
        while (!inferenceQueue.isEmpty()) {
            substitutor = inferenceQueue.pollFirst().doInfer(substitutor);
        }
        for (PsiTypeParameter typeParameter : typeParameters) {
            if (substitutor.getSubstitutionMap().containsKey(typeParameter) || (substitutor = this.inferFromContext(typeParameter, PsiUtil.getSmartReturnType(method), substitutor)).getSubstitutionMap().containsKey(typeParameter)) continue;
            substitutor = substitutor.put(typeParameter, null);
        }
        return partialSubstitutor.putAll(substitutor);
    }

    @NotNull
    private Deque<InferenceStep> buildInferenceQueue(@NotNull PsiMethod method, @NotNull PsiTypeParameter[] typeParameters, GrClosureParameter[] params, GrClosureSignatureUtil.ArgInfo<PsiType>[] argInfos) {
        if (method == null) {
            SubstitutorComputer.$$$reportNull$$$0(6);
        }
        if (typeParameters == null) {
            SubstitutorComputer.$$$reportNull$$$0(7);
        }
        ArrayDeque<InferenceStep> inferenceQueue = new ArrayDeque<InferenceStep>();
        ArrayList<PsiType> parameterTypes = new ArrayList<PsiType>();
        ArrayList<Object> argumentTypes = new ArrayList<Object>();
        for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
            PsiType paramType = params[paramIndex].getType();
            GrClosureSignatureUtil.ArgInfo<PsiType> argInfo = argInfos[paramIndex];
            if (argInfo != null) {
                if (argInfo.isMultiArg && paramType instanceof PsiArrayType) {
                    paramType = ((PsiArrayType)paramType).getComponentType();
                }
                for (PsiType type : argInfo.args) {
                    PsiType argType = type;
                    if (InheritanceUtil.isInheritor((PsiType)argType, (String)"groovy.lang.Closure")) {
                        inferenceQueue.add(this.handleClosure(paramType, argType, typeParameters));
                        continue;
                    }
                    if (argType instanceof GrTupleType) {
                        PsiType rawWildcardType = TypesUtil.rawWildcard(argType, (PsiElement)method);
                        PsiType psiType = argType = rawWildcardType != null ? rawWildcardType : argType;
                    }
                    if (argType != null) {
                        argType = com.intellij.psi.util.PsiUtil.captureToplevelWildcards((PsiType)argType, (PsiElement)method);
                    }
                    parameterTypes.add(paramType);
                    argumentTypes.add(argType);
                }
                continue;
            }
            parameterTypes.add(paramType);
            argumentTypes.add(PsiType.NULL);
        }
        PsiType[] parameterArray = parameterTypes.toArray(PsiType.EMPTY_ARRAY);
        PsiType[] argumentArray = argumentTypes.toArray(PsiType.EMPTY_ARRAY);
        inferenceQueue.addFirst(this.buildStep(parameterArray, argumentArray, typeParameters));
        ArrayDeque<InferenceStep> arrayDeque = inferenceQueue;
        if (arrayDeque == null) {
            SubstitutorComputer.$$$reportNull$$$0(8);
        }
        return arrayDeque;
    }

    InferenceStep buildStep(PsiType[] parameterTypes, PsiType[] argumentTypes, PsiTypeParameter[] typeParameters) {
        return ps -> this.myHelper.inferTypeArguments(SubstitutorComputer.collectTypeParams(typeParameters, parameterTypes), parameterTypes, argumentTypes, ps, LanguageLevel.JDK_1_8);
    }

    private InferenceStep handleClosure(PsiType targetType, PsiType argType, @NotNull PsiTypeParameter[] typeParameters) {
        if (typeParameters == null) {
            SubstitutorComputer.$$$reportNull$$$0(9);
        }
        if (targetType instanceof PsiClassType && TypesUtil.isClassType(targetType, "groovy.lang.Closure")) {
            PsiType[] parameters = ((PsiClassType)targetType).getParameters();
            if (parameters.length != 1) {
                return InferenceStep.EMPTY;
            }
            return this.buildReturnTypeClosureStep(argType, parameters[0], typeParameters);
        }
        if (SamConversionKt.isSamConversionAllowed(this.myPlace)) {
            return this.handleConversionOfSAMType(targetType, argType, typeParameters);
        }
        return InferenceStep.EMPTY;
    }

    @NotNull
    private InferenceStep handleConversionOfSAMType(@Nullable PsiType targetType, @NotNull PsiType closure, PsiTypeParameter[] typeParameters) {
        if (closure == null) {
            SubstitutorComputer.$$$reportNull$$$0(10);
        }
        if (!(closure instanceof PsiClassType)) {
            InferenceStep inferenceStep = InferenceStep.EMPTY;
            if (inferenceStep == null) {
                SubstitutorComputer.$$$reportNull$$$0(11);
            }
            return inferenceStep;
        }
        if (!(targetType instanceof PsiClassType)) {
            InferenceStep inferenceStep = InferenceStep.EMPTY;
            if (inferenceStep == null) {
                SubstitutorComputer.$$$reportNull$$$0(12);
            }
            return inferenceStep;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)targetType).resolveGenerics();
        PsiClass samClass = resolveResult.getElement();
        if (samClass == null) {
            InferenceStep inferenceStep = InferenceStep.EMPTY;
            if (inferenceStep == null) {
                SubstitutorComputer.$$$reportNull$$$0(13);
            }
            return inferenceStep;
        }
        PsiMethod sam2 = SamConversionKt.findSingleAbstractMethod(samClass);
        if (sam2 == null) {
            InferenceStep inferenceStep = InferenceStep.EMPTY;
            if (inferenceStep == null) {
                SubstitutorComputer.$$$reportNull$$$0(14);
            }
            return inferenceStep;
        }
        PsiType samReturnType = resolveResult.getSubstitutor().substitute(sam2.getReturnType());
        if (samReturnType == null) {
            InferenceStep inferenceStep = InferenceStep.EMPTY;
            if (inferenceStep == null) {
                SubstitutorComputer.$$$reportNull$$$0(15);
            }
            return inferenceStep;
        }
        InferenceStep inferenceStep = this.buildReturnTypeClosureStep(closure, samReturnType, typeParameters);
        if (inferenceStep == null) {
            SubstitutorComputer.$$$reportNull$$$0(16);
        }
        return inferenceStep;
    }

    private InferenceStep buildReturnTypeClosureStep(@NotNull PsiType closure, @Nullable PsiType returnType, PsiTypeParameter[] typeParameters) {
        PsiType[] parameters;
        if (closure == null) {
            SubstitutorComputer.$$$reportNull$$$0(17);
        }
        if ((parameters = ((PsiClassType)closure).getParameters()).length != 1) {
            return InferenceStep.EMPTY;
        }
        PsiType[] rightTypes = closure instanceof GrClosureType ? ((GrClosureType)closure).inferParameters() : parameters;
        return this.buildStep(new PsiType[]{returnType}, rightTypes, typeParameters);
    }

    private static PsiTypeParameter[] collectTypeParams(PsiTypeParameter[] parameters, PsiType[] types) {
        HashSet<PsiTypeParameter> visited = new HashSet<PsiTypeParameter>();
        SubstitutorComputer.collectTypeParams(parameters, visited, types);
        return visited.toArray(PsiTypeParameter.EMPTY_ARRAY);
    }

    private static void collectTypeParams(PsiTypeParameter[] parameters, Set<PsiTypeParameter> visited, PsiType ... type) {
        PsiTypeParameter[] typeParameters;
        for (PsiTypeParameter parameter : typeParameters = PsiTypesUtil.filterUnusedTypeParameters((PsiTypeParameter[])parameters, (PsiType[])type)) {
            if (!visited.add(parameter)) continue;
            SubstitutorComputer.collectTypeParams(parameters, visited, (PsiType[])parameter.getExtendsListTypes());
        }
    }

    private PsiSubstitutor inferFromContext(@NotNull PsiTypeParameter typeParameter, @Nullable PsiType lType, @NotNull PsiSubstitutor substitutor) {
        if (typeParameter == null) {
            SubstitutorComputer.$$$reportNull$$$0(18);
        }
        if (substitutor == null) {
            SubstitutorComputer.$$$reportNull$$$0(19);
        }
        if (this.myPlace == null) {
            return substitutor;
        }
        PsiType inferred = this.myHelper.getSubstitutionForTypeParameter(typeParameter, lType, this.inferContextType(), false, LanguageLevel.JDK_1_8);
        if (inferred != PsiType.NULL) {
            return substitutor.put(typeParameter, inferred);
        }
        return substitutor;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argTypes";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/SubstitutorComputer";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/SubstitutorComputer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInferenceQueue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "handleConversionOfSAMType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainSubstitutor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inferMethodTypeParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildInferenceQueue";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleClosure";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleConversionOfSAMType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildReturnTypeClosureStep";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inferFromContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface InferenceStep {
        public static final InferenceStep EMPTY = ps -> ps;

        public PsiSubstitutor doInfer(@NotNull PsiSubstitutor var1);
    }
}

