/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.highlight;

import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.quickfix.GradleIncreaseLanguageLevelFix;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.IncreaseLanguageLevelFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public class GradleHighlightQuickfixReplacementVisitor
extends JavaElementVisitor
implements HighlightVisitor {
    private HighlightInfoHolder myHolder = null;

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/highlight/GradleHighlightQuickfixReplacementVisitor", "visit"));
        }
        if (this.myHolder == null) {
            return;
        }
        Module contextModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (contextModule == null) {
            return;
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(contextModule);
        if (gradleFacet == null) {
            return;
        }
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(contextModule);
        for (int i = 0; i < this.myHolder.size(); ++i) {
            HighlightInfo info = this.myHolder.get(i);
            final LanguageLevel[] targetLanguageLevel = new LanguageLevel[]{null};
            try {
                info.unregisterQuickFix((Condition)new Condition<IntentionAction>(){

                    public boolean value(IntentionAction intentionAction) {
                        if (intentionAction.getClass() == IncreaseLanguageLevelFix.class) {
                            targetLanguageLevel[0] = (LanguageLevel)ReflectionUtil.getField(IncreaseLanguageLevelFix.class, (Object)intentionAction, LanguageLevel.class, (String)"myLevel");
                            if (targetLanguageLevel[0] != null) {
                                return true;
                            }
                        }
                        return false;
                    }
                });
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (targetLanguageLevel[0] == null || targetLanguageLevel[0].isAtLeast(LanguageLevel.JDK_1_8) || gradleBuildFile == null) continue;
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new GradleIncreaseLanguageLevelFix(targetLanguageLevel[0], gradleBuildFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/highlight/GradleHighlightQuickfixReplacementVisitor", "analyze"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/android/tools/idea/gradle/highlight/GradleHighlightQuickfixReplacementVisitor", "analyze"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/highlight/GradleHighlightQuickfixReplacementVisitor", "analyze"));
        }
        this.myHolder = holder;
        try {
            action.run();
        }
        finally {
            this.myHolder = null;
        }
        return true;
    }

    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/highlight/GradleHighlightQuickfixReplacementVisitor", "suitableForFile"));
        }
        return true;
    }

    @NotNull
    public GradleHighlightQuickfixReplacementVisitor clone() {
        GradleHighlightQuickfixReplacementVisitor gradleHighlightQuickfixReplacementVisitor = new GradleHighlightQuickfixReplacementVisitor();
        if (gradleHighlightQuickfixReplacementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/highlight/GradleHighlightQuickfixReplacementVisitor", "clone"));
        }
        return gradleHighlightQuickfixReplacementVisitor;
    }

    public int order() {
        return 0;
    }
}

