/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;

public class DefaultFileSystemChangeWaiter
implements FileSystemChangeWaiter {
    private final ExecutorFactory executorFactory;
    private final FileWatcherFactory fileWatcherFactory;
    private final long quietPeriodMillis;

    public DefaultFileSystemChangeWaiter(ExecutorFactory executorFactory, FileWatcherFactory fileWatcherFactory) {
        this(executorFactory, fileWatcherFactory, 250L);
    }

    public DefaultFileSystemChangeWaiter(ExecutorFactory executorFactory, FileWatcherFactory fileWatcherFactory, long quietPeriodMillis) {
        this.executorFactory = executorFactory;
        this.fileWatcherFactory = fileWatcherFactory;
        this.quietPeriodMillis = quietPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(FileSystemSubset taskFileSystemInputs, BuildCancellationToken cancellationToken, Runnable notifier) {
        if (cancellationToken.isCancellationRequested()) {
            return;
        }
        final AtomicReference error = new AtomicReference();
        StoppableExecutor executorService = this.executorFactory.create("continuous build - wait");
        final ReentrantLock lock = new ReentrantLock();
        final Condition condition = lock.newCondition();
        final AtomicLong lastChangeAt = new AtomicLong(0L);
        Runnable cancellationHandler = new Runnable(){

            public void run() {
                DefaultFileSystemChangeWaiter.this.signal(lock, condition);
            }
        };
        FileWatcher watcher = this.fileWatcherFactory.watch(taskFileSystemInputs, (Action<? super Throwable>)new Action<Throwable>(){

            public void execute(Throwable throwable) {
                error.set(throwable);
                DefaultFileSystemChangeWaiter.this.signal(lock, condition);
            }
        }, new FileWatcherListener(){

            public void onChange(FileWatcher watcher, FileWatcherEvent event) {
                if (event.getType() != FileWatcherEvent.Type.MODIFY || !event.getFile().isDirectory()) {
                    DefaultFileSystemChangeWaiter.this.signal(lock, condition, new Runnable(){

                        public void run() {
                            lastChangeAt.set(DefaultFileSystemChangeWaiter.monotonicClockMillis());
                        }
                    });
                }
            }
        });
        try {
            cancellationToken.addCallback(cancellationHandler);
            notifier.run();
            lock.lock();
            try {
                long lastChangeAtValue = lastChangeAt.get();
                while (!(cancellationToken.isCancellationRequested() || error.get() != null || lastChangeAtValue != 0L && DefaultFileSystemChangeWaiter.monotonicClockMillis() - lastChangeAtValue >= this.quietPeriodMillis)) {
                    condition.await(this.quietPeriodMillis, TimeUnit.MILLISECONDS);
                    lastChangeAtValue = lastChangeAt.get();
                }
            }
            finally {
                lock.unlock();
            }
            Throwable throwable = (Throwable)error.get();
            if (throwable != null) {
                throw throwable;
            }
            cancellationToken.removeCallback(cancellationHandler);
        }
        catch (Throwable e) {
            try {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            catch (Throwable throwable) {
                cancellationToken.removeCallback(cancellationHandler);
                CompositeStoppable.stoppable((Object[])new Object[]{watcher, executorService}).stop();
                throw throwable;
            }
        }
        CompositeStoppable.stoppable((Object[])new Object[]{watcher, executorService}).stop();
    }

    private static long monotonicClockMillis() {
        return System.nanoTime() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal(Lock lock, Condition condition, Runnable runnable) {
        lock.lock();
        try {
            runnable.run();
            condition.signal();
        }
        finally {
            lock.unlock();
        }
    }

    private void signal(Lock lock, Condition condition) {
        this.signal(lock, condition, new Runnable(){

            public void run() {
            }
        });
    }
}

