/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import com.intellij.util.PathKt;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.ConstantsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.CredentialsStoreKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0010\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/keychain/FileCredentialsStore;", "Lorg/jetbrains/keychain/CredentialsStore;", "storeFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "credentials", "Lorg/jetbrains/keychain/Credentials;", "dataLoaded", "", "ensureLoaded", "", "get", "host", "", "sshKeyFile", "reset", "save", "settings-repository"})
public final class FileCredentialsStore
implements CredentialsStore {
    private Credentials credentials;
    private boolean dataLoaded;
    private final Path storeFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureLoaded() {
        if (this.dataLoaded) {
            return;
        }
        this.dataLoaded = true;
        if (PathKt.exists((Path)this.storeFile)) {
            try {
                DataInputStream dataInputStream;
                boolean hasErrors = true;
                InputStream inputStream = PathKt.inputStream((Path)this.storeFile);
                int n = 0;
                boolean bl = true;
                Object var6_7 = null;
                DataInputStream dataInputStream2 = dataInputStream;
                DataInputStream dataInputStream3 = dataInputStream;
                if (var6_7 != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
                }
                if (bl & true) {
                    n = ConstantsKt.DEFAULT_BUFFER_SIZE;
                }
                BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
                dataInputStream2(bufferedInputStream);
                DataInputStream in = dataInputStream3;
                try {
                    this.credentials = new Credentials(PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)), PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)));
                    hasErrors = false;
                }
                finally {
                    if (hasErrors) {
                        PathKt.delete((Path)this.storeFile);
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                CredentialsStoreKt.getLOG().error((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public Credentials get(@Nullable String host, @Nullable String sshKeyFile) {
        this.ensureLoaded();
        return this.credentials;
    }

    @Override
    public void reset(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.credentials != null) {
            this.dataLoaded = true;
            PathKt.delete((Path)this.storeFile);
            Credentials credentials = this.credentials;
            if (credentials == null) {
                Intrinsics.throwNpe();
            }
            this.credentials = new Credentials(credentials.getId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@Nullable String host, @NotNull Credentials credentials, @Nullable String sshKeyFile) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        if (credentials.equals(this.credentials)) {
            return;
        }
        this.credentials = credentials;
        try {
            DataOutputStream dataOutputStream;
            OutputStream outputStream = PathKt.outputStream((Path)this.storeFile);
            int n = 0;
            boolean bl = true;
            Object var8_8 = null;
            DataOutputStream dataOutputStream2 = dataOutputStream;
            DataOutputStream dataOutputStream3 = dataOutputStream;
            if (var8_8 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
            }
            if (bl & true) {
                n = ConstantsKt.DEFAULT_BUFFER_SIZE;
            }
            BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
            dataOutputStream2(bufferedOutputStream);
            DataOutputStream out = dataOutputStream3;
            try {
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getId()), (DataOutput)out);
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getToken()), (DataOutput)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            CredentialsStoreKt.getLOG().error((Throwable)e);
        }
    }

    public FileCredentialsStore(@NotNull Path storeFile) {
        Intrinsics.checkParameterIsNotNull((Object)storeFile, (String)"storeFile");
        this.storeFile = storeFile;
        this.dataLoaded = !PathKt.exists((Path)this.storeFile);
    }
}

