/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.inspections.AddKotlinLibQuickFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\r\u0010\u000e\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0006H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix;", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "getLibFile", "Ljava/io/File;", "getLibraryDescriptor", "Lorg/jetbrains/kotlin/idea/inspections/AddKotlinLibQuickFix$MavenExternalLibraryDescriptor;", "module", "Lcom/intellij/openapi/module/Module;", "getText", "hasLibJarInLibrary", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "libraryPath", "Companion", "idea"})
public final class AddTestLibQuickFix
extends AddKotlinLibQuickFix {
    @NotNull
    private static final Set<String> KOTLIN_TEST_UNRESOLVED;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return KotlinBundle.message("add.test.to.classpath", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @NotNull
    protected String libraryPath() {
        return "kotlin-test.jar";
    }

    @Override
    @NotNull
    protected File getLibFile() {
        File file = PathUtil.getKotlinPathsForIdeaPlugin().getKotlinTestPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"PathUtil.getKotlinPathsF\u2026eaPlugin().kotlinTestPath");
        return file;
    }

    @Override
    protected boolean hasLibJarInLibrary(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        return KotlinLibraryUtilKt.getTestJar(library) != null;
    }

    @Override
    @NotNull
    protected AddKotlinLibQuickFix.MavenExternalLibraryDescriptor getLibraryDescriptor(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return new AddKotlinLibQuickFix.MavenExternalLibraryDescriptor("org.jetbrains.kotlin", "kotlin-test", AddKotlinLibQuickFix.Companion.getKotlinStdlibVersion(module));
    }

    public AddTestLibQuickFix(@NotNull KtElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super(element2);
    }

    static {
        Companion = new Companion(null);
        KOTLIN_TEST_UNRESOLVED = SetsKt.setOf((Object[])new String[]{"Asserter", "assertFailsWith", "currentStackTrace", "failsWith", "todo", "assertEquals", "assertFails", "assertNot", "assertNotEquals", "assertNotNull", "assertNull", "assertTrue", "expect", "fail", "fails"});
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddTestLibQuickFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "KOTLIN_TEST_UNRESOLVED", "", "", "getKOTLIN_TEST_UNRESOLVED", "()Ljava/util/Set;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public final Set<String> getKOTLIN_TEST_UNRESOLVED() {
            return KOTLIN_TEST_UNRESOLVED;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 unresolvedReference = (DiagnosticWithParameters1)Errors.UNRESOLVED_REFERENCE.cast(diagnostic);
            if (PsiTreeUtil.getParentOfType((PsiElement)diagnostic.getPsiElement(), KtImportDirective.class) != null) {
                return null;
            }
            String unresolvedText = ((KtReferenceExpression)unresolvedReference.getA()).getText();
            if (this.getKOTLIN_TEST_UNRESOLVED().contains(unresolvedText)) {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                PsiFile psiFile = diagnostic.getPsiElement().getContainingFile();
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                KtFile ktFile = (KtFile)psiFile;
                if (ktFile == null) {
                    return null;
                }
                KtFile ktFile2 = ktFile;
                FqName exactImportFqName = new FqName("kotlin.test." + unresolvedText);
                FqName kotlinTestAllUnder = new FqName("kotlin.test");
                boolean hasExactImport = false;
                boolean hasKotlinTestAllUnder = false;
                Iterable iterable = ktFile2.getImportDirectives();
                void var12_10 = $receiver$iv;
                Collection collection = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    KtImportDirective it = (KtImportDirective)element$iv$iv;
                    if (!StringsKt.contains$default((CharSequence)it.getText(), (CharSequence)"kotlin.test.", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Object importDirective : (List)destination$iv$iv) {
                    if (Intrinsics.areEqual((Object)((KtImportDirective)importDirective).getImportedFqName(), (Object)exactImportFqName)) {
                        hasExactImport = true;
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)((KtImportDirective)importDirective).getImportedFqName(), (Object)kotlinTestAllUnder) || !((KtImportDirective)importDirective).isAllUnder()) continue;
                    hasKotlinTestAllUnder = true;
                    break;
                }
                if (hasExactImport || hasKotlinTestAllUnder) {
                    KotlinQuickFixAction kotlinQuickFixAction;
                    PsiElement $receiver$iv$iv2;
                    void $receiver$iv2;
                    Object importDirective;
                    importDirective = diagnostic;
                    PsiElement psiElement = $receiver$iv2.getPsiElement();
                    PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv2, KtElement.class, (boolean)false);
                    if (psiElement2 != null) {
                        $receiver$iv$iv2 = psiElement2;
                        KtElement p1 = (KtElement)$receiver$iv$iv2;
                        kotlinQuickFixAction = new AddTestLibQuickFix(p1);
                    } else {
                        kotlinQuickFixAction = null;
                    }
                    return kotlinQuickFixAction;
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

