/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCopyEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myNewParent;
    private final String myNewChildName;

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile = this.myNewParent;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getNewParent"));
        }
        return virtualFile;
    }

    @NotNull
    public String getNewChildName() {
        String string = this.myNewChildName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getNewChildName"));
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[copy " + this.myFile + " to " + this.myNewParent + " as " + this.myNewChildName + "]";
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCopyEvent event = (VFileCopyEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewChildName.equals(event.myNewChildName)) {
            return false;
        }
        return this.myNewParent.equals(event.myNewParent);
    }

    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        result2 = 31 * result2 + this.myNewChildName.hashCode();
        return result2;
    }
}

