/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.jps.TimingLog;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsElementExtensionSerializerBase;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;

public abstract class JpsLoaderBase {
    private static final Logger LOG = Logger.getInstance(JpsLoaderBase.class);
    private static final int MAX_ATTEMPTS = 5;
    private final JpsMacroExpander myMacroExpander;

    protected JpsLoaderBase(JpsMacroExpander macroExpander) {
        this.myMacroExpander = macroExpander;
    }

    protected Element loadRootElement(File file) {
        return JpsLoaderBase.loadRootElement(file, this.myMacroExpander);
    }

    protected <E extends JpsElement> void loadComponents(File dir, String defaultFileName, JpsElementExtensionSerializerBase<E> serializer, E element) {
        String fileName = serializer.getConfigFileName();
        File configFile = new File(dir, fileName != null ? fileName : defaultFileName);
        Runnable timingLog = TimingLog.startActivity("loading: " + configFile.getName() + ":" + serializer.getComponentName());
        Element componentTag = configFile.exists() ? JDomSerializationUtil.findComponent(this.loadRootElement(configFile), serializer.getComponentName()) : null;
        if (componentTag != null) {
            serializer.loadExtension(element, componentTag);
        } else {
            serializer.loadExtensionWithDefaultSettings(element);
        }
        timingLog.run();
    }

    protected static Element loadRootElement(File file, JpsMacroExpander macroExpander) {
        try {
            Element element = JpsLoaderBase.tryLoadRootElement(file);
            macroExpander.substitute(element, SystemInfo.isFileSystemCaseSensitive);
            return element;
        }
        catch (JDOMException e) {
            throw new CannotLoadJpsModelException(file, "Cannot parse xml file " + file.getAbsolutePath() + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CannotLoadJpsModelException(file, "Cannot read file " + file.getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    private static Element tryLoadRootElement(File file) throws IOException, JDOMException {
        for (int i = 0; i < 4; ++i) {
            try {
                return JDOMUtil.loadDocument((File)file).getRootElement();
            }
            catch (Exception e) {
                LOG.info("Loading attempt #" + i + " failed", (Throwable)e);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return JDOMUtil.loadDocument((File)file).getRootElement();
    }
}

