/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.services;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleOperations
implements DeveloperServiceBuildSystemOperations {
    @Override
    public boolean canHandle(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/services/GradleOperations", "canHandle"));
        }
        return Projects.isBuildWithGradle(project);
    }

    @Override
    public boolean containsAllDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "containsAllDependencies"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/structure/services/GradleOperations", "containsAllDependencies"));
        }
        ArrayList moduleDependencyNames = Lists.newArrayList();
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(module);
        if (gradleBuildFile != null) {
            for (BuildFileStatement dependency : gradleBuildFile.getDependencies()) {
                Object data;
                if (!(dependency instanceof Dependency) || !((data = ((Dependency)dependency).data) instanceof String)) continue;
                String dependencyString = (String)data;
                ArrayList dependencyParts = Lists.newArrayList((Iterable)Splitter.on((char)':').split((CharSequence)dependencyString));
                if (dependencyParts.size() != 3) continue;
                moduleDependencyNames.add(dependencyParts.get(1));
            }
        }
        boolean allDependenciesFound = true;
        for (String serviceDependency : metadata.getDependencies()) {
            boolean thisDependencyFound = false;
            for (String moduleDependencyName : moduleDependencyNames) {
                if (!serviceDependency.contains(moduleDependencyName)) continue;
                thisDependencyFound = true;
                break;
            }
            if (thisDependencyFound) continue;
            allDependenciesFound = false;
            break;
        }
        return allDependenciesFound;
    }

    @Override
    public boolean isServiceInstalled(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "isServiceInstalled"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/structure/services/GradleOperations", "isServiceInstalled"));
        }
        GradleBuildFile gradleFile = GradleBuildFile.get(module);
        if (gradleFile != null) {
            List<BuildFileStatement> dependencies = gradleFile.getDependencies();
            for (BuildFileStatement statement : dependencies) {
                if (!(statement instanceof Dependency)) continue;
                Dependency dependency = (Dependency)statement;
                for (String dependencyValue : metadata.getDependencies()) {
                    if (!dependency.getValueAsString().equals(dependencyValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void removeDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "removeDependencies"));
        }
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/gradle/structure/services/GradleOperations", "removeDependencies"));
        }
        final GradleBuildFile gradleFile = GradleBuildFile.get(module);
        if (gradleFile != null) {
            boolean dependenciesChanged = false;
            final List<BuildFileStatement> dependencies = gradleFile.getDependencies();
            Iterator<BuildFileStatement> iterator = dependencies.iterator();
            block0: while (iterator.hasNext()) {
                BuildFileStatement statement = iterator.next();
                if (!(statement instanceof Dependency)) continue;
                Dependency dependency = (Dependency)statement;
                for (String dependencyValue : metadata.getDependencies()) {
                    if (!dependency.getValueAsString().equals(dependencyValue)) continue;
                    iterator.remove();
                    dependenciesChanged = true;
                    continue block0;
                }
            }
            Project project = module.getProject();
            if (dependenciesChanged) {
                new WriteCommandAction.Simple(project, "Uninstall " + metadata.getName(), new PsiFile[0]){

                    public void run() {
                        gradleFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
                    }
                }.execute();
            }
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }

    @Override
    public void initializeServices(@NotNull Module module, final @NotNull Runnable initializationTask) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/services/GradleOperations", "initializeServices"));
        }
        if (initializationTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializationTask", "com/android/tools/idea/gradle/structure/services/GradleOperations", "initializeServices"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/services/GradleOperations$2", "syncSucceeded"));
                }
                initializationTask.run();
            }
        });
    }

    @Override
    @NotNull
    public String getBuildSystemId() {
        if ("Gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/services/GradleOperations", "getBuildSystemId"));
        }
        return "Gradle";
    }

    @Override
    @Nullable
    public String getHighestVersion(@NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/android/tools/idea/gradle/structure/services/GradleOperations", "getHighestVersion"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/android/tools/idea/gradle/structure/services/GradleOperations", "getHighestVersion"));
        }
        GradleCoordinate gradleCoordinate = new GradleCoordinate(groupId, artifactId, new GradleCoordinate.RevisionComponent[]{GradleCoordinate.PLUS_REV});
        return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(gradleCoordinate, null);
    }
}

