/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.npw.ActivityGalleryStep;
import com.android.tools.idea.npw.AddAndroidActivityPath;
import com.android.tools.idea.npw.CircularParameterDependencyException;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.ImportUIUtil;
import com.android.tools.idea.npw.ParameterDefaultValueComputer;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.npw.WizardParameterFactory;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.ComboBoxItemWithApiTag;
import com.android.tools.idea.ui.LabelWithEditLink;
import com.android.tools.idea.ui.TextFieldWithLaunchBrowserButton;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.TextAccessor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TemplateParameterStep2
extends DynamicWizardStepWithDescription {
    public static final Logger LOG = Logger.getInstance(TemplateParameterStep2.class);
    public static final int COLUMN_COUNT = 3;
    private static final ScopedStateStore.Key<File> KEY_TEMPLATE_ICON = ScopedStateStore.createKey("page.template.icon", ScopedStateStore.Scope.STEP, File.class);
    private final Function<Parameter, ScopedStateStore.Key<?>> myParameterToKey;
    private final Map<String, Object> myPresetParameters;
    @NotNull
    private final ScopedStateStore.Key<String> myPackageNameKey;
    private final LoadingCache<File, Optional<Icon>> myThumbnailsCache;
    @Nullable
    private final FormFactorUtils.FormFactor myFormFactor;
    private final SourceProvider[] mySourceProviders;
    private JLabel myTemplateIcon;
    private JPanel myTemplateParameters;
    private JLabel myTemplateDescription;
    private JPanel myRootPanel;
    private JLabel myParameterDescription;
    private JSeparator myFooterSeparator;
    private Map<String, Object> myParameterDefaultValues;
    private TemplateEntry myCurrentTemplate;
    private JComboBox mySourceSet;
    private JLabel mySourceSetLabel;
    private boolean myUpdatingDefaults;
    private Map<Parameter, List<JComponent>> myParameterComponents;
    private final StringEvaluator myEvaluator;
    private Map<String, WizardParameterFactory> myExternalWizardParameterFactoryMap;
    private Map<JComponent, Parameter> myDataComponentParameters;
    private final String myStepTitle;

    public TemplateParameterStep2(@Nullable FormFactorUtils.FormFactor formFactor, Map<String, Object> presetParameters, @Nullable Disposable disposable, @NotNull ScopedStateStore.Key<String> packageNameKey, SourceProvider[] sourceProviders, String stepTitle) {
        if (packageNameKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNameKey", "com/android/tools/idea/npw/TemplateParameterStep2", "<init>"));
        }
        super(disposable);
        this.$$$setupUI$$$();
        this.myPresetParameters = Maps.newHashMap();
        this.myThumbnailsCache = CacheBuilder.newBuilder().build((CacheLoader)new TemplateIconLoader());
        this.myParameterDefaultValues = Maps.newHashMap();
        this.myUpdatingDefaults = false;
        this.myParameterComponents = new WeakHashMap<Parameter, List<JComponent>>();
        this.myEvaluator = new StringEvaluator();
        this.myExternalWizardParameterFactoryMap = null;
        this.myDataComponentParameters = new WeakHashMap<JComponent, Parameter>();
        this.myFormFactor = formFactor;
        this.mySourceProviders = sourceProviders;
        this.myPresetParameters.putAll(presetParameters);
        this.myPackageNameKey = packageNameKey;
        this.myParameterToKey = CacheBuilder.newBuilder().weakKeys().build(CacheLoader.from((Function)new ParameterKeyFunction()));
        this.myRootPanel.setBorder(TemplateParameterStep2.createBodyBorder());
        this.myTemplateDescription.setBorder(BorderFactory.createEmptyBorder(0, 0, this.myTemplateDescription.getFont().getSize(), 0));
        this.setBodyComponent(this.myRootPanel);
        this.myStepTitle = stepTitle;
    }

    private static JComponent createTextFieldWithBrowse(Parameter parameter) {
        String sourceUrl = parameter.sourceUrl;
        if (sourceUrl == null) {
            LOG.warn(String.format("Source URL is missing for parameter %1$s", parameter.name));
            sourceUrl = "";
        }
        return new TextFieldWithLaunchBrowserButton(sourceUrl);
    }

    public void setPresetValue(@NotNull String key, @Nullable Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/npw/TemplateParameterStep2", "setPresetValue"));
        }
        this.myPresetParameters.put(key, value);
        this.invokeUpdate(null);
    }

    private static JComponent createEnumCombo(Parameter parameter) {
        List<Element> options = parameter.getOptions();
        ComboBoxItemWithApiTag[] items = new ComboBoxItemWithApiTag[options.size()];
        int initialSelection = -1;
        int i = 0;
        assert (!options.isEmpty());
        for (Element option : options) {
            items[i++] = TemplateParameterStep2.createItemForOption(parameter, option);
            String isDefault = option.getAttribute("default");
            if (isDefault == null || isDefault.isEmpty() || !Boolean.valueOf(isDefault).booleanValue()) continue;
            initialSelection = i - 1;
        }
        JComboBox<ComboBoxItemWithApiTag> comboBox = new JComboBox<ComboBoxItemWithApiTag>(items);
        comboBox.setSelectedIndex(initialSelection);
        return comboBox;
    }

    public static ComboBoxItemWithApiTag createItemForOption(Parameter parameter, Element option) {
        String optionId = option.getAttribute("id");
        assert (optionId != null && !optionId.isEmpty()) : "id";
        NodeList childNodes = option.getChildNodes();
        assert (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3);
        String optionLabel = childNodes.item(0).getNodeValue().trim();
        int minSdk = TemplateParameterStep2.getIntegerOptionValue(option, "minApi", parameter.name, 1);
        int minBuildApi = TemplateParameterStep2.getIntegerOptionValue(option, "minBuildApi", parameter.name, 1);
        return new ComboBoxItemWithApiTag(optionId, optionLabel, minSdk, minBuildApi);
    }

    private static int getIntegerOptionValue(Element option, String attribute, @Nullable String parameterName, int defaultValue) {
        String stringValue = option.getAttribute(attribute);
        try {
            return StringUtil.isEmpty((String)stringValue) ? defaultValue : Integer.parseInt(stringValue);
        }
        catch (Exception e) {
            LOG.warn(String.format("Invalid %1$s value (%2$s) for option %3$s in parameter %4$s", attribute, stringValue, option.getAttribute("id"), parameterName), (Throwable)e);
            return defaultValue;
        }
    }

    private static int addComponent(JComponent parent, JComponent component, int row, int column, boolean isLast) {
        GridConstraints gridConstraints = new GridConstraints();
        gridConstraints.setRow(row);
        gridConstraints.setColumn(column);
        boolean isGreedyComponent = component instanceof JTextField || component instanceof Spacer || component instanceof LabelWithEditLink || component instanceof TextAccessor || component instanceof EditorComboBox;
        int columnSpan = isLast && isGreedyComponent ? 3 - column : 1;
        gridConstraints.setColSpan(columnSpan);
        gridConstraints.setAnchor(0);
        gridConstraints.setHSizePolicy(isGreedyComponent ? 6 : 1);
        gridConstraints.setVSizePolicy(component instanceof Spacer ? 6 : 0);
        gridConstraints.setFill(1);
        parent.add((Component)component, gridConstraints);
        if (isLast && !isGreedyComponent && column < 2) {
            TemplateParameterStep2.addComponent(parent, (JComponent)new Spacer(), row, column + 1, true);
        }
        return columnSpan;
    }

    private Map<Parameter, Object> getParameterObjectMap(Collection<Parameter> parameters, Map<Parameter, Object> parametersWithDefaultValues, Map<Parameter, Object> parametersWithNonDefaultValues) throws CircularParameterDependencyException {
        ParameterDefaultValueComputer computer = new ParameterDefaultValueComputer(parameters, parametersWithNonDefaultValues, this.getImplicitParameters(), new DeduplicateValuesFunction());
        Map<Parameter, Object> computedDefaultValues = computer.getParameterValues();
        HashMap parameterValues = Maps.newHashMap(parametersWithDefaultValues);
        for (Map.Entry<Parameter, Object> entry : computedDefaultValues.entrySet()) {
            if (parametersWithNonDefaultValues.keySet().contains(entry.getKey()) || entry.getValue() == null) continue;
            parameterValues.put(entry.getKey(), entry.getValue());
        }
        return parameterValues;
    }

    private Map<String, Object> getImplicitParameters() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (ScopedStateStore.Key<?> parameter : AddAndroidActivityPath.IMPLICIT_PARAMETERS) {
            Object value = this.myState.get(parameter);
            if (value == null) continue;
            builder.put((Object)parameter.name, value);
        }
        return builder.build();
    }

    @Override
    public boolean isStepVisible() {
        return this.myState.get(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE) != null && this.myState.getNotNull(WizardConstants.IS_LIBRARY_KEY, false) == false && super.isStepVisible();
    }

    @NotNull
    private List<JComponent> createComponents(Parameter parameter) {
        JComponent dataComponent;
        JLabel label = new JLabel(parameter.name + ":");
        if (AddAndroidActivityPath.PACKAGE_NAME_PARAMETERS.contains(parameter.id)) {
            Module module = this.getModule();
            dataComponent = module != null ? this.createPackageEntry(parameter, module) : new LabelWithEditLink();
        } else if (AddAndroidActivityPath.CLASS_NAME_PARAMETERS.contains(parameter.id)) {
            Module module = this.getModule();
            dataComponent = module != null ? this.createClassEntry(parameter, module) : new JTextField();
        } else {
            switch (parameter.type) {
                case BOOLEAN: {
                    label = null;
                    dataComponent = new JCheckBox(parameter.name);
                    break;
                }
                case ENUM: {
                    dataComponent = TemplateParameterStep2.createEnumCombo(parameter);
                    break;
                }
                case EXTERNAL: {
                    dataComponent = TemplateParameterStep2.createTextFieldWithBrowse(parameter);
                    break;
                }
                case STRING: {
                    dataComponent = new JTextField();
                    break;
                }
                case SEPARATOR: {
                    List<JComponent> list = Collections.singletonList(new JSeparator(0));
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateParameterStep2", "createComponents"));
                    }
                    return list;
                }
                case CUSTOM: {
                    JComponent createdComponent = null;
                    try {
                        WizardParameterFactory factory = this.getExternalFactory(parameter.externalTypeName);
                        if (factory != null) {
                            createdComponent = factory.createComponent(parameter.externalTypeName, parameter);
                        }
                        if (createdComponent == null) {
                            LOG.error(String.format("Bad registration for custom wizard type %1$s.  See ExternalWizardParameterFactory extension point.", Strings.isNullOrEmpty((String)parameter.externalTypeName) ? "(null)" : parameter.externalTypeName));
                            createdComponent = new JTextField();
                        }
                    }
                    catch (Exception e) {
                        LOG.error(String.format("Exception creating class %1$s", parameter.externalTypeName), (Throwable)e);
                        createdComponent = new JTextField();
                    }
                    dataComponent = createdComponent;
                    break;
                }
                default: {
                    throw new IllegalStateException(parameter.type.toString());
                }
            }
        }
        if (!StringUtil.isEmpty((String)parameter.help) && dataComponent.getAccessibleContext() != null) {
            dataComponent.getAccessibleContext().setAccessibleDescription(parameter.help);
        }
        this.register(parameter, dataComponent);
        if (label != null) {
            label.setLabelFor(dataComponent);
        }
        List<JComponent> list = label != null ? Arrays.asList(label, dataComponent) : Arrays.asList(dataComponent);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateParameterStep2", "createComponents"));
        }
        return list;
    }

    @Nullable
    private WizardParameterFactory getExternalFactory(String uiTypeName) {
        if (Strings.isNullOrEmpty((String)uiTypeName)) {
            return null;
        }
        if (this.myExternalWizardParameterFactoryMap == null) {
            WizardParameterFactory[] factories;
            HashMap<String, WizardParameterFactory> externalWizardParameterFactoryHashMap = new HashMap<String, WizardParameterFactory>();
            for (WizardParameterFactory factory : factories = (WizardParameterFactory[])Extensions.getExtensions(WizardParameterFactory.EP_NAME)) {
                String[] types = factory.getSupportedTypes();
                if (types == null) continue;
                for (String type : types) {
                    if (externalWizardParameterFactoryHashMap.containsKey(type)) {
                        LOG.error("Duplicate ExternalWizardParameterFactory registration on Type:" + type);
                        continue;
                    }
                    externalWizardParameterFactoryHashMap.put(type, factory);
                }
            }
            this.myExternalWizardParameterFactoryMap = externalWizardParameterFactoryHashMap;
        }
        return this.myExternalWizardParameterFactoryMap.get(uiTypeName);
    }

    private JComponent createClassEntry(@NotNull Parameter parameter, @NotNull Module module) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/TemplateParameterStep2", "createClassEntry"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/npw/TemplateParameterStep2", "createClassEntry"));
        }
        ChooseClassAction browseAction = new ChooseClassAction(parameter, module);
        String historyKey = AddAndroidActivityPath.getRecentHistoryKey(parameter.id);
        RecentsManager.getInstance((Project)module.getProject()).registerRecentEntry(historyKey, "");
        ReferenceEditorComboWithBrowseButton control = new ReferenceEditorComboWithBrowseButton((ActionListener)browseAction, "", module.getProject(), true, (JavaCodeFragment.VisibilityChecker)new OnlyShowActivities(module), historyKey);
        if (!StringUtil.isEmpty((String)control.getText())) {
            control.prependItem("");
            control.setText("");
        }
        this.addJBDocumentListener(((EditorComboBox)control.getChildComponent()).getDocument(), (JComponent)control);
        control.setPreferredSize(new Dimension(1, 1));
        return control;
    }

    private JComponent createPackageEntry(@NotNull Parameter parameter, @NotNull Module module) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/TemplateParameterStep2", "createPackageEntry"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/npw/TemplateParameterStep2", "createPackageEntry"));
        }
        Project project = module.getProject();
        Document doc = JavaReferenceEditorUtil.createDocument((String)"", (Project)project, (boolean)false, (JavaCodeFragment.VisibilityChecker)JavaCodeFragment.VisibilityChecker.PROJECT_SCOPE_VISIBLE);
        assert (doc != null);
        EditorComboBox textField = new EditorComboBox(doc, project, (FileType)StdFileTypes.JAVA);
        List<String> recentEntries = AddAndroidActivityPath.getParameterValueHistory(parameter, project);
        if (recentEntries != null) {
            textField.setHistory(ArrayUtil.toStringArray(recentEntries));
        }
        this.addJBDocumentListener(doc, (JComponent)textField);
        textField.setPreferredSize(new Dimension(1, 1));
        return textField;
    }

    private void addJBDocumentListener(Document doc, final JComponent textField) {
        DocumentAdapter listener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                TemplateParameterStep2.this.saveState(textField);
            }
        };
        Disposable disposable = this.getDisposable();
        if (disposable != null) {
            doc.addDocumentListener((DocumentListener)listener, disposable);
        } else {
            doc.addDocumentListener((DocumentListener)listener);
        }
    }

    private void register(Parameter parameter, JComponent dataComponent) {
        this.myDataComponentParameters.put(dataComponent, parameter);
        ScopedStateStore.Key<Boolean> key = this.getParameterKey(parameter);
        if (dataComponent instanceof JCheckBox) {
            this.register(key, (JCheckBox)dataComponent);
        } else if (dataComponent instanceof EditorComboBox) {
            this.register(key, (EditorComboBox)dataComponent, new ScopedDataBinder.ComponentBinding<String, EditorComboBox>(){

                @Override
                public void setValue(@Nullable String newValue, @NotNull EditorComboBox component) {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$2", "setValue"));
                    }
                    String text = Strings.nullToEmpty((String)newValue);
                    component.prependItem(text);
                    component.setText(text);
                }

                @Override
                @Nullable
                public String getValue(@NotNull EditorComboBox component) {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$2", "getValue"));
                    }
                    return component.getText();
                }
            });
        } else if (dataComponent instanceof JComboBox) {
            this.register(key, (JComboBox)dataComponent);
        } else if (dataComponent instanceof JTextField) {
            this.register(key, (JTextField)dataComponent);
        } else if (dataComponent instanceof TextFieldWithBrowseButton) {
            this.register(key, (TextFieldWithBrowseButton)dataComponent);
        } else if (dataComponent instanceof LabelWithEditLink) {
            this.register(key, (LabelWithEditLink)dataComponent, new ScopedDataBinder.ComponentBinding<String, LabelWithEditLink>(){

                @Override
                public void setValue(@Nullable String newValue, @NotNull LabelWithEditLink component) {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$3", "setValue"));
                    }
                    component.setText(Strings.nullToEmpty((String)newValue));
                }

                @Override
                @Nullable
                public String getValue(@NotNull LabelWithEditLink component) {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$3", "getValue"));
                    }
                    return component.getText();
                }

                @Override
                @Nullable
                public javax.swing.text.Document getDocument(@NotNull LabelWithEditLink component) {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$3", "getDocument"));
                    }
                    return component.getDocument();
                }
            });
        } else if (dataComponent instanceof TextAccessor) {
            this.register(key, dataComponent, new ScopedDataBinder.ComponentBinding<String, JComponent>(){

                @Override
                public void setValue(@Nullable String newValue, @NotNull JComponent component) {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$4", "setValue"));
                    }
                    ((TextAccessor)component).setText(Strings.nullToEmpty((String)newValue));
                }

                @Override
                @Nullable
                public String getValue(@NotNull JComponent component) {
                    if (component == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$4", "getValue"));
                    }
                    return ((TextAccessor)component).getText();
                }
            });
        } else {
            WizardParameterFactory factory = this.getExternalFactory(parameter.externalTypeName);
            if (factory != null) {
                this.register(key, dataComponent, factory.createBinding(dataComponent, parameter));
            } else {
                throw new IllegalArgumentException(dataComponent.getClass().getName());
            }
        }
    }

    @Override
    protected JLabel getDescriptionLabel() {
        return this.myParameterDescription;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        if (this.myCurrentTemplate != null) {
            this.updateStateWithDefaults(this.myCurrentTemplate.getParameters());
            this.updateControlsEnabled();
            this.updateControlsVisibility();
        }
    }

    private void updateControlsEnabled() {
        if (this.myUpdatingDefaults) {
            return;
        }
        Map<String, Object> contextValues = this.getContextValues();
        for (Parameter parameter : this.myCurrentTemplate.getParameters()) {
            String enabledStr = parameter.enabled;
            if (StringUtil.isEmpty((String)enabledStr)) continue;
            boolean enabled = this.myEvaluator.evaluateBooleanExpression(enabledStr, contextValues, true);
            List<JComponent> components = this.myParameterComponents.get(parameter);
            if (components == null) continue;
            for (JComponent component : components) {
                Parameter componentParameter = this.myDataComponentParameters.get(component);
                if (!enabled && componentParameter != null) {
                    this.myState.remove(this.getParameterKey(componentParameter));
                    this.updateStateWithDefaults(Sets.newHashSet((Object[])new Parameter[]{componentParameter}));
                }
                component.setEnabled(enabled);
            }
        }
    }

    private void updateControlsVisibility() {
        if (this.myUpdatingDefaults) {
            return;
        }
        Map<String, Object> contextValues = this.getContextValues();
        for (Parameter parameter : this.myCurrentTemplate.getParameters()) {
            String visibility = parameter.visibility;
            if (StringUtil.isEmpty((String)visibility)) continue;
            boolean visible = this.myEvaluator.evaluateBooleanExpression(visibility, contextValues, true);
            List<JComponent> components = this.myParameterComponents.get(parameter);
            if (components == null) continue;
            for (JComponent component : components) {
                component.setVisible(visible);
            }
        }
    }

    private Map<String, Object> getContextValues() {
        HashMap values = Maps.newHashMap();
        for (ScopedStateStore.Key key : this.myState.getAllKeys()) {
            values.put(key.name, this.myState.get(key));
        }
        return values;
    }

    @Override
    public boolean validate() {
        this.setErrorHtml(null);
        AndroidVersion minApi = this.myState.get(AddAndroidActivityPath.KEY_MIN_SDK);
        Integer buildApi = this.myState.get(AddAndroidActivityPath.KEY_BUILD_SDK);
        TemplateEntry templateEntry = this.myState.get(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE);
        if (templateEntry == null) {
            return false;
        }
        for (Parameter param : templateEntry.getParameters()) {
            if (param == null) continue;
            Object value = this.getStateParameterValue(param);
            String error = param.validate(this.getProject(), this.getModule(), this.myState.get(AddAndroidActivityPath.KEY_SOURCE_PROVIDER), this.myState.get(this.myPackageNameKey), value != null ? value : "", this.getRelatedValues(param));
            if (error != null) {
                this.setErrorHtml(error);
                return false;
            }
            if (!(value instanceof ComboBoxItemWithApiTag)) continue;
            ComboBoxItemWithApiTag selectedItem = (ComboBoxItemWithApiTag)value;
            if (minApi != null && selectedItem.minApi > minApi.getFeatureLevel()) {
                this.setErrorHtml(String.format("The \"%s\" option for %s requires a minimum API level of %d", selectedItem.label, param.name, selectedItem.minApi));
                return false;
            }
            if (buildApi == null || selectedItem.minBuildApi <= buildApi) continue;
            this.setErrorHtml(String.format("The \"%s\" option for %s requires a minimum API level of %d", selectedItem.label, param.name, selectedItem.minBuildApi));
            return false;
        }
        return true;
    }

    private Set<Object> getRelatedValues(Parameter param) {
        HashSet relatedValues = Sets.newHashSet();
        for (Parameter related : param.template.getRelatedParams(param)) {
            relatedValues.add(this.getStateParameterValue(related));
        }
        return relatedValues;
    }

    @Override
    public void init() {
        super.init();
        if (this.mySourceProviders.length > 0) {
            this.myState.put(AddAndroidActivityPath.KEY_SOURCE_PROVIDER, this.mySourceProviders[0]);
            this.myState.put(AddAndroidActivityPath.KEY_SOURCE_PROVIDER_NAME, this.mySourceProviders[0].getName());
        }
        this.register(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE, (JComponent)this.myTemplateDescription.getParent(), new ScopedDataBinder.ComponentBinding<TemplateEntry, JComponent>(){

            @Override
            public void setValue(@Nullable TemplateEntry newValue, @NotNull JComponent component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$5", "setValue"));
                }
                TemplateParameterStep2.this.setSelectedTemplate(newValue);
            }
        });
        this.register(KEY_DESCRIPTION, this.myFooterSeparator, new ScopedDataBinder.ComponentBinding<String, JSeparator>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JSeparator component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$6", "setValue"));
                }
                component.setVisible(!StringUtil.isEmpty((String)newValue));
            }
        });
        this.register(KEY_TEMPLATE_ICON, this.myTemplateIcon, new ScopedDataBinder.ComponentBinding<File, JLabel>(){

            @Override
            public void setValue(@Nullable File newValue, @NotNull JLabel component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/TemplateParameterStep2$7", "setValue"));
                }
                Optional thumbnail = newValue == null ? Optional.absent() : (Optional)TemplateParameterStep2.this.myThumbnailsCache.getUnchecked((Object)newValue);
                Icon icon = (Icon)thumbnail.orNull();
                component.setIcon(icon);
                component.setVisible(icon != null);
            }
        });
        this.registerValueDeriver(KEY_TEMPLATE_ICON, new ScopedDataBinder.ValueDeriver<File>(){

            @Override
            @Nullable
            public File deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable File currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/TemplateParameterStep2$8", "deriveValue"));
                }
                return TemplateParameterStep2.this.getTemplateIconPath(state.get(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE));
            }
        });
        this.registerValueDeriver(AddAndroidActivityPath.KEY_SOURCE_PROVIDER_NAME, new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/TemplateParameterStep2$9", "deriveValue"));
                }
                SourceProvider sourceProvider = state.get(AddAndroidActivityPath.KEY_SOURCE_PROVIDER);
                return sourceProvider == null ? null : sourceProvider.getName();
            }
        });
    }

    @Nullable
    private File getTemplateIconPath(@Nullable TemplateEntry entry) {
        if (entry == null) {
            return null;
        }
        String path = entry.getMetadata().getThumbnailPath(new Function<String, Object>(){

            public Object apply(String variableName) {
                Map contextValues = TemplateParameterStep2.this.getContextValues();
                Object value = contextValues.get(variableName);
                if (value == null) {
                    LOG.warn("Thumbnail variable not found: " + variableName);
                }
                return value != null ? value.toString() : null;
            }
        });
        if (!StringUtil.isEmpty((String)path)) {
            File file = new File(entry.getTemplateDir(), FileUtilRt.toSystemDependentName((String)path, (char)'/'));
            return file.isFile() ? file : null;
        }
        return null;
    }

    private void setSelectedTemplate(@Nullable TemplateEntry template) {
        if (template == null) {
            return;
        }
        TemplateMetadata metadata = template.getMetadata();
        this.myTemplateIcon.setText(template.getTitle());
        String string = ImportUIUtil.makeHtmlString(metadata.getDescription());
        this.myTemplateDescription.setText(string);
        this.updateControls(template);
    }

    private void updateControls(@Nullable TemplateEntry entry) {
        ImmutableSet parameters;
        if (Objects.equal((Object)this.myCurrentTemplate, (Object)entry)) {
            return;
        }
        this.myCurrentTemplate = entry;
        if (entry != null) {
            this.updateStateWithDefaults(entry.getParameters());
            parameters = ImmutableSet.copyOf(this.filterNonUIParameters(entry));
        } else {
            parameters = ImmutableSet.of();
        }
        for (Component component : this.myTemplateParameters.getComponents()) {
            this.myTemplateParameters.remove(component);
            if (!(component instanceof JComponent)) continue;
            this.deregister((JComponent)component);
        }
        int lastRow = this.addParameterComponents(parameters.size() + 1, (Set<Parameter>)parameters);
        this.addSourceSetControls(lastRow);
    }

    private int addParameterComponents(int rowCount, Set<Parameter> parameters) {
        CellLocation location = new CellLocation();
        this.myTemplateParameters.removeAll();
        GridLayoutManager layout = new GridLayoutManager(rowCount + 1, 3);
        layout.setSameSizeHorizontally(false);
        this.myTemplateParameters.setLayout((LayoutManager)layout);
        for (Parameter parameter : parameters) {
            this.addComponents(parameter, location);
        }
        if (location.column > 0) {
            if (location.column < 3) {
                TemplateParameterStep2.addComponent(this.myTemplateParameters, (JComponent)new Spacer(), location.row, location.column, true);
            }
            ++location.row;
        }
        return location.row;
    }

    private void addSourceSetControls(int row) {
        if (this.mySourceProviders.length > 1) {
            if (this.mySourceSetLabel == null) {
                this.mySourceSetLabel = new JLabel("Target Source Set:");
                this.mySourceSet = new JComboBox();
                this.register(AddAndroidActivityPath.KEY_SOURCE_PROVIDER, this.mySourceSet);
                this.setControlDescription(this.mySourceSet, "The selected folder contains multiple source sets, this can include source sets that do not yet exist on disk. Please select the target source set in which to create the files.");
            }
            this.mySourceSet.removeAllItems();
            for (SourceProvider sourceProvider : this.mySourceProviders) {
                this.mySourceSet.addItem(new ComboBoxItemWithApiTag(sourceProvider, sourceProvider.getName(), 0, 0));
            }
            TemplateParameterStep2.addComponent(this.myTemplateParameters, this.mySourceSetLabel, row, 0, false);
            TemplateParameterStep2.addComponent(this.myTemplateParameters, this.mySourceSet, row, 1, true);
        }
    }

    private Iterable<Parameter> filterNonUIParameters(TemplateEntry entry) {
        return Iterables.filter(entry.getParameters(), (Predicate)new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return input != null && !StringUtil.isEmpty((String)input.name) && !TemplateParameterStep2.this.myPresetParameters.containsKey(input.id);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStateWithDefaults(Collection<Parameter> parameters) {
        if (this.myUpdatingDefaults) {
            return;
        }
        this.myUpdatingDefaults = true;
        try {
            for (Parameter parameter : parameters) {
                if (!this.myPresetParameters.containsKey(parameter.id)) continue;
                this.myState.unsafePut(this.getParameterKey(parameter), this.myPresetParameters.get(parameter.id));
            }
            try {
                Map<Parameter, Object> parameterDefaults = this.refreshParameterDefaults(parameters, this.myParameterDefaultValues);
                for (Map.Entry<Parameter, Object> entry : parameterDefaults.entrySet()) {
                    this.myState.unsafePut(this.getParameterKey(entry.getKey()), entry.getValue());
                    this.myParameterDefaultValues.put(entry.getKey().id, entry.getValue());
                }
            }
            catch (CircularParameterDependencyException exception) {
                LOG.error("Circular dependency between parameters in template %1$s, participating parameters: %2$s", (Throwable)exception, new String[]{this.myCurrentTemplate.getTitle(), Joiner.on((String)", ").join(exception.getParameterIds())});
            }
        }
        finally {
            this.myUpdatingDefaults = false;
        }
    }

    private Map<Parameter, Object> refreshParameterDefaults(Collection<Parameter> parameters, Map<String, Object> defaultValues) throws CircularParameterDependencyException {
        HashMap parametersAtDefault = Maps.newHashMap();
        HashMap parametersAtNonDefault = Maps.newHashMap();
        for (Parameter parameter : parameters) {
            if (this.isDefaultParameterValue(parameter, defaultValues)) {
                parametersAtDefault.put(parameter, defaultValues.get(parameter.id));
                continue;
            }
            parametersAtNonDefault.put(parameter, this.getStateParameterValue(parameter));
        }
        return this.getParameterObjectMap(parameters, parametersAtDefault, parametersAtNonDefault);
    }

    @NotNull
    public ScopedStateStore.Key<?> getParameterKey(@NotNull Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/TemplateParameterStep2", "getParameterKey"));
        }
        ScopedStateStore.Key key = (ScopedStateStore.Key)this.myParameterToKey.apply((Object)parameter);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateParameterStep2", "getParameterKey"));
        }
        return key;
    }

    @Nullable
    private Object getStateParameterValue(Parameter parameter) {
        if (this.myPresetParameters.containsKey(parameter.id)) {
            return this.myPresetParameters.get(parameter.id);
        }
        return this.myState.get(this.getParameterKey(parameter));
    }

    private boolean isDefaultParameterValue(Parameter parameter, Map<String, Object> defaultValues) {
        Object stateValue = this.getStateParameterValue(parameter);
        if (stateValue == null) {
            return true;
        }
        Object defaultValue = defaultValues.get(parameter.id);
        return Objects.equal((Object)defaultValue, (Object)stateValue);
    }

    private void addComponents(Parameter parameter, CellLocation location) {
        boolean isFullRow;
        List<JComponent> keyComponents = this.createComponents(parameter);
        boolean bl = isFullRow = keyComponents.size() > 1;
        if (isFullRow && location.column > 0 || location.column + keyComponents.size() > 3) {
            if (location.column < 3) {
                TemplateParameterStep2.addComponent(this.myTemplateParameters, (JComponent)new Spacer(), location.row, location.column, true);
            }
            location.column = 0;
            ++location.row;
        }
        if (location.column == 0 && keyComponents.size() == 1 && keyComponents.get(0) instanceof JCheckBox) {
            location.column += TemplateParameterStep2.addComponent(this.myTemplateParameters, new JLabel(), location.row, location.column, false);
        }
        this.myParameterComponents.put(parameter, keyComponents);
        Iterator<JComponent> iterator = keyComponents.iterator();
        while (iterator.hasNext()) {
            JComponent keyComponent = iterator.next();
            location.column = location.column + TemplateParameterStep2.addComponent(this.myTemplateParameters, keyComponent, location.row, location.column, isFullRow && !iterator.hasNext());
            this.setControlDescription(keyComponent, parameter.help);
        }
        if (isFullRow) {
            ++location.row;
            location.column = 0;
        }
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Template parameters" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateParameterStep2", "getStepName"));
        }
        return "Template parameters";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        String string = this.myStepTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/TemplateParameterStep2", "getStepTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    @Override
    @Nullable
    protected Icon getStepIcon() {
        return this.myFormFactor == null ? null : this.myFormFactor.getIcon();
    }

    public JComponent getPreferredFocusedComponent() {
        for (Component component : this.myTemplateParameters.getComponents()) {
            if (component instanceof JLabel || !component.isFocusable()) continue;
            return (JComponent)component;
        }
        return this.myTemplateParameters;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JSeparator jSeparator;
        JPanel jPanel;
        JLabel jLabel2;
        JLabel jLabel3;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTemplateIcon = jLabel3 = new JLabel();
        jLabel3.setHorizontalTextPosition(0);
        jLabel3.setVerticalTextPosition(3);
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 2, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateDescription = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTemplateParameters = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 1, 1, 2, 0, 1, 1, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFooterSeparator = jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(4, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myParameterDescription = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(5, 1, 1, 2, 8, 0, 1, 2, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(4, 0, 2, 1, 0, 2, 1, 0, null, new Dimension(-1, 48), null, 2));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class DeduplicateValuesFunction
    implements ParameterDefaultValueComputer.Deduplicator {
        private final Project project;
        private final Module module;
        private final SourceProvider provider;
        private final String packageName;

        private DeduplicateValuesFunction() {
            this.project = TemplateParameterStep2.this.getProject();
            this.module = TemplateParameterStep2.this.getModule();
            this.provider = TemplateParameterStep2.this.myState.get(AddAndroidActivityPath.KEY_SOURCE_PROVIDER);
            this.packageName = (String)TemplateParameterStep2.this.myState.get(TemplateParameterStep2.this.myPackageNameKey);
        }

        @Override
        @Nullable
        public String deduplicate(@NotNull Parameter parameter, @Nullable String value) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/TemplateParameterStep2$DeduplicateValuesFunction", "deduplicate"));
            }
            if (StringUtil.isEmpty((String)value) || !parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE)) {
                return value;
            }
            String suggested = value;
            String extension = FileUtilRt.getExtension((String)value);
            boolean hasExtension = !extension.isEmpty();
            int extensionOffset = value.length() - extension.length();
            int i = 2;
            while (!parameter.uniquenessSatisfied(this.project, this.module, this.provider, this.packageName, suggested, TemplateParameterStep2.this.getRelatedValues(parameter))) {
                suggested = hasExtension ? value.substring(0, extensionOffset) + i + value.substring(extensionOffset) : value + i;
                ++i;
            }
            return suggested;
        }
    }

    private static class TemplateIconLoader
    extends CacheLoader<File, Optional<Icon>> {
        private TemplateIconLoader() {
        }

        @Nullable
        public Optional<Icon> load(@NotNull File key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/npw/TemplateParameterStep2$TemplateIconLoader", "load"));
            }
            Logger log = Logger.getInstance(ActivityGalleryStep.class);
            try {
                if (key.isFile()) {
                    BufferedImage image = ImageIO.read(key);
                    if (image != null) {
                        return Optional.of((Object)new ImageIcon(image.getScaledInstance(256, 256, 4)));
                    }
                    log.error("File " + key.getAbsolutePath() + " exists but is not a valid image");
                } else {
                    log.error("Image file " + key.getAbsolutePath() + " was not found");
                }
            }
            catch (IOException e) {
                log.warn((Throwable)e);
            }
            return Optional.absent();
        }
    }

    private class ChooseClassAction
    implements ActionListener {
        private Parameter myParameter;
        @NotNull
        private final Module myModule;

        public ChooseClassAction(@NotNull Parameter parameter, Module module) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/android/tools/idea/npw/TemplateParameterStep2$ChooseClassAction", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/npw/TemplateParameterStep2$ChooseClassAction", "<init>"));
            }
            this.myParameter = parameter;
            this.myModule = module;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PsiClass aClass;
            final OnlyShowActivities filter = new OnlyShowActivities(this.myModule);
            Project project = this.myModule.getProject();
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createWithInnerClassesScopeChooser("Select Activity", GlobalSearchScope.projectScope((Project)project), new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return filter.isDeclarationVisible((PsiElement)aClass, null) == JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
            }, null);
            ScopedStateStore.Key<?> key = TemplateParameterStep2.this.getParameterKey(this.myParameter);
            String targetClassName = (String)TemplateParameterStep2.this.myState.get(key);
            if (targetClassName != null && (aClass = JavaPsiFacade.getInstance((Project)project).findClass(targetClassName, GlobalSearchScope.allScope((Project)project))) != null) {
                chooser.selectDirectory(aClass.getContainingFile().getContainingDirectory());
            }
            chooser.showDialog();
            aClass = chooser.getSelected();
            if (aClass != null) {
                TemplateParameterStep2.this.myState.put(key, aClass.getQualifiedName());
            }
        }
    }

    private static class OnlyShowActivities
    implements JavaCodeFragment.VisibilityChecker {
        private final Module myModule;

        public OnlyShowActivities(Module module) {
            this.myModule = module;
        }

        private static boolean isActivitySubclass(@NotNull PsiClass classDecl) {
            if (classDecl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDecl", "com/android/tools/idea/npw/TemplateParameterStep2$OnlyShowActivities", "isActivitySubclass"));
            }
            for (PsiClass superClass : classDecl.getSupers()) {
                String typename = superClass.getQualifiedName();
                if (!"android.app.Activity".equals(typename) && !OnlyShowActivities.isActivitySubclass(superClass)) continue;
                return true;
            }
            return false;
        }

        public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, @Nullable PsiElement place) {
            PsiClass classDecl;
            if (declaration instanceof PsiClass && PsiClassUtil.isRunnableClass((PsiClass)(classDecl = (PsiClass)declaration), (boolean)true, (boolean)true) && OnlyShowActivities.isActivitySubclass(classDecl) && this.isOnClasspath(classDecl)) {
                return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
            }
            return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
        }

        private boolean isOnClasspath(@NotNull PsiClass classDecl) {
            if (classDecl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDecl", "com/android/tools/idea/npw/TemplateParameterStep2$OnlyShowActivities", "isOnClasspath"));
            }
            GlobalSearchScope scope = this.myModule.getModuleWithDependenciesAndLibrariesScope(false);
            VirtualFile file = classDecl.getContainingFile().getVirtualFile();
            return scope.contains(file);
        }
    }

    private static class ParameterKeyFunction
    implements Function<Parameter, ScopedStateStore.Key<?>> {
        private ParameterKeyFunction() {
        }

        public ScopedStateStore.Key<?> apply(Parameter input) {
            Class clazz;
            switch (input.type) {
                case BOOLEAN: {
                    clazz = Boolean.class;
                    break;
                }
                case ENUM: 
                case EXTERNAL: 
                case STRING: 
                case SEPARATOR: 
                case CUSTOM: {
                    clazz = String.class;
                    break;
                }
                default: {
                    throw new IllegalStateException(input.type.toString());
                }
            }
            assert (input.id != null);
            return ScopedStateStore.createKey(input.id, ScopedStateStore.Scope.PATH, clazz);
        }
    }

    private static class CellLocation {
        public int row = 0;
        public int column = 0;

        private CellLocation() {
        }
    }
}

