/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.reflectasm.FieldAccess;

class ObjectField
extends FieldSerializer.CachedField {
    public Class[] generics;
    final FieldSerializer fieldSerializer;
    final Class type;
    final Kryo kryo;

    ObjectField(FieldSerializer fieldSerializer) {
        this.fieldSerializer = fieldSerializer;
        this.kryo = fieldSerializer.kryo;
        this.type = fieldSerializer.type;
    }

    public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.field.get(object);
    }

    public void setField(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(object, object2);
    }

    @Override
    public final void write(Output output, Object object) {
        try {
            Object object2 = this.getField(object);
            Serializer serializer = this.serializer;
            if (this.valueClass == null) {
                if (object2 == null) {
                    this.kryo.writeClass(output, null);
                    return;
                }
                Registration registration = this.kryo.writeClass(output, object2.getClass());
                if (serializer == null) {
                    serializer = registration.getSerializer();
                }
                serializer.setGenerics(this.kryo, this.generics);
                this.kryo.writeObject(output, object2, serializer);
            } else {
                if (serializer == null) {
                    this.serializer = serializer = this.kryo.getSerializer(this.valueClass);
                }
                serializer.setGenerics(this.kryo, this.generics);
                if (this.canBeNull) {
                    this.kryo.writeObjectOrNull(output, object2, serializer);
                } else {
                    if (object2 == null) {
                        throw new KryoException("Field value is null but canBeNull is false: " + this + " (" + object.getClass().getName() + ")");
                    }
                    this.kryo.writeObject(output, object2, serializer);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KryoException("Error accessing field: " + this + " (" + object.getClass().getName() + ")", illegalAccessException);
        }
        catch (KryoException kryoException) {
            kryoException.addTrace(this + " (" + object.getClass().getName() + ")");
            throw kryoException;
        }
        catch (RuntimeException runtimeException) {
            KryoException kryoException = new KryoException(runtimeException);
            kryoException.addTrace(this + " (" + object.getClass().getName() + ")");
            throw kryoException;
        }
    }

    @Override
    public final void read(Input input, Object object) {
        try {
            Object var3_7;
            Class clazz = this.valueClass;
            Serializer serializer = this.serializer;
            if (clazz == null) {
                Registration registration = this.kryo.readClass(input);
                if (registration == null) {
                    var3_7 = null;
                } else {
                    if (serializer == null) {
                        serializer = registration.getSerializer();
                    }
                    serializer.setGenerics(this.kryo, this.generics);
                    var3_7 = this.kryo.readObject(input, registration.getType(), serializer);
                }
            } else {
                if (serializer == null) {
                    this.serializer = serializer = this.kryo.getSerializer(this.valueClass);
                }
                serializer.setGenerics(this.kryo, this.generics);
                var3_7 = this.canBeNull ? this.kryo.readObjectOrNull(input, clazz, serializer) : this.kryo.readObject(input, clazz, serializer);
            }
            this.setField(object, var3_7);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KryoException("Error accessing field: " + this + " (" + this.type.getName() + ")", illegalAccessException);
        }
        catch (KryoException kryoException) {
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
        catch (RuntimeException runtimeException) {
            KryoException kryoException = new KryoException(runtimeException);
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
    }

    @Override
    public void copy(Object object, Object object2) {
        try {
            if (this.accessIndex != -1) {
                FieldAccess fieldAccess = (FieldAccess)this.fieldSerializer.access;
                fieldAccess.set(object2, this.accessIndex, this.kryo.copy(fieldAccess.get(object, this.accessIndex)));
            } else {
                this.setField(object2, this.kryo.copy(this.getField(object)));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KryoException("Error accessing field: " + this + " (" + this.type.getName() + ")", illegalAccessException);
        }
        catch (KryoException kryoException) {
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
        catch (RuntimeException runtimeException) {
            KryoException kryoException = new KryoException(runtimeException);
            kryoException.addTrace(this + " (" + this.type.getName() + ")");
            throw kryoException;
        }
    }

    static final class ObjectDoubleField
    extends ObjectField {
        public ObjectDoubleField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getDouble(object);
        }
    }

    static final class ObjectLongField
    extends ObjectField {
        public ObjectLongField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getLong(object);
        }
    }

    static final class ObjectCharField
    extends ObjectField {
        public ObjectCharField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Character.valueOf(this.field.getChar(object));
        }
    }

    static final class ObjectBooleanField
    extends ObjectField {
        public ObjectBooleanField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getBoolean(object);
        }
    }

    static final class ObjectByteField
    extends ObjectField {
        public ObjectByteField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getByte(object);
        }
    }

    static final class ObjectShortField
    extends ObjectField {
        public ObjectShortField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getShort(object);
        }
    }

    static final class ObjectFloatField
    extends ObjectField {
        public ObjectFloatField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return Float.valueOf(this.field.getFloat(object));
        }
    }

    static final class ObjectIntField
    extends ObjectField {
        public ObjectIntField(FieldSerializer fieldSerializer) {
            super(fieldSerializer);
        }

        @Override
        public Object getField(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getInt(object);
        }
    }
}

