/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointType;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u001a(\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\r0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\u0006\u0010\u0002\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0017"}, d2={"canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "breakpointTypeClass", "Ljava/lang/Class;", "computeVariants", "", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant;", "Lcom/intellij/debugger/ui/breakpoints/JavaLineBreakpointType;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "kotlinBreakpointType", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType;", "getLambdasAtLineIfAny", "Lorg/jetbrains/kotlin/psi/KtFunction;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
public final class BreakpointTypeUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project, @NotNull Class<?> breakpointTypeClass) {
        void result2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(breakpointTypeClass, (String)"breakpointTypeClass");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || Intrinsics.areEqual((Object)psiFile.getVirtualFile().getFileType(), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        XDebuggerUtil.getInstance().iterateLine(project, document2, line, (Processor)new Processor<PsiElement>(line, document2, (Ref.ObjectRef)result2){
            final /* synthetic */ int $line;
            final /* synthetic */ Document $document;
            final /* synthetic */ Ref.ObjectRef $result;

            public final boolean invoke(@NotNull PsiElement el) {
                int offset2;
                Intrinsics.checkParameterIsNotNull((Object)el, (String)"el");
                if (el instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)el, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                PsiElement element2 = el;
                PsiElement parent2 = element2.getParent();
                while (parent2 != null && ((offset2 = parent2.getTextOffset()) < 0 || this.$document.getLineNumber(offset2) == this.$line)) {
                    element2 = parent2;
                    parent2 = element2.getParent();
                }
                if (element2 instanceof KtProperty || element2 instanceof KtParameter) {
                    this.$result.element = element2 instanceof KtParameter && ((KtParameter)element2).hasValOrVar() || element2 instanceof KtProperty && !((KtProperty)element2).isLocal() ? KotlinFieldBreakpointType.class : KotlinLineBreakpointType.class;
                    return false;
                }
                this.$result.element = KotlinLineBreakpointType.class;
                return true;
            }
            {
                this.$line = n;
                this.$document = document;
                this.$result = objectRef;
            }
        });
        return Intrinsics.areEqual((Object)((Class)result2.element), breakpointTypeClass);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position, @NotNull KotlinLineBreakpointType kotlinBreakpointType) {
        void $receiver$iv;
        SourcePosition pos;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinBreakpointType), (String)"kotlinBreakpointType");
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile());
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file = ktFile;
        SourcePosition sourcePosition2 = pos = SourcePosition.createFromLine((PsiFile)((PsiFile)file), (int)position.getLine());
        Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition2, (String)"pos");
        List<KtFunction> lambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(sourcePosition2);
        if (lambdas.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        LinkedList<Object> result2 = new LinkedList<Object>();
        PsiElement mainMethod = KotlinLineBreakpointType.getContainingMethod(pos.getElementAt());
        if (mainMethod != null) {
            XSourcePosition xSourcePosition = (XSourcePosition)XSourcePositionImpl.createByElement((PsiElement)mainMethod);
            PsiElement psiElement = CodeInsightUtils.getTopmostElementAtOffset(pos.getElementAt(), pos.getOffset());
            if (psiElement == null) {
                psiElement = mainMethod;
            }
            result2.add((Object)kotlinBreakpointType.new KotlinLineBreakpointType.KotlinLineBreakpointVariant(xSourcePosition, psiElement));
        }
        Iterable iterable = lambdas;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void lambda2;
            int n = index$iv++;
            KtFunction ktFunction = (KtFunction)item$iv;
            int ordinal = n;
            result2.add((Object)kotlinBreakpointType.new KotlinLineBreakpointType.KotlinLambdaBreakpointVariant((XSourcePosition)XSourcePositionImpl.createByElement((PsiElement)((PsiElement)lambda2.getBodyExpression())), (KtFunction)lambda2, ordinal));
        }
        KotlinLineBreakpointType kotlinLineBreakpointType = kotlinBreakpointType;
        if (kotlinLineBreakpointType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType");
        }
        JavaLineBreakpointType.JavaBreakpointVariant allBreakpoint = new JavaLineBreakpointType.JavaBreakpointVariant((JavaLineBreakpointType)kotlinLineBreakpointType, position);
        result2.addFirst(allBreakpoint);
        return result2;
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition2, (String)"sourcePosition");
        PsiFile psiFile = sourcePosition2.getFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file = ktFile;
        int lineNumber = sourcePosition2.getLine();
        return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(file, lineNumber);
    }

    @NotNull
    public static final List<KtFunction> getLambdasAtLineIfAny(@NotNull KtFile file, int line) {
        Collection destination$iv$iv;
        PsiElement it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, line) == null) {
            return CollectionsKt.emptyList();
        }
        Integer n = JetRefactoringUtilKt.getLineEndOffset((PsiFile)file, line);
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int lineEndOffset = ((Number)n).intValue();
        PsiElement topMostElement = null;
        for (int lineStartOffset = ((Number)(v882307)).intValue(); !(topMostElement instanceof KtElement) && lineStartOffset < lineEndOffset; ++lineStartOffset) {
            PsiElement elementAt = file.findElementAt(lineStartOffset);
            if (elementAt == null) continue;
            topMostElement = CodeInsightUtils.getTopmostElementAtOffset(elementAt, lineStartOffset);
        }
        if (!(topMostElement instanceof KtElement)) {
            return CollectionsKt.emptyList();
        }
        int start = PsiUtilsKt.getStartOffset(topMostElement);
        int end = PsiUtilsKt.getEndOffset(topMostElement);
        Iterable iterable = CodeInsightUtils.findElementsOfClassInRange((PsiFile)file, start, end, KtFunction.class);
        void var10_9 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiElement psiElement = it = (PsiElement)element$iv$iv;
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            if (!(KtPsiUtil.getParentCallIfPresent((KtExpression)psiElement) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set allInlineFunctionCalls = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $receiver$iv = allInlineFunctionCalls;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object statement2;
            Object object;
            it = (KtFunction)element$iv$iv;
            KtExpression ktExpression = it.getBodyExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if ((object = (KtBlockExpression)ktExpression) == null || (object = ((KtBlockExpression)object).getStatements()) == null || (object = (KtExpression)CollectionsKt.firstOrNull((List)object)) == null) {
                object = (KtExpression)it;
            }
            if (!(JetRefactoringUtilKt.getLineNumber$default((PsiElement)(statement2 = object), false, 1, null) == line && JetRefactoringUtilKt.getLineNumber((PsiElement)statement2, false) == line)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

