/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JavaSdkVersionUtil {
    public static boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion minVersion) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/JavaSdkVersionUtil", "isAtLeast"));
        }
        if (minVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minVersion", "com/intellij/openapi/projectRoots/JavaSdkVersionUtil", "isAtLeast"));
        }
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion(element);
        return version == null || version.isAtLeast(minVersion);
    }

    public static JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        Sdk sdk;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/JavaSdkVersionUtil", "getJavaSdkVersion"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(element);
        if (module != null && (sdk = ModuleRootManager.getInstance(module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdk) {
            String version = sdk.getVersionString();
            return version == null ? null : JdkVersionUtil.getVersion(version);
        }
        return null;
    }
}

