/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.admin.IAdminWriter;
import org.netbeans.lib.cvsclient.event.ICvsListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IDirectoryListener;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.ILocalFileReader;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class DirectoryPruner
implements ICvsListener,
IDirectoryListener {
    private final List directoriesToScan = new ArrayList();
    private final IClientEnvironment clientEnvironment;

    public DirectoryPruner(IClientEnvironment clientEnvironment) {
        BugLog.getInstance().assertNotNull(clientEnvironment);
        this.clientEnvironment = clientEnvironment;
    }

    @Override
    public void processingDirectory(DirectoryObject directoryObject) {
        if (directoryObject.isRoot()) {
            return;
        }
        if (this.directoriesToScan.contains(directoryObject)) {
            return;
        }
        this.directoriesToScan.add(directoryObject);
    }

    @Override
    public void registerListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.addDirectoryListener(this);
    }

    @Override
    public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.removeDirectoryListener(this);
    }

    public final void pruneEmptyDirectories() throws IOException {
        while (this.directoriesToScan.size() > 0) {
            DirectoryObject directoryObject = (DirectoryObject)this.directoriesToScan.remove(0);
            this.pruneEmptyDirectory(directoryObject);
        }
    }

    private boolean pruneEmptyDirectory(DirectoryObject directoryObject) throws IOException {
        ILocalFileReader localFileReader = this.clientEnvironment.getLocalFileReader();
        ICvsFileSystem cvsFileSystem = this.clientEnvironment.getCvsFileSystem();
        IAdminWriter adminWriter = this.clientEnvironment.getAdminWriter();
        IAdminReader adminReader = this.clientEnvironment.getAdminReader();
        this.directoriesToScan.remove(directoryObject);
        if (!localFileReader.exists(directoryObject, cvsFileSystem)) {
            return true;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<String> directoryNames = new ArrayList<String>();
        localFileReader.listFilesAndDirectories(directoryObject, fileNames, directoryNames, cvsFileSystem);
        if (fileNames.size() > 0) {
            return false;
        }
        if (this.hasFileEntry(directoryObject, cvsFileSystem, adminReader)) {
            return false;
        }
        for (String directoryName : directoryNames) {
            if (this.pruneEmptyDirectory(DirectoryObject.createInstance(directoryObject, directoryName))) continue;
            return false;
        }
        if (adminReader.hasCvsDirectory(directoryObject, cvsFileSystem)) {
            try {
                adminWriter.removeEntryForFile(directoryObject, cvsFileSystem);
            }
            catch (FileNotFoundException ex) {
                return false;
            }
            adminWriter.pruneDirectory(directoryObject, cvsFileSystem);
            return true;
        }
        return false;
    }

    private boolean hasFileEntry(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem, IAdminReader adminReader) throws IOException {
        for (Entry entry : adminReader.getEntries(directoryObject, cvsFileSystem)) {
            if (entry.isDirectory()) continue;
            return true;
        }
        return false;
    }
}

