/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaDecompilerBundle;

class LegalNoticeDialog
extends DialogWrapper {
    public static final int POSTPONE_EXIT_CODE = 1;
    public static final int DECLINE_EXIT_CODE = 2;
    private JEditorPane myMessage;

    public LegalNoticeDialog(Project project, VirtualFile file) {
        super(project);
        this.setTitle(IdeaDecompilerBundle.message("legal.notice.title", StringUtil.last((CharSequence)file.getPath(), (int)40, (boolean)true)));
        this.setOKButtonText(IdeaDecompilerBundle.message("legal.notice.action.accept", new Object[0]));
        this.setCancelButtonText(IdeaDecompilerBundle.message("legal.notice.action.postpone", new Object[0]));
        this.init();
        this.pack();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBPanel iconPanel = new JBPanel((LayoutManager)new BorderLayout());
        iconPanel.add((Component)new JBLabel(AllIcons.General.WarningDialog), "North");
        this.myMessage = new JEditorPane();
        this.myMessage.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myMessage.setEditable(false);
        this.myMessage.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        this.myMessage.setBorder(BorderFactory.createLineBorder((Color)Gray._200));
        String text = "<div style='margin:5px;'>" + IdeaDecompilerBundle.message("legal.notice.text", new Object[0]) + "</div>";
        this.myMessage.setText(text);
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout(10, 0));
        panel.add((Component)iconPanel, "West");
        panel.add((Component)this.myMessage, "Center");
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction(IdeaDecompilerBundle.message("legal.notice.action.reject", new Object[0])){

            protected void doAction(ActionEvent e) {
                LegalNoticeDialog.this.close(2);
            }
        }, this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/decompiler/LegalNoticeDialog", "createActions"));
        }
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myMessage;
    }
}

