/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRevisionNumber
implements VcsRevisionNumber {
    private static final int SHORT_HASH_SIZE = 12;
    @NotNull
    private final String revision;
    @NotNull
    private final String changeset;
    @NotNull
    private final String commitMessage;
    @NotNull
    private final String author;
    @NotNull
    private final String email;
    @NotNull
    private final List<HgRevisionNumber> parents;
    @NotNull
    private final String mySubject;
    private final boolean isWorkingVersion;
    public static final HgRevisionNumber NULL_REVISION_NUMBER = new HgRevisionNumber("", "", "", "", Collections.emptyList()){

        @Override
        public int compareTo(VcsRevisionNumber o) {
            return NULL.compareTo((Object)o);
        }

        @Override
        public String asString() {
            return NULL.asString();
        }
    };

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset, @NotNull String author, @NotNull String commitMessage) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        if (changeset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        if (author == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        return new HgRevisionNumber(revision, changeset, author, commitMessage, Collections.emptyList());
    }

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        if (changeset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        return new HgRevisionNumber(revision, changeset, "", "", Collections.emptyList());
    }

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset, @NotNull List<HgRevisionNumber> parents) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        if (changeset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/zmlx/hg4idea/HgRevisionNumber", "getInstance"));
        }
        return new HgRevisionNumber(revision, changeset, "", "", parents);
    }

    public static HgRevisionNumber getLocalInstance(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/HgRevisionNumber", "getLocalInstance"));
        }
        return new HgRevisionNumber(revision, "", "", "", Collections.emptyList());
    }

    public HgRevisionNumber(@NotNull String revision, @NotNull String changeset, @NotNull String authorInfo, @NotNull String commitMessage, @NotNull List<HgRevisionNumber> parents) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/HgRevisionNumber", "<init>"));
        }
        if (changeset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/HgRevisionNumber", "<init>"));
        }
        if (authorInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorInfo", "org/zmlx/hg4idea/HgRevisionNumber", "<init>"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "org/zmlx/hg4idea/HgRevisionNumber", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/zmlx/hg4idea/HgRevisionNumber", "<init>"));
        }
        this.commitMessage = commitMessage;
        Couple<String> authorArgs = HgUtil.parseUserNameAndEmail(authorInfo);
        this.author = (String)authorArgs.getFirst();
        this.email = (String)authorArgs.getSecond();
        this.parents = parents;
        this.revision = revision.trim();
        this.changeset = changeset.trim();
        this.isWorkingVersion = changeset.endsWith("+");
        this.mySubject = HgBaseLogParser.extractSubject(commitMessage);
    }

    @NotNull
    public String getChangeset() {
        String string = this.changeset;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgRevisionNumber", "getChangeset"));
        }
        return string;
    }

    @NotNull
    public String getRevision() {
        String string = this.revision;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgRevisionNumber", "getRevision"));
        }
        return string;
    }

    public long getRevisionAsLong() {
        return Long.parseLong(this.revision);
    }

    @NotNull
    public String getCommitMessage() {
        String string = this.commitMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgRevisionNumber", "getCommitMessage"));
        }
        return string;
    }

    @NotNull
    public String getAuthor() {
        String string = this.author;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgRevisionNumber", "getAuthor"));
        }
        return string;
    }

    public boolean isWorkingVersion() {
        return this.isWorkingVersion;
    }

    public String asString() {
        if (this.revision.isEmpty()) {
            return this.changeset;
        }
        return this.revision + ":" + this.changeset;
    }

    @NotNull
    public List<HgRevisionNumber> getParents() {
        List<HgRevisionNumber> list = this.parents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgRevisionNumber", "getParents"));
        }
        return list;
    }

    public int compareTo(VcsRevisionNumber o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof HgRevisionNumber)) {
            return -1;
        }
        HgRevisionNumber other = (HgRevisionNumber)o;
        if (this.changeset.equals(other.changeset)) {
            return 0;
        }
        if (this.changeset.isEmpty()) {
            return 1;
        }
        if (other.changeset.isEmpty()) {
            return -1;
        }
        int revCompare = Long.valueOf(this.getRevisionNumber()).compareTo(Long.valueOf(other.getRevisionNumber()));
        if (revCompare != 0) {
            return revCompare;
        }
        if (HgRevisionNumber.getShortHash(this.changeset).equals(HgRevisionNumber.getShortHash(other.changeset))) {
            return 0;
        }
        if (this.isWorkingVersion) {
            return other.isWorkingVersion ? 0 : 1;
        }
        return other.isWorkingVersion ? -1 : 0;
    }

    private static String getShortHash(@NotNull String changeset) {
        if (changeset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeset", "org/zmlx/hg4idea/HgRevisionNumber", "getShortHash"));
        }
        return changeset.substring(0, 12);
    }

    public String getRevisionNumber() {
        if (this.isWorkingVersion) {
            return this.revision.substring(0, this.revision.length() - 1);
        }
        return this.revision;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.revision, this.revision.isEmpty() ? this.changeset : HgRevisionNumber.getShortHash(this.changeset)});
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HgRevisionNumber)) {
            return false;
        }
        HgRevisionNumber that = (HgRevisionNumber)object;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        return this.asString();
    }

    @NotNull
    public String getSubject() {
        String string = this.mySubject;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgRevisionNumber", "getSubject"));
        }
        return string;
    }

    @NotNull
    public String getEmail() {
        String string = this.email;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgRevisionNumber", "getEmail"));
        }
        return string;
    }
}

