/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPassFactory
extends AbstractProjectComponent
implements MainHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LocalInspectionsPassFactory");

    public LocalInspectionsPassFactory(Project project2, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project2);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, ArrayUtil.EMPTY_INT_ARRAY, true, 7);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LocalInspectionsPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory", "getComponentName"));
        }
        return "LocalInspectionsPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory", "createHighlightingPass"));
        }
        TextRange textRange = LocalInspectionsPassFactory.calculateRangeToProcess(editor);
        if (textRange == null || !InspectionProjectProfileManager.getInstance(file2.getProject()).isProfileLoaded()) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new MyLocalInspectionsPass(file2, editor.getDocument(), textRange, (TextRange)visibleRange, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory", "createMainHighlightingPass"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory", "createMainHighlightingPass"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory", "createMainHighlightingPass"));
        }
        TextRange textRange = file2.getTextRange();
        LOG.assertTrue(textRange != null, (Object)("textRange is null for " + file2 + " (" + PsiUtilCore.getVirtualFile((PsiElement)file2) + ")"));
        return new MyLocalInspectionsPass(file2, document, textRange, LocalInspectionsPass.EMPTY_PRIORITY_RANGE, highlightInfoProcessor);
    }

    private static TextRange calculateRangeToProcess(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 7);
    }

    private static class MyLocalInspectionsPass
    extends LocalInspectionsPass {
        private MyLocalInspectionsPass(PsiFile file2, Document document, @NotNull TextRange textRange, TextRange visibleRange, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            if (textRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory$MyLocalInspectionsPass", "<init>"));
            }
            if (highlightInfoProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory$MyLocalInspectionsPass", "<init>"));
            }
            super(file2, document, textRange.getStartOffset(), textRange.getEndOffset(), visibleRange, true, highlightInfoProcessor);
        }

        @Override
        @NotNull
        List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
            if (profile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory$MyLocalInspectionsPass", "getInspectionTools"));
            }
            List<LocalInspectionToolWrapper> tools = super.getInspectionTools(profile);
            ArrayList<LocalInspectionToolWrapper> result = new ArrayList<LocalInspectionToolWrapper>(tools.size());
            for (LocalInspectionToolWrapper tool : tools) {
                if (tool.runForWholeFile()) continue;
                result.add(tool);
            }
            ArrayList<LocalInspectionToolWrapper> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory$MyLocalInspectionsPass", "getInspectionTools"));
            }
            return arrayList;
        }
    }
}

