/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProcessProxyImpl;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;

public class ProcessProxyFactoryImpl
extends ProcessProxyFactory {
    public ProcessProxy createCommandLineProxy(JavaCommandLine javaCmdLine) throws ExecutionException {
        ProcessProxyImpl proxy = null;
        JavaParameters javaParameters = javaCmdLine.getJavaParameters();
        String mainClass = javaParameters.getMainClass();
        if (ProcessProxyImpl.useLauncher() && mainClass != null) {
            try {
                proxy = new ProcessProxyImpl();
                JavaSdkUtil.addRtJar(javaParameters.getClassPath());
                ParametersList vmParametersList = javaParameters.getVMParametersList();
                vmParametersList.defineProperty("idea.launcher.port", String.valueOf(proxy.getPortNumber()));
                vmParametersList.defineProperty("idea.launcher.bin.path", PathManager.getBinPath());
                javaParameters.getProgramParametersList().prepend(mainClass);
                javaParameters.setMainClass("com.intellij.rt.execution.application.AppMain");
            }
            catch (ProcessProxyImpl.NoMoreSocketsException e) {
                proxy = null;
            }
        }
        return proxy;
    }

    public ProcessProxy getAttachedProxy(ProcessHandler processHandler2) {
        return processHandler2 != null ? (ProcessProxy)processHandler2.getUserData(ProcessProxyImpl.KEY) : null;
    }

    public boolean isBreakGenLibraryAvailable() {
        String libName = SystemInfo.isWindows ? "breakgen.dll" : (SystemInfo.isMac ? "libbreakgen.jnilib" : "libbreakgen.so");
        return new File(PathManager.getBinPath() + File.separator + libName).exists();
    }
}

