/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;

public class DumpExtensionsAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        ArrayList<ExtensionsArea> areas = new ArrayList<ExtensionsArea>();
        areas.add(Extensions.getRootArea());
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            areas.add(Extensions.getArea((AreaInstance)project2));
            Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
            if (modules.length > 0) {
                areas.add(Extensions.getArea((AreaInstance)modules[0]));
            }
        }
        System.out.print(areas.size() + " extension areas: ");
        for (ExtensionsArea extensionsArea : areas) {
            System.out.print(extensionsArea.getAreaClass() + " ");
        }
        System.out.println("\n");
        ArrayList<ExtensionPoint> points = new ArrayList<ExtensionPoint>();
        for (ExtensionsArea area : areas) {
            points.addAll(Arrays.asList(area.getExtensionPoints()));
        }
        System.out.println(points.size() + " extension points: ");
        for (ExtensionPoint point : points) {
            System.out.println(" " + point.getName());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ExtensionPoint extensionPoint : points) {
            arrayList.addAll(Arrays.asList(extensionPoint.getExtensions()));
        }
        System.out.println("\n" + arrayList.size() + " extensions:");
        for (Object e2 : arrayList) {
            if (e2 instanceof Configurable) {
                System.out.println("!!!! Configurable extension found. Kill it !!!");
            }
            System.out.println(e2);
        }
    }
}

