/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizer;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizerImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalProjectDataSelectorDialog
extends DialogWrapper {
    private static final int MAX_PATH_LENGTH = 50;
    private static final Set<? extends Key<?>> DATA_KEYS = ContainerUtil.set((Object[])new Key[]{ProjectKeys.PROJECT, ProjectKeys.MODULE});
    private static final com.intellij.openapi.util.Key<DataNode> MODIFIED_NODE_KEY = com.intellij.openapi.util.Key.create((String)"modifiedData");
    private static final com.intellij.openapi.util.Key<DataNodeCheckedTreeNode> CONNECTED_UI_NODE_KEY = com.intellij.openapi.util.Key.create((String)"connectedUiNode");
    @NotNull
    private Project myProject;
    private volatile boolean myDisposed;
    private JBLoadingPanel loadingPanel;
    private JPanel mainPanel;
    private JPanel contentPanel;
    private JBLabel myDescriptionLbl;
    private JBLabel mySelectionStatusLbl;
    private ExternalSystemUiAware myExternalSystemUiAware;
    private ExternalProjectInfo myProjectInfo;
    private final Set<Key<?>> myIgnorableKeys;
    private final Set<Key<?>> myPublicKeys;
    private final Set<Key<? extends Identifiable>> myDependencyAwareDataKeys;
    @Nullable
    private final Object myPreselectedNodeObject;
    private CheckboxTree myTree;
    private final MultiMap<DataNode<Identifiable>, DataNode<Identifiable>> dependentNodeMap;
    private final SimpleModificationTracker myModificationTracker;
    private final CachedValue<SelectionState> selectionState;
    private boolean myShowSelectedRowsOnly;
    private int myModulesCount;

    public ExternalProjectDataSelectorDialog(@NotNull Project project2, @NotNull ExternalProjectInfo projectInfo) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "<init>"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "<init>"));
        }
        this(project2, projectInfo, null);
    }

    public ExternalProjectDataSelectorDialog(@NotNull Project project2, @NotNull ExternalProjectInfo projectInfo, @Nullable Object preselectedNodeDataObject) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "<init>"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "<init>"));
        }
        super(project2, true);
        this.myDisposed = false;
        this.$$$setupUI$$$();
        this.dependentNodeMap = MultiMap.create((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
        this.myModificationTracker = new SimpleModificationTracker();
        this.selectionState = new CachedValueImpl<SelectionState>(new CachedValueProvider<SelectionState>(){

            @Nullable
            public CachedValueProvider.Result<SelectionState> compute() {
                return CachedValueProvider.Result.createSingleDependency((Object)ExternalProjectDataSelectorDialog.this.getSelectionStatus(), (Object)ExternalProjectDataSelectorDialog.this.myModificationTracker);
            }
        });
        this.myProject = project2;
        this.myIgnorableKeys = ExternalProjectDataSelectorDialog.getIgnorableKeys();
        this.myPublicKeys = ExternalProjectDataSelectorDialog.getPublicKeys();
        this.myDependencyAwareDataKeys = ExternalProjectDataSelectorDialog.getDependencyAwareDataKeys();
        this.myPreselectedNodeObject = preselectedNodeDataObject;
        this.init(projectInfo);
    }

    private void init(@NotNull ExternalProjectInfo projectInfo) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "init"));
        }
        ProjectDataManager.getInstance().ensureTheDataIsReadyToUse(projectInfo.getExternalProjectStructure());
        this.myProjectInfo = projectInfo;
        this.myExternalSystemUiAware = ExternalSystemUiUtil.getUiAware(this.myProjectInfo.getProjectSystemId());
        this.myTree = this.createTree();
        this.updateSelectionState();
        this.myTree.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$2", "nodeStateChanged"));
                }
                ExternalProjectDataSelectorDialog.this.updateSelectionState();
            }
        });
        String externalSystemName = this.myProjectInfo.getProjectSystemId().getReadableName();
        this.setTitle(String.format("%s Project Data To Import", externalSystemName));
        this.init();
    }

    public boolean hasMultipleDataToSelect() {
        Object root = this.myTree.getModel().getRoot();
        if (root instanceof CheckedTreeNode && ((CheckedTreeNode)root).getChildCount() == 1) {
            return false;
        }
        return this.myModulesCount > 1;
    }

    private void updateSelectionState() {
        this.myModificationTracker.incModificationCount();
        this.mySelectionStatusLbl.setText(((SelectionState)this.selectionState.getValue()).message);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).addExtraAction((AnActionButton)new SelectAllButton()).addExtraAction((AnActionButton)new UnselectAllButton()).addExtraAction((AnActionButton)new ShowSelectedOnlyButton()).addExtraAction((AnActionButton)new SelectRequiredButton()).setToolbarPosition(ActionToolbarPosition.BOTTOM).setToolbarBorder(IdeBorderFactory.createEmptyBorder());
        this.contentPanel.add(decorator.createPanel());
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.loadingPanel.add((Component)this.mainPanel, (Object)"Center");
        return this.loadingPanel;
    }

    private void reloadTree() {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        Object root = treeModel.getRoot();
        if (!(root instanceof CheckedTreeNode)) {
            return;
        }
        CheckedTreeNode rootNode = (CheckedTreeNode)root;
        Couple<CheckedTreeNode> rootAndPreselectedNode = this.createRoot();
        CheckedTreeNode rootCopy = (CheckedTreeNode)rootAndPreselectedNode.first;
        ArrayList nodes = TreeUtil.childrenToArray((TreeNode)rootCopy);
        rootNode.removeAllChildren();
        TreeUtil.addChildrenTo((MutableTreeNode)rootNode, (List)nodes);
        treeModel.reload();
    }

    protected void doOKAction() {
        this.loadingPanel.setLoadingText("Please wait...");
        this.loadingPanel.startLoading();
        final DataNode projectStructure = this.myProjectInfo.getExternalProjectStructure();
        if (projectStructure != null) {
            final boolean[] isModified = new boolean[]{false};
            ExternalSystemApiUtil.visit((DataNode)projectStructure, (Consumer)new Consumer<DataNode<?>>(){

                public void consume(DataNode<?> node) {
                    DataNode modifiedDataNode = (DataNode)node.getUserData(MODIFIED_NODE_KEY);
                    if (modifiedDataNode != null) {
                        if (node.isIgnored() != modifiedDataNode.isIgnored()) {
                            node.setIgnored(modifiedDataNode.isIgnored());
                            isModified[0] = true;
                        }
                        node.removeUserData(MODIFIED_NODE_KEY);
                        node.removeUserData(CONNECTED_UI_NODE_KEY);
                    }
                }
            });
            if (isModified[0]) {
                DataNode notIgnoredNode = (DataNode)ContainerUtil.find((Iterable)projectStructure.getChildren(), (Condition)new Condition<DataNode<?>>(){

                    public boolean value(DataNode<?> node) {
                        return !node.isIgnored();
                    }
                });
                projectStructure.setIgnored(notIgnoredNode == null);
                ExternalSystemUtil.invokeLater(this.myProject, ModalityState.NON_MODAL, new Runnable(){

                    @Override
                    public void run() {
                        ProjectData projectData = (ProjectData)projectStructure.getData();
                        String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectData.getExternalName(), projectData.getOwner().getReadableName()});
                        new Task.Backgroundable(ExternalProjectDataSelectorDialog.this.myProject, title, true, PerformInBackgroundOption.DEAF){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog$5$1", "run"));
                                }
                                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(projectStructure, this.myProject, false);
                            }
                        }.queue();
                    }
                });
            }
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        ExternalSystemApiUtil.visit((DataNode)this.myProjectInfo.getExternalProjectStructure(), (Consumer)new Consumer<DataNode<?>>(){

            public void consume(DataNode<?> node) {
                node.removeUserData(MODIFIED_NODE_KEY);
                node.removeUserData(CONNECTED_UI_NODE_KEY);
            }
        });
        super.doCancelAction();
    }

    public void dispose() {
        super.dispose();
        this.myDisposed = true;
    }

    private CheckboxTree createTree() {
        Couple<CheckedTreeNode> rootAndPreselectedNode = this.createRoot();
        CheckedTreeNode root = (CheckedTreeNode)rootAndPreselectedNode.first;
        CheckboxTree tree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof DataNodeCheckedTreeNode)) {
                    return;
                }
                DataNodeCheckedTreeNode node = (DataNodeCheckedTreeNode)((Object)value);
                String tooltip = null;
                boolean hasErrors = false;
                if (node.isChecked()) {
                    String listOfUncheckedDependencies;
                    Enumeration children2 = node.children();
                    while (children2.hasMoreElements()) {
                        Object o = children2.nextElement();
                        if (!(o instanceof DataNodeCheckedTreeNode) || ((DataNodeCheckedTreeNode)((Object)o)).isChecked()) continue;
                        this.myCheckbox.setEnabled(false);
                        break;
                    }
                    if (ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node.myDataNode.getKey()) && StringUtil.isNotEmpty((String)(listOfUncheckedDependencies = StringUtil.join((Collection)ExternalProjectDataSelectorDialog.this.dependentNodeMap.get((Object)node.myDataNode), (Function)new Function<DataNode<Identifiable>, String>(){

                        public String fun(DataNode<Identifiable> depNode) {
                            DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)depNode.getUserData(CONNECTED_UI_NODE_KEY));
                            return uiNode != null && !uiNode.isChecked() ? ((Identifiable)depNode.getData()).getId() : null;
                        }
                    }, (String)"<br>")))) {
                        hasErrors = true;
                        tooltip = "There are not selected module dependencies of the module: <br><b>" + listOfUncheckedDependencies + "</b>";
                    }
                }
                ColoredTreeCellRenderer renderer = this.getTextRenderer();
                renderer.setIcon(node.icon);
                renderer.append(node.text, hasErrors ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (!StringUtil.isEmptyOrSpaces((String)node.comment)) {
                    String description = node.comment;
                    if (node.comment.length() > 50) {
                        description = node.comment.substring(0, 50) + "...";
                    }
                    renderer.append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.setToolTipText(StringUtil.isEmpty(tooltip) ? node.comment : tooltip);
                } else {
                    this.setToolTipText(StringUtil.isNotEmpty(tooltip) ? tooltip : null);
                }
            }
        }, root, new CheckboxTreeBase.CheckPolicy(true, true, false, false));
        TreeUtil.expand((JTree)((Object)tree), (int)1);
        if (rootAndPreselectedNode.second != null) {
            TreeUtil.selectNode((JTree)((Object)tree), (TreeNode)((TreeNode)rootAndPreselectedNode.second));
        } else {
            tree.setSelectionRow(0);
        }
        return tree;
    }

    private Couple<CheckedTreeNode> createRoot() {
        THashMap treeNodeMap = ContainerUtil.newIdentityTroveMap();
        DataNodeCheckedTreeNode[] preselectedNode = new DataNodeCheckedTreeNode[]{null};
        DataNodeCheckedTreeNode[] rootModuleNode = new DataNodeCheckedTreeNode[]{null};
        MultiMap moduleDependenciesMap = MultiMap.create();
        final HashMap modulesNodeMap = ContainerUtil.newHashMap();
        for (Object moduleDependencyDataNode : ExternalSystemApiUtil.findAllRecursively((DataNode)this.myProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.MODULE_DEPENDENCY)) {
            ModuleDependencyData moduleDependencyData = (ModuleDependencyData)moduleDependencyDataNode.getData();
            moduleDependenciesMap.putValue((Object)moduleDependencyData.getOwnerModule().getId(), (Object)((ModuleData)moduleDependencyData.getTarget()).getId());
        }
        final int[] modulesCount = new int[]{0};
        ExternalSystemApiUtil.visit((DataNode)this.myProjectInfo.getExternalProjectStructure(), (Consumer)new Consumer<DataNode<?>>((Map)treeNodeMap, modulesNodeMap, preselectedNode, rootModuleNode){
            final /* synthetic */ Map val$treeNodeMap;
            final /* synthetic */ Map val$modulesNodeMap;
            final /* synthetic */ DataNodeCheckedTreeNode[] val$preselectedNode;
            final /* synthetic */ DataNodeCheckedTreeNode[] val$rootModuleNode;
            {
                this.val$treeNodeMap = map;
                this.val$modulesNodeMap = map2;
                this.val$preselectedNode = dataNodeCheckedTreeNodeArray;
                this.val$rootModuleNode = dataNodeCheckedTreeNodeArray2;
            }

            public void consume(DataNode<?> node) {
                Key key = node.getKey();
                if (!ExternalProjectDataSelectorDialog.this.myPublicKeys.contains(key)) {
                    return;
                }
                DataNode modifiableDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(node);
                if (ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(key)) {
                    modulesCount[0] = modulesCount[0] + 1;
                }
                if (modifiableDataNode.isIgnored() && ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                    return;
                }
                DataNodeCheckedTreeNode treeNode = (DataNodeCheckedTreeNode)((Object)this.val$treeNodeMap.get(node));
                if (treeNode == null) {
                    CheckedTreeNode parentTreeNode;
                    treeNode = new DataNodeCheckedTreeNode(node);
                    if (ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(key)) {
                        Identifiable moduleData = (Identifiable)node.getData();
                        this.val$modulesNodeMap.put(moduleData.getId(), node);
                    }
                    if (ExternalProjectDataSelectorDialog.this.myPreselectedNodeObject != null && ExternalProjectDataSelectorDialog.this.myPreselectedNodeObject.equals(node.getData())) {
                        this.val$preselectedNode[0] = treeNode;
                    }
                    if (node.getData() instanceof ModuleData && key.equals((Object)ProjectKeys.MODULE) && ExternalProjectDataSelectorDialog.this.myProjectInfo.getExternalProjectPath().equals(((ModuleData)node.getData()).getLinkedExternalProjectPath())) {
                        this.val$rootModuleNode[0] = treeNode;
                    }
                    treeNode.setEnabled(ExternalProjectDataSelectorDialog.this.myIgnorableKeys.contains(key));
                    this.val$treeNodeMap.put(node, treeNode);
                    DataNode parent = node.getParent();
                    if (parent != null && (parentTreeNode = (CheckedTreeNode)this.val$treeNodeMap.get(parent)) != null) {
                        parentTreeNode.add((MutableTreeNode)((Object)treeNode));
                    }
                }
            }
        });
        this.myModulesCount = modulesCount[0];
        this.dependentNodeMap.clear();
        for (String moduleId : moduleDependenciesMap.keySet()) {
            Collection moduleDependencies = moduleDependenciesMap.get((Object)moduleId);
            DataNode moduleNode = (DataNode)modulesNodeMap.get(moduleId);
            if (moduleNode == null) continue;
            this.dependentNodeMap.putValues((Object)moduleNode, (Collection)ContainerUtil.mapNotNull((Collection)moduleDependencies, (Function)new Function<String, DataNode<Identifiable>>(){

                public DataNode<Identifiable> fun(String s) {
                    return (DataNode)modulesNodeMap.get(s);
                }
            }));
        }
        CheckedTreeNode root = new CheckedTreeNode(null);
        DataNodeCheckedTreeNode projectNode = (DataNodeCheckedTreeNode)((Object)treeNodeMap.get(this.myProjectInfo.getExternalProjectStructure()));
        if (rootModuleNode[0] != null && projectNode != null) {
            rootModuleNode[0].comment = "root module";
            if (projectNode.isNodeChild((TreeNode)((Object)rootModuleNode[0]))) {
                projectNode.remove((MutableTreeNode)((Object)rootModuleNode[0]));
            }
            projectNode.insert((MutableTreeNode)((Object)rootModuleNode[0]), 0);
        }
        List nodes = projectNode != null ? TreeUtil.childrenToArray((TreeNode)((Object)projectNode)) : ContainerUtil.emptyList();
        TreeUtil.addChildrenTo((MutableTreeNode)root, (List)nodes);
        return Couple.of((Object)root, (Object)((Object)preselectedNode[0]));
    }

    @NotNull
    private static Set<Key<?>> getPublicKeys() {
        HashSet result = ContainerUtil.newHashSet(DATA_KEYS);
        for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result.addAll(customizer.getPublicDataKeys());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "getPublicKeys"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<Key<?>> getIgnorableKeys() {
        HashSet result = ContainerUtil.newHashSet(DATA_KEYS);
        for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result.addAll(customizer.getIgnorableDataKeys());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "getIgnorableKeys"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<Key<? extends Identifiable>> getDependencyAwareDataKeys() {
        HashSet result = ContainerUtil.newHashSet();
        result.add(ProjectKeys.MODULE);
        for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
            result.addAll(customizer.getDependencyAwareDataKeys());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "getDependencyAwareDataKeys"));
        }
        return hashSet;
    }

    @NotNull
    private static DataNode getModifiableDataNode(@NotNull DataNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "getModifiableDataNode"));
        }
        DataNode modifiedDataNode = (DataNode)node.getUserData(MODIFIED_NODE_KEY);
        if (modifiedDataNode == null) {
            modifiedDataNode = node.nodeCopy();
            node.putUserData(MODIFIED_NODE_KEY, (Object)modifiedDataNode);
        }
        DataNode dataNode = modifiedDataNode;
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/ExternalProjectDataSelectorDialog", "getModifiableDataNode"));
        }
        return dataNode;
    }

    private SelectionState getSelectionStatus() {
        boolean isRequiredSelectionEnabled = this.computeRequiredSelectionStatus();
        String stateMessage = "";
        Object root = this.myTree.getModel().getRoot();
        if (root instanceof CheckedTreeNode) {
            final int[] selectedModulesCount = new int[]{0};
            TreeUtil.traverse((TreeNode)((CheckedTreeNode)root), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (node instanceof DataNodeCheckedTreeNode && ((DataNodeCheckedTreeNode)((Object)node)).isChecked() && ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(((DataNodeCheckedTreeNode)((Object)node)).myDataNode.getKey())) {
                        selectedModulesCount[0] = selectedModulesCount[0] + 1;
                    }
                    return true;
                }
            });
            stateMessage = String.format("%1$d Modules. %2$d selected", this.myModulesCount, selectedModulesCount[0]);
        }
        return new SelectionState(isRequiredSelectionEnabled, stateMessage);
    }

    private boolean computeRequiredSelectionStatus() {
        for (DataNode node : this.dependentNodeMap.keySet()) {
            DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)node.getUserData(CONNECTED_UI_NODE_KEY));
            assert (uiNode != null);
            if (!uiNode.isChecked()) continue;
            for (DataNode depNode : this.dependentNodeMap.get((Object)node)) {
                DataNodeCheckedTreeNode uiDependentNode = (DataNodeCheckedTreeNode)((Object)depNode.getUserData(CONNECTED_UI_NODE_KEY));
                assert (uiDependentNode != null);
                if (uiDependentNode.isChecked()) continue;
                return true;
            }
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        jPanel2.setMinimumSize(new Dimension(300, 100));
        jPanel2.setOpaque(false);
        jPanel2.setPreferredSize(new Dimension(400, 300));
        ((Component)jPanel2).setEnabled(true);
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setMinimumSize(new Dimension(0, 0));
        jPanel.setPreferredSize(new Dimension(0, 0));
        jPanel.setAutoscrolls(true);
        jPanel2.add((Component)jPanel, "Center");
        this.mySelectionStatusLbl = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, "South");
        this.myDescriptionLbl = jBLabel = new JBLabel();
        jBLabel.setText("Please select the modules/data to include in the project.");
        jPanel2.add((Component)jBLabel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class SelectRequiredButton
    extends AnActionButton {
        public SelectRequiredButton() {
            super("Select Required", "select modules depended on currently selected modules", AllIcons.Actions.IntentionBulb);
            this.addCustomUpdater(new AnActionButtonUpdater(){

                public boolean isEnabled(AnActionEvent e) {
                    return ((SelectionState)((ExternalProjectDataSelectorDialog)ExternalProjectDataSelectorDialog.this).selectionState.getValue()).isRequiredSelectionEnabled;
                }
            });
        }

        public void actionPerformed(AnActionEvent e) {
            boolean showSelectedRowsOnly = ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly;
            if (showSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
            ExternalProjectDataSelectorDialog.this.myTree.clearSelection();
            for (DataNode node : ExternalProjectDataSelectorDialog.this.dependentNodeMap.keySet()) {
                DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)node.getUserData(CONNECTED_UI_NODE_KEY));
                assert (uiNode != null);
                if (!uiNode.isChecked()) continue;
                for (DataNode treeNode : ExternalProjectDataSelectorDialog.this.dependentNodeMap.get((Object)node)) {
                    DataNodeCheckedTreeNode uiDependentNode = (DataNodeCheckedTreeNode)((Object)treeNode.getUserData(CONNECTED_UI_NODE_KEY));
                    assert (uiDependentNode != null);
                    ExternalProjectDataSelectorDialog.this.myTree.setNodeState(uiDependentNode, true);
                }
            }
            if (showSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
            ExternalProjectDataSelectorDialog.this.updateSelectionState();
        }

        public boolean displayTextInToolbar() {
            return true;
        }
    }

    private class ShowSelectedOnlyButton
    extends ToggleActionButton {
        public ShowSelectedOnlyButton() {
            super("Show Selected Only", AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(AnActionEvent e) {
            return ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = state;
            ExternalProjectDataSelectorDialog.this.reloadTree();
        }
    }

    private class UnselectAllButton
    extends AnActionButton {
        public UnselectAllButton() {
            super("Unselect All", AllIcons.Actions.Unselectall);
        }

        public void actionPerformed(AnActionEvent e) {
            DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
            Object root = treeModel.getRoot();
            if (!(root instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, false);
            } else {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, false);
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
                ExternalProjectDataSelectorDialog.this.reloadTree();
            }
        }
    }

    private class SelectAllButton
    extends AnActionButton {
        public SelectAllButton() {
            super("Select All", AllIcons.Actions.Selectall);
        }

        public void actionPerformed(AnActionEvent e) {
            DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
            Object root = treeModel.getRoot();
            if (!(root instanceof CheckedTreeNode)) {
                return;
            }
            if (!ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, true);
            } else {
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = false;
                ExternalProjectDataSelectorDialog.this.reloadTree();
                ExternalProjectDataSelectorDialog.this.myTree.setNodeState((CheckedTreeNode)root, true);
                ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly = true;
            }
        }
    }

    private static class SelectionState {
        boolean isRequiredSelectionEnabled;
        @Nullable
        String message;

        public SelectionState(boolean isRequiredSelectionEnabled, @Nullable String message) {
            this.isRequiredSelectionEnabled = isRequiredSelectionEnabled;
            this.message = message;
        }
    }

    private class DataNodeCheckedTreeNode
    extends CheckedTreeNode {
        private final DataNode myDataNode;
        @Nullable
        private Icon icon;
        private String text;
        @Nullable
        private String comment;

        private DataNodeCheckedTreeNode(DataNode node) {
            super((Object)node);
            this.myDataNode = node;
            node.putUserData(CONNECTED_UI_NODE_KEY, (Object)this);
            DataNode modifiableDataNode = (DataNode)node.getUserData(MODIFIED_NODE_KEY);
            assert (modifiableDataNode != null);
            this.isChecked = !modifiableDataNode.isIgnored();
            Icon anIconCandidate = null;
            boolean multipleIconCandidatesFound = false;
            ExternalProjectStructureCustomizer projectStructureCustomizer = new ExternalProjectStructureCustomizerImpl();
            for (ExternalProjectStructureCustomizer customizer : (ExternalProjectStructureCustomizer[])ExternalProjectStructureCustomizer.EP_NAME.getExtensions()) {
                Icon icon = customizer.suggestIcon(node, ExternalProjectDataSelectorDialog.this.myExternalSystemUiAware);
                if (!multipleIconCandidatesFound && icon != null) {
                    if (anIconCandidate != null) {
                        multipleIconCandidatesFound = true;
                        anIconCandidate = null;
                    } else {
                        anIconCandidate = icon;
                    }
                }
                if (!customizer.getPublicDataKeys().contains(node.getKey())) continue;
                projectStructureCustomizer = customizer;
                break;
            }
            this.icon = anIconCandidate != null ? anIconCandidate : ((ExternalProjectStructureCustomizer)projectStructureCustomizer).suggestIcon(node, ExternalProjectDataSelectorDialog.this.myExternalSystemUiAware);
            Couple<String> representationName = ((ExternalProjectStructureCustomizer)projectStructureCustomizer).getRepresentationName(node);
            this.text = (String)representationName.first;
            this.comment = (String)representationName.second;
            if (this.text == null) {
                this.text = node.getKey().toString();
            }
        }

        public void setChecked(final boolean checked) {
            DataNodeCheckedTreeNode[] unprocessedNodes;
            super.setChecked(checked);
            if (checked) {
                DataNodeCheckedTreeNode parent = this;
                DataNodeCheckedTreeNode moduleNode = null;
                while (parent.parent instanceof DataNodeCheckedTreeNode) {
                    if (moduleNode == null && ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(parent.myDataNode.getKey())) {
                        moduleNode = parent;
                    }
                    parent = (DataNodeCheckedTreeNode)((Object)parent.parent);
                }
                parent.isChecked = true;
                DataNode modifiedParentDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(parent.myDataNode);
                modifiedParentDataNode.setIgnored(false);
                if (moduleNode != null) {
                    moduleNode.isChecked = true;
                }
                ExternalSystemApiUtil.visit((DataNode)(moduleNode == null ? this.myDataNode : moduleNode.myDataNode), (Consumer)new Consumer<DataNode<?>>(){

                    public void consume(DataNode node) {
                        DataNode modifiedDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(node);
                        modifiedDataNode.setIgnored(false);
                    }
                });
            } else {
                ExternalSystemApiUtil.visit((DataNode)this.myDataNode, (Consumer)new Consumer<DataNode<?>>(){

                    public void consume(DataNode node) {
                        DataNode modifiedDataNode = ExternalProjectDataSelectorDialog.getModifiableDataNode(node);
                        modifiedDataNode.setIgnored(true);
                    }
                });
                if (ExternalProjectDataSelectorDialog.this.myShowSelectedRowsOnly) {
                    DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
                    TreePath[] before = ExternalProjectDataSelectorDialog.this.myTree.getSelectionPaths();
                    treeModel.removeNodeFromParent((MutableTreeNode)((Object)this));
                    ExternalProjectDataSelectorDialog.this.myTree.addSelectionPaths(before);
                }
            }
            if (!checked && this.parent instanceof DataNodeCheckedTreeNode && this.myDataNode.getKey().equals((Object)ProjectKeys.MODULE) && ((DataNodeCheckedTreeNode)((Object)this.parent)).myDataNode.getKey().equals((Object)ProjectKeys.PROJECT)) {
                DataNode projectDataNode = ((DataNodeCheckedTreeNode)((Object)this.parent)).myDataNode;
                ProjectData projectData = (ProjectData)projectDataNode.getData();
                ModuleData moduleData = (ModuleData)this.myDataNode.getData();
                if (moduleData.getLinkedExternalProjectPath().equals(projectData.getLinkedExternalProjectPath()) && ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE).size() == 1) {
                    ((DataNodeCheckedTreeNode)((Object)this.parent)).setChecked(false);
                }
            }
            boolean isCheckCompleted = (unprocessedNodes = (DataNodeCheckedTreeNode[])ExternalProjectDataSelectorDialog.this.myTree.getSelectedNodes(DataNodeCheckedTreeNode.class, (Tree.NodeFilter)new Tree.NodeFilter<DataNodeCheckedTreeNode>(){

                public boolean accept(DataNodeCheckedTreeNode node) {
                    return ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node.myDataNode.getKey()) && checked != node.isChecked();
                }
            })).length == 0 && ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(this.myDataNode.getKey());
            ExternalProjectDataSelectorDialog.this.updateSelectionState();
            if (((SelectionState)((ExternalProjectDataSelectorDialog)ExternalProjectDataSelectorDialog.this).selectionState.getValue()).isRequiredSelectionEnabled && isCheckCompleted) {
                this.warnAboutMissedDependencies(checked);
            }
        }

        private void warnAboutMissedDependencies(boolean checked) {
            List selectedModules = ContainerUtil.newSmartList();
            for (Object node : TreeUtil.collectSelectedObjectsOfType((JTree)((Object)ExternalProjectDataSelectorDialog.this.myTree), DataNode.class)) {
                if (!ExternalProjectDataSelectorDialog.this.myDependencyAwareDataKeys.contains(node.getKey())) continue;
                selectedModules.add(node);
            }
            HashSet deps = ContainerUtil.newHashSet();
            for (DataNode selectedModule : selectedModules) {
                if (checked) {
                    deps.addAll(ContainerUtil.filter((Collection)ExternalProjectDataSelectorDialog.this.dependentNodeMap.get((Object)selectedModule), (Condition)new Condition<DataNode<Identifiable>>(){

                        public boolean value(DataNode<Identifiable> node) {
                            DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)node.getUserData(CONNECTED_UI_NODE_KEY));
                            return uiNode != null && !uiNode.isChecked();
                        }
                    }));
                    continue;
                }
                for (DataNode node : ExternalProjectDataSelectorDialog.this.dependentNodeMap.keySet()) {
                    Collection dependencies;
                    DataNodeCheckedTreeNode uiNode = (DataNodeCheckedTreeNode)((Object)node.getUserData(CONNECTED_UI_NODE_KEY));
                    if (uiNode != null && !uiNode.isChecked() || !(dependencies = ExternalProjectDataSelectorDialog.this.dependentNodeMap.get((Object)node)).contains(selectedModule)) continue;
                    deps.add(node);
                }
            }
            if (!deps.isEmpty() && !selectedModules.isEmpty()) {
                String listOfSelectedModules = StringUtil.join((Collection)selectedModules, (Function)new Function<DataNode<Identifiable>, String>(){

                    public String fun(DataNode<Identifiable> node) {
                        return ((Identifiable)node.getData()).getId();
                    }
                }, (String)", ");
                String listOfDependencies = StringUtil.join((Collection)deps, (Function)new Function<DataNode<Identifiable>, String>(){

                    public String fun(DataNode<Identifiable> node) {
                        return ((Identifiable)node.getData()).getId();
                    }
                }, (String)"<br>");
                String message = !checked ? String.format("<html>The following module%s <br><b>%s</b><br>%s enabled and depend%s on selected modules. <br>Would you like to disable %s too?</html>", deps.size() == 1 ? "" : "s", listOfDependencies, deps.size() == 1 ? "is" : "are", deps.size() == 1 ? "s" : "", deps.size() == 1 ? "it" : "them") : String.format("<html>The following module%s on which <b>%s</b> depend%s %s disabled:<br><b>%s</b><br>Would you like to enable %s?</html>", deps.size() == 1 ? "" : "s", listOfSelectedModules, selectedModules.size() == 1 ? "s" : "", deps.size() == 1 ? "is" : "are", listOfDependencies, deps.size() == 1 ? "it" : "them");
                if (Messages.showOkCancelDialog((String)message, (String)(checked ? "Enable Dependant Modules" : "Disable Modules with Dependency on this"), (Icon)Messages.getQuestionIcon()) == 0) {
                    List nodes = ContainerUtil.mapNotNull((Collection)deps, (Function)new Function<DataNode<Identifiable>, DataNodeCheckedTreeNode>(){

                        public DataNodeCheckedTreeNode fun(DataNode<Identifiable> node) {
                            return (DataNodeCheckedTreeNode)((Object)node.getUserData(CONNECTED_UI_NODE_KEY));
                        }
                    });
                    for (DataNodeCheckedTreeNode node : nodes) {
                        DefaultTreeModel treeModel = (DefaultTreeModel)ExternalProjectDataSelectorDialog.this.myTree.getModel();
                        ExternalProjectDataSelectorDialog.this.myTree.addSelectionPath(new TreePath(treeModel.getPathToRoot((TreeNode)((Object)node))));
                    }
                    for (DataNodeCheckedTreeNode node : nodes) {
                        node.setChecked(checked);
                    }
                }
            }
        }
    }
}

