/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;

public class ChangeListDetailsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists != null && changeLists.length > 0 && changeLists[0] instanceof CommittedChangeList) {
            ChangeListDetailsAction.showDetailsPopup(project2, (CommittedChangeList)changeLists[0]);
        }
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        e.getPresentation().setEnabled(project2 != null && changeLists != null && changeLists.length == 1 && changeLists[0] instanceof CommittedChangeList);
    }

    public static void showDetailsPopup(Project project2, CommittedChangeList changeList) {
        StringBuilder detailsBuilder = new StringBuilder("<html><head>");
        detailsBuilder.append(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont())).append("</head><body>");
        AbstractVcs vcs = changeList.getVcs();
        CachingCommittedChangesProvider provider = null;
        if (vcs != null && (provider = vcs.getCachingCommittedChangesProvider()) != null && provider.getChangelistTitle() != null) {
            detailsBuilder.append(provider.getChangelistTitle()).append(" #").append(changeList.getNumber()).append("<br>");
        }
        String committer = "<b>" + changeList.getCommitterName() + "</b>";
        detailsBuilder.append(VcsBundle.message((String)"changelist.details.committed.format", (Object[])new Object[]{committer, DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate())}));
        detailsBuilder.append("<br>");
        if (provider != null) {
            CommittedChangeList originalChangeList = ReceivedChangeList.unwrap(changeList);
            for (ChangeListColumn column : provider.getColumns()) {
                if (!ChangeListColumn.isCustom((ChangeListColumn)column)) continue;
                String value = column.getValue((ChangeList)originalChangeList).toString();
                if (value.length() == 0) {
                    value = "<none>";
                }
                detailsBuilder.append(column.getTitle()).append(": ").append(XmlStringUtil.escapeString((String)value)).append("<br>");
            }
        }
        detailsBuilder.append(IssueLinkHtmlRenderer.formatTextWithLinks(project2, changeList.getComment()));
        detailsBuilder.append("</body></html>");
        JEditorPane editorPane = new JEditorPane("text/html", detailsBuilder.toString());
        editorPane.setEditable(false);
        editorPane.setBackground(HintUtil.INFORMATION_COLOR);
        editorPane.select(0, 0);
        editorPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)editorPane);
        JBPopup hint = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)editorPane).setDimensionServiceKey(project2, "changelist.details.popup", false).setResizable(true).setMovable(true).setRequestFocus(true).setTitle(VcsBundle.message((String)"changelist.details.title", (Object[])new Object[0])).createPopup();
        hint.showInBestPositionFor(DataManager.getInstance().getDataContext());
    }
}

