/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcsUtil.VcsUtil;

public class ChangesBrowserModuleNode
extends ChangesBrowserNode<Module> {
    protected ChangesBrowserModuleNode(Module userObject) {
        super(userObject);
    }

    @Override
    public void render(ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Module module2 = (Module)this.userObject;
        renderer.append(module2.isDisposed() ? "" : module2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer);
        if (module2.isDisposed()) {
            renderer.setIcon(ModuleType.EMPTY.getIcon());
        } else {
            renderer.setIcon(ModuleType.get((Module)module2).getIcon());
        }
    }

    @Override
    public String getTextPresentation() {
        return ((Module)this.getUserObject()).getName();
    }

    @Override
    public int getSortWeight() {
        return 3;
    }

    @Override
    public int compareUserObjects(Object o2) {
        if (o2 instanceof Module) {
            return ((Module)this.getUserObject()).getName().compareToIgnoreCase(((Module)o2).getName());
        }
        return 0;
    }

    @Override
    public FilePath[] getFilePathsUnder() {
        VirtualFile[] files = ModuleRootManager.getInstance((Module)((Module)this.getUserObject())).getContentRoots();
        FilePath[] result = new FilePath[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = VcsUtil.getFilePath((VirtualFile)files[i]);
        }
        return result;
    }
}

