/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeGlassPaneImpl
extends JPanel
implements IdeGlassPaneEx,
IdeEventQueue.EventDispatcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.IdeGlassPaneImpl");
    private static final String PREPROCESSED_CURSOR_KEY = "SuperCursor";
    private final List<EventListener> myMouseListeners = new ArrayList<EventListener>();
    private final Set<EventListener> mySortedMouseListeners = new TreeSet<EventListener>(new Comparator<EventListener>(){

        @Override
        public int compare(EventListener o1, EventListener o2) {
            double weight1 = 0.0;
            double weight2 = 0.0;
            if (o1 instanceof Weighted) {
                weight1 = ((Weighted)o1).getWeight();
            }
            if (o2 instanceof Weighted) {
                weight2 = ((Weighted)o2).getWeight();
            }
            return weight1 > weight2 ? 1 : (weight1 < weight2 ? -1 : IdeGlassPaneImpl.this.myMouseListeners.indexOf(o1) - IdeGlassPaneImpl.this.myMouseListeners.indexOf(o2));
        }
    });
    private final JRootPane myRootPane;
    private final Map<String, PaintersHelper> myNamedPainters = new FactoryMap<String, PaintersHelper>(){

        @Nullable
        protected PaintersHelper create(String key) {
            return new PaintersHelper(IdeGlassPaneImpl.this);
        }
    };
    private boolean myPreprocessorActive;
    private final Map<Object, Cursor> myListener2Cursor = new LinkedHashMap<Object, Cursor>();
    private Component myLastCursorComponent;
    private Cursor myLastOriginalCursor;
    private MouseEvent myPrevPressEvent;

    public IdeGlassPaneImpl(JRootPane rootPane) {
        this.myRootPane = rootPane;
        this.setOpaque(false);
        this.setVisible(false);
        this.setLayout(null);
        if (this.myRootPane instanceof IdeRootPane) {
            IdeBackgroundUtil.initFramePainters(this.getNamedPainters("ide"));
            IdeBackgroundUtil.initEditorPainters(this.getNamedPainters("editor"));
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public boolean dispatch(AWTEvent e) {
        boolean dispatched;
        JRootPane eventRootPane = this.myRootPane;
        if (e instanceof MouseEvent) {
            Container parentWindow;
            MouseEvent me = (MouseEvent)e;
            Window eventWindow = UIUtil.getWindow((Component)me.getComponent());
            if (IdeGlassPaneImpl.isContextMenu(eventWindow)) {
                return false;
            }
            Window thisGlassWindow = SwingUtilities.getWindowAncestor(this.myRootPane);
            if (eventWindow instanceof JWindow && (eventRootPane = ((JWindow)eventWindow).getRootPane()) != null && !(eventRootPane.getGlassPane() instanceof IdeGlassPane) && (parentWindow = eventWindow.getParent()) instanceof Window) {
                eventWindow = (Window)parentWindow;
            }
            if (eventWindow != thisGlassWindow) {
                return false;
            }
        }
        if (e.getID() == 506 && ApplicationManager.getApplication() != null) {
            IdeTooltipManager.getInstance().hideCurrent((MouseEvent)e);
        }
        if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
            dispatched = this.preprocess((MouseEvent)e, false, eventRootPane);
        } else if (e.getID() == 503 || e.getID() == 506) {
            dispatched = this.preprocess((MouseEvent)e, true, eventRootPane);
        } else if (e.getID() == 505 || e.getID() == 504) {
            dispatched = this.preprocess((MouseEvent)e, false, eventRootPane);
        } else {
            return false;
        }
        MouseEvent me = (MouseEvent)e;
        Component meComponent = me.getComponent();
        if (!dispatched && meComponent != null) {
            boolean pureMouse1Event;
            Window eventWindow = UIUtil.getWindow((Component)meComponent);
            if (eventWindow != SwingUtilities.getWindowAncestor(this.myRootPane)) {
                return false;
            }
            int button1 = 1040;
            boolean bl = pureMouse1Event = (me.getModifiersEx() | button1) == button1;
            if (pureMouse1Event && me.getClickCount() <= 1 && !me.isPopupTrigger()) {
                Point targetPoint;
                boolean overSelection;
                Point point = SwingUtilities.convertPoint(meComponent, me.getPoint(), this.myRootPane.getContentPane());
                JMenuBar menuBar = this.myRootPane.getJMenuBar();
                point.y = point.y + (menuBar != null ? menuBar.getHeight() : 0);
                Component target = SwingUtilities.getDeepestComponentAt(this.myRootPane.getContentPane().getParent(), point.x, point.y);
                if (target instanceof DnDAware && (overSelection = ((DnDAware)target).isOverSelection(targetPoint = SwingUtilities.convertPoint(this.myRootPane.getContentPane().getParent(), point.x, point.y, target)))) {
                    MouseListener[] listeners = (MouseListener[])target.getListeners(MouseListener.class);
                    MouseEvent mouseEvent = IdeGlassPaneImpl.convertEvent(me, target);
                    switch (me.getID()) {
                        case 501: {
                            AWTEventListener[] eventListeners;
                            boolean consumed = false;
                            if (target.isFocusable()) {
                                target.requestFocus();
                            }
                            for (MouseListener listener2 : listeners) {
                                String className = listener2.getClass().getName();
                                if (className.indexOf("BasicTreeUI$") >= 0 || className.indexOf("MacTreeUI$") >= 0) continue;
                                IdeGlassPaneImpl.fireMouseEvent(listener2, mouseEvent);
                                if (!mouseEvent.isConsumed()) continue;
                                consumed = true;
                                break;
                            }
                            if (!mouseEvent.isConsumed() && (eventListeners = Toolkit.getDefaultToolkit().getAWTEventListeners(16L)) != null && eventListeners.length > 0) {
                                for (AWTEventListener eventListener : eventListeners) {
                                    eventListener.eventDispatched(me);
                                    if (me.isConsumed()) break;
                                }
                                if (me.isConsumed()) {
                                    consumed = true;
                                    break;
                                }
                            }
                            if (!consumed) {
                                this.myPrevPressEvent = mouseEvent;
                            } else {
                                me.consume();
                            }
                            dispatched = true;
                            break;
                        }
                        case 502: {
                            if (this.myPrevPressEvent == null || this.myPrevPressEvent.getComponent() != target) break;
                            for (MouseListener listener3 : listeners) {
                                String className = listener3.getClass().getName();
                                if (className.indexOf("BasicTreeUI$") >= 0 || className.indexOf("MacTreeUI$") >= 0) {
                                    IdeGlassPaneImpl.fireMouseEvent(listener3, this.myPrevPressEvent);
                                    IdeGlassPaneImpl.fireMouseEvent(listener3, mouseEvent);
                                    if (mouseEvent.isConsumed()) break;
                                }
                                IdeGlassPaneImpl.fireMouseEvent(listener3, mouseEvent);
                                if (mouseEvent.isConsumed()) break;
                            }
                            if (mouseEvent.isConsumed()) {
                                me.consume();
                            }
                            this.myPrevPressEvent = null;
                            dispatched = true;
                            break;
                        }
                        default: {
                            this.myPrevPressEvent = null;
                        }
                    }
                }
            }
        }
        if (this.isVisible() && this.getComponentCount() == 0) {
            boolean cursorSet = false;
            if (meComponent != null) {
                Component target;
                Point point = SwingUtilities.convertPoint(meComponent, me.getPoint(), this.myRootPane.getContentPane());
                if (this.myRootPane.getMenuBar() != null && this.myRootPane.getMenuBar().isVisible()) {
                    point.y += this.myRootPane.getMenuBar().getHeight();
                }
                if ((target = SwingUtilities.getDeepestComponentAt(this.myRootPane.getContentPane().getParent(), point.x, point.y)) != null) {
                    this.setCursor(target.getCursor());
                    cursorSet = true;
                }
            }
            if (!cursorSet) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        return dispatched;
    }

    private static boolean isContextMenu(Window window) {
        if (window != null) {
            for (Component component : window.getComponents()) {
                if (!(component instanceof JComponent) || UIUtil.findComponentOfType((JComponent)((JComponent)component), JPopupMenu.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean preprocess(MouseEvent e, boolean motion, JRootPane eventRootPane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean canProcessCursorFor(Component target) {
        return !(target instanceof JMenu) && !(target instanceof JMenuItem) && !(target instanceof Divider) && !(target instanceof JSeparator) && (!(target instanceof JEditorPane) || !(((JEditorPane)target).getEditorKit() instanceof HTMLEditorKit));
    }

    private Component getCompWithCursor(Component c) {
        for (Component eachParentWithCursor = c; eachParentWithCursor != null; eachParentWithCursor = eachParentWithCursor.getParent()) {
            if (!eachParentWithCursor.isCursorSet()) continue;
            return eachParentWithCursor;
        }
        return null;
    }

    private void restoreLastComponent(Component newC) {
        if (this.myLastCursorComponent != null && this.myLastCursorComponent != newC) {
            this.myLastCursorComponent.setCursor(this.myLastOriginalCursor);
            if (this.myLastCursorComponent instanceof JComponent) {
                ((JComponent)this.myLastCursorComponent).putClientProperty(PREPROCESSED_CURSOR_KEY, null);
            }
        }
    }

    public static boolean hasPreProcessedCursor(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeGlassPaneImpl", "hasPreProcessedCursor"));
        }
        return component.getClientProperty(PREPROCESSED_CURSOR_KEY) != null;
    }

    public void setCursor(Cursor cursor, @NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/wm/impl/IdeGlassPaneImpl", "setCursor"));
        }
        if (cursor == null) {
            this.myListener2Cursor.remove(requestor);
        } else {
            this.myListener2Cursor.put(requestor, cursor);
        }
    }

    private static MouseEvent convertEvent(MouseEvent e, Component target) {
        Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), target);
        return MouseEventAdapter.convert((MouseEvent)e, (Component)target, (int)point.x, (int)point.y);
    }

    private static void fireMouseEvent(MouseListener listener2, MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                listener2.mousePressed(event);
                break;
            }
            case 502: {
                listener2.mouseReleased(event);
                break;
            }
            case 504: {
                listener2.mouseEntered(event);
                break;
            }
            case 505: {
                listener2.mouseExited(event);
                break;
            }
            case 500: {
                listener2.mouseClicked(event);
            }
        }
    }

    private static void fireMouseMotion(MouseMotionListener listener2, MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                listener2.mouseDragged(event);
            }
            case 503: {
                listener2.mouseMoved(event);
            }
        }
    }

    public void addMousePreprocessor(MouseListener listener2, Disposable parent) {
        this._addListener(listener2, parent);
    }

    public void addMouseMotionPreprocessor(MouseMotionListener listener2, Disposable parent) {
        this._addListener(listener2, parent);
    }

    private void _addListener(final EventListener listener2, Disposable parent) {
        if (!this.myMouseListeners.contains(listener2)) {
            this.myMouseListeners.add(listener2);
            this.updateSortedList();
        }
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IdeGlassPaneImpl.this.removeListener(listener2);
                    }
                });
            }
        });
    }

    public void removeMousePreprocessor(MouseListener listener2) {
        this.removeListener(listener2);
    }

    public void removeMouseMotionPreprocessor(MouseMotionListener listener2) {
        this.removeListener(listener2);
    }

    private void removeListener(EventListener listener2) {
        if (this.myMouseListeners.remove(listener2)) {
            this.updateSortedList();
        }
        this.deactivateIfNeeded();
    }

    private void updateSortedList() {
        this.mySortedMouseListeners.clear();
        this.mySortedMouseListeners.addAll(this.myMouseListeners);
    }

    private void deactivateIfNeeded() {
        if (this.myPreprocessorActive && this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = false;
        }
        this.applyActivationState();
    }

    private void activateIfNeeded() {
        if (!this.myPreprocessorActive && !this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = true;
        }
        this.applyActivationState();
    }

    private void applyActivationState() {
        IdeEventQueue queue;
        boolean hasWork;
        boolean wasVisible = this.isVisible();
        boolean bl = hasWork = this.getPainters().hasPainters() || this.getComponentCount() > 0;
        if (wasVisible != hasWork) {
            this.setVisible(hasWork);
        }
        if (!(queue = IdeEventQueue.getInstance()).containsDispatcher(this) && (this.myPreprocessorActive || this.isVisible())) {
            queue.addDispatcher(this, null);
        } else if (queue.containsDispatcher(this) && !this.myPreprocessorActive && !this.isVisible()) {
            queue.removeDispatcher(this);
        }
        if (wasVisible != this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @NotNull
    PaintersHelper getNamedPainters(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/wm/impl/IdeGlassPaneImpl", "getNamedPainters"));
        }
        PaintersHelper paintersHelper = this.myNamedPainters.get(name);
        if (paintersHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeGlassPaneImpl", "getNamedPainters"));
        }
        return paintersHelper;
    }

    @NotNull
    private PaintersHelper getPainters() {
        PaintersHelper paintersHelper = this.getNamedPainters("glass");
        if (paintersHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeGlassPaneImpl", "getPainters"));
        }
        return paintersHelper;
    }

    public void addPainter(Component component, final Painter painter, Disposable parent) {
        this.getPainters().addPainter(painter, component);
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeGlassPaneImpl.this.removePainter(painter);
                    }
                });
            }
        });
    }

    public void removePainter(Painter painter) {
        this.getPainters().removePainter(painter);
        this.deactivateIfNeeded();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeGlassPaneImpl.this.activateIfNeeded();
            }
        });
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeGlassPaneImpl.this.deactivateIfNeeded();
            }
        });
    }

    @Override
    public boolean isInModalContext() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof GlassPaneDialogWrapperPeer.TransparentLayeredPane)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.getPainters().paint(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public Component getTargetComponentFor(MouseEvent e) {
        Component candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getLayeredPane());
        if (candidate != null) {
            return candidate;
        }
        candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getContentPane());
        if (candidate != null) {
            return candidate;
        }
        return e.getComponent();
    }

    private static Component findComponent(MouseEvent e, Container container) {
        Point lpPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), container);
        return SwingUtilities.getDeepestComponentAt(container, lpPoint.x, lpPoint.y);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.getPainters().hasPainters() && super.isOptimizedDrawingEnabled();
    }
}

