/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.platform.ProjectBaseDirectory;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class PlatformFrameTitleBuilder
extends FrameTitleBuilder {
    @Override
    public String getProjectTitle(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/PlatformFrameTitleBuilder", "getProjectTitle"));
        }
        String basePath = project2.getBasePath();
        if (basePath == null) {
            return project2.getName();
        }
        if ((basePath = FileUtil.toSystemDependentName((String)basePath)).equals(project2.getName())) {
            return "[" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
        }
        return project2.getName() + " - [" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
    }

    @Override
    public String getFileTitle(@NotNull Project project2, @NotNull VirtualFile file2) {
        String projectHomeUrl;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/PlatformFrameTitleBuilder", "getFileTitle"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/PlatformFrameTitleBuilder", "getFileTitle"));
        }
        String fileTitle = EditorTabbedContainer.calcTabTitle(project2, file2);
        if (SystemInfo.isMac) {
            return fileTitle;
        }
        VirtualFile parent = file2.getParent();
        if (parent == null || !fileTitle.endsWith(file2.getPresentableName())) {
            return fileTitle;
        }
        String url = FileUtil.getLocationRelativeToUserHome((String)(parent.getPresentableUrl() + File.separator + file2.getName()));
        VirtualFile baseDir = ProjectBaseDirectory.getInstance(project2).getBaseDir();
        if (baseDir == null) {
            baseDir = project2.getBaseDir();
        }
        if (baseDir != null && url.startsWith(projectHomeUrl = FileUtil.getLocationRelativeToUserHome((String)baseDir.getPresentableUrl()))) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        return url;
    }
}

