/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class MinifiedFilesUtil {
    private static final int MAX_OFFSET = 2048;
    private static final int MIN_SIZE = 150;
    private static final int MIN_LINE_LENGTH = 100;
    private static final double MAX_UNNEEDED_OFFSET_PERCENTAGE = 0.01;
    private static final int COUNT_OF_CONSIDERING_CHARACTERS_FROM_END_OF_FILE = 400;

    private MinifiedFilesUtil() {
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition, @NotNull TokenSet noWSRequireAfterTokenSet) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/psi/css/MinifiedFilesUtil", "isMinified"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/psi/css/MinifiedFilesUtil", "isMinified"));
        }
        if (noWSRequireAfterTokenSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noWSRequireAfterTokenSet", "com/intellij/psi/css/MinifiedFilesUtil", "isMinified"));
        }
        Lexer lexer = parserDefinition.createLexer(null);
        lexer.start(fileContent);
        if (!MinifiedFilesUtil.isMinified(lexer, parserDefinition, noWSRequireAfterTokenSet)) {
            return false;
        }
        if (lexer.getTokenType() == null) {
            return true;
        }
        int startOffset = fileContent.length() - 400;
        if (startOffset <= 0) {
            return true;
        }
        lexer.start(fileContent, startOffset, fileContent.length());
        return MinifiedFilesUtil.isMinified(lexer, parserDefinition, noWSRequireAfterTokenSet);
    }

    protected static boolean isMinified(Lexer lexer, ParserDefinition parserDefinition, TokenSet noWSRequireAfterTokenSet) {
        int offsetIgnoringComments = 0;
        int offsetIgnoringCommentsAndStrings = 0;
        int lineLength = 0;
        int unneededWhitespaceCount = 0;
        String lastTokenText = null;
        IElementType lastTokenType = null;
        TokenSet whitespaceTokens = parserDefinition.getWhitespaceTokens();
        TokenSet stringLiteralElements = parserDefinition.getStringLiteralElements();
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            if (commentTokens.contains(tokenType)) {
                lastTokenType = tokenType;
                lastTokenText = lexer.getTokenText();
            } else {
                int tokenLength = lexer.getTokenEnd() - lexer.getTokenStart();
                offsetIgnoringComments += tokenLength;
                if (stringLiteralElements.contains(tokenType)) {
                    lineLength += tokenLength;
                    lastTokenType = tokenType;
                    lastTokenText = lexer.getTokenText();
                } else {
                    offsetIgnoringCommentsAndStrings += tokenLength;
                    if (whitespaceTokens.contains(tokenType)) {
                        if (!commentTokens.contains(lastTokenType) && tokenLength > 1) {
                            lexer.advance();
                            if (lexer.getTokenType() == null) break;
                            return false;
                        }
                        if (tokenLength == 1 && StringUtil.equals((CharSequence)lastTokenText, (CharSequence)"\n") && StringUtil.equals((CharSequence)lexer.getTokenText(), (CharSequence)"\n")) {
                            ++unneededWhitespaceCount;
                        } else if (tokenLength > 0 && noWSRequireAfterTokenSet.contains(lastTokenType)) {
                            ++unneededWhitespaceCount;
                        }
                        if (lexer.getTokenText().contains("\n")) {
                            if (lineLength > 100) break;
                            lineLength = 0;
                        }
                    } else {
                        lineLength += tokenLength;
                    }
                    if (offsetIgnoringComments >= 2048) break;
                    lastTokenType = tokenType;
                    lastTokenText = lexer.getTokenText();
                }
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
        return offsetIgnoringComments >= 150 && ((double)unneededWhitespaceCount + 0.0) / (double)offsetIgnoringCommentsAndStrings < 0.01;
    }

    public static boolean isMinified(@NotNull CharSequence fileContent, @NotNull ParserDefinition parserDefinition) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/psi/css/MinifiedFilesUtil", "isMinified"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/psi/css/MinifiedFilesUtil", "isMinified"));
        }
        return MinifiedFilesUtil.isMinified(fileContent, parserDefinition, TokenSet.EMPTY);
    }
}

