/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.PsiSubstitutorImpl");
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        public int computeHashCode(PsiTypeParameter object) {
            String name = object.getName();
            return name == null ? 0 : name.hashCode();
        }

        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent((PsiElement)element1, (PsiElement)element2);
        }
    };
    private final Map<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor;
    private static RecursionGuard ourGuard = RecursionManager.createGuard((String)"substituteGuard");

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = new THashMap(map, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl() {
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = new THashMap(2, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this();
        this.mySubstitutionMap.put(typeParameter, mapping);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/PsiSubstitutorImpl", "<init>"));
        }
        this();
        this.putAllInternal(parentClass, mappings);
    }

    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "substitute"));
        }
        if (this.containsInMap(typeParameter)) {
            return this.getFromMap(typeParameter);
        }
        return JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getElementFactory().createType((PsiClass)typeParameter);
    }

    private boolean containsInMap(PsiTypeParameter typeParameter) {
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.containsKey(typeParameter);
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "getFromMap"));
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.get(typeParameter);
    }

    public PsiType substitute(PsiType type) {
        if (type == null) {
            return null;
        }
        PsiUtil.ensureValidType((PsiType)type);
        PsiType substituted = (PsiType)type.accept((PsiTypeVisitor)this.mySimpleSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type);
    }

    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "substituteWithBoundsPromotion"));
        }
        PsiType substituted = this.substitute(typeParameter);
        if (substituted instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiWildcardType wildcardType = (PsiWildcardType)substituted;
            PsiType glb = PsiCapturedWildcardType.captureUpperBound((PsiTypeParameter)typeParameter, (PsiWildcardType)wildcardType, (PsiSubstitutor)this);
            if (glb instanceof PsiWildcardType) {
                return glb;
            }
            if (glb != null) {
                return glb instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)glb).getWildcard() : PsiWildcardType.createExtends((PsiManager)typeParameter.getManager(), (PsiType)glb);
            }
        }
        return substituted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSubstitutorImpl)) {
            return false;
        }
        PsiSubstitutorImpl that = (PsiSubstitutorImpl)o;
        return !(this.mySubstitutionMap != null ? !this.mySubstitutionMap.equals(that.mySubstitutionMap) : that.mySubstitutionMap != null);
    }

    public int hashCode() {
        return this.mySubstitutionMap != null ? this.mySubstitutionMap.hashCode() : 0;
    }

    private PsiType rawTypeForTypeParameter(PsiTypeParameter typeParameter) {
        final PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
        if (extendsTypes.length > 0) {
            return (PsiType)ourGuard.doPreventingRecursion((Object)extendsTypes[0], true, (Computable)new Computable<PsiType>(){

                public PsiType compute() {
                    return PsiSubstitutorImpl.this.substitute((PsiType)extendsTypes[0]);
                }
            });
        }
        return PsiType.getJavaLangObject((PsiManager)typeParameter.getManager(), (GlobalSearchScope)typeParameter.getResolveScope());
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/psi/impl/PsiSubstitutorImpl", "correctExternalSubstitution"));
        }
        if (substituted != null) {
            return substituted;
        }
        return (PsiType)original.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType((PsiType)arrayType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType((PsiType)ellipsisType.getComponentType().accept((PsiTypeVisitor)this));
            }

            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return classType;
                }
                if (aClass instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass);
                }
                return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass);
            }

            public PsiType visitType(PsiType type) {
                return null;
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        return new PsiSubstitutorImpl(this.mySubstitutionMap);
    }

    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl", "put"));
        }
        PsiSubstitutorImpl ret = this.clone();
        if (mapping != null && !mapping.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping + "; " + mapping.getClass());
        }
        ret.mySubstitutionMap.put(typeParameter, mapping);
        PsiSubstitutorImpl psiSubstitutorImpl = ret;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "put"));
        }
        return psiSubstitutorImpl;
    }

    private void putAllInternal(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAllInternal"));
        }
        PsiTypeParameter[] params = parentClass.getTypeParameters();
        for (int i = 0; i < params.length; ++i) {
            PsiTypeParameter param = params[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping = mappings[i];
                this.mySubstitutionMap.put(param, mapping);
                if (mapping == null || mapping.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping);
                continue;
            }
            this.mySubstitutionMap.put(param, null);
        }
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        PsiSubstitutorImpl substitutor = this.clone();
        substitutor.putAllInternal(parentClass, mappings);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        return psiSubstitutorImpl;
    }

    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        if (another instanceof EmptySubstitutorImpl) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        PsiSubstitutorImpl substitutor = this.clone();
        substitutor.mySubstitutionMap.putAll(anotherImpl.mySubstitutionMap);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor;
        if (psiSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "putAll"));
        }
        return psiSubstitutorImpl;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<PsiTypeParameter, PsiType>> set = this.mySubstitutionMap.entrySet();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : set) {
            PsiTypeParameter typeParameter = entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                PsiClass aClass = ((PsiMethod)owner).getContainingClass();
                buffer.append(aClass != null ? aClass.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(entry.getValue().getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static PsiSubstitutor createSubstitutor(@Nullable Map<PsiTypeParameter, PsiType> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY;
        }
        return new PsiSubstitutorImpl(map);
    }

    public boolean isValid() {
        for (PsiType type : this.mySubstitutionMap.values()) {
            if (type == null || type.isValid()) continue;
            return false;
        }
        return true;
    }

    public void ensureValid() {
        for (PsiType type : this.mySubstitutionMap.values()) {
            if (type == null) continue;
            PsiUtil.ensureValidType((PsiType)type);
        }
    }

    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        Map<PsiTypeParameter, PsiType> map = Collections.unmodifiableMap(this.mySubstitutionMap);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl", "getSubstitutionMap"));
        }
        return map;
    }

    private class SubstitutionVisitor
    extends PsiTypeMapper {
        private SubstitutionVisitor() {
        }

        @Override
        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType type) {
            return type;
        }

        @Override
        public PsiType visitType(PsiType type) {
            return null;
        }

        @Override
        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            PsiType newBound = (PsiType)bound.accept((PsiTypeVisitor)this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                PsiType newBoundBound = ((PsiWildcardType)newBound).getBound();
                return !((PsiWildcardType)newBound).isBounded() ? PsiWildcardType.createUnbounded((PsiManager)wildcardType.getManager()) : this.rebound(wildcardType, newBoundBound);
            }
            return newBound == PsiType.NULL ? newBound : this.rebound(wildcardType, newBound);
        }

        private PsiWildcardType rebound(PsiWildcardType type, PsiType newBound) {
            LOG.assertTrue(type.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    return PsiWildcardType.createUnbounded((PsiManager)type.getManager());
                }
                return PsiWildcardType.createExtends((PsiManager)type.getManager(), (PsiType)newBound);
            }
            return PsiWildcardType.createSuper((PsiManager)type.getManager(), (PsiType)newBound);
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return classType;
            }
            PsiUtilCore.ensureValid((PsiElement)aClass);
            if (aClass instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                if (PsiSubstitutorImpl.this.containsInMap(typeParameter)) {
                    PsiType result = this.substituteTypeParameter(typeParameter);
                    if (result != null) {
                        PsiUtil.ensureValidType((PsiType)result);
                    }
                    return result;
                }
                return classType;
            }
            HashMap hashMap = new HashMap(2);
            if (!this.processClass(aClass, resolveResult.getSubstitutor(), (Map<PsiTypeParameter, PsiType>)hashMap)) {
                return null;
            }
            PsiClassType result = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, PsiSubstitutorImpl.createSubstitutor((Map<PsiTypeParameter, PsiType>)hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType((PsiType)result);
            return result;
        }

        private PsiType substituteTypeParameter(@NotNull PsiTypeParameter typeParameter) {
            if (typeParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor", "substituteTypeParameter"));
            }
            return PsiSubstitutorImpl.this.getFromMap(typeParameter);
        }

        private PsiType substituteInternal(PsiType type) {
            return (PsiType)type.accept((PsiTypeVisitor)this);
        }

        private boolean processClass(PsiClass resolve, PsiSubstitutor originalSubstitutor, Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params;
            for (PsiTypeParameter param : params = resolve.getTypeParameters()) {
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                substMap.put(param, this.substituteInternal(original));
            }
            if (resolve.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }
    }
}

