/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.google.common.primitives.Ints;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.printer.idea.ColorGenerator;
import com.intellij.vcs.log.printer.idea.GraphCellPainter;
import com.intellij.vcs.log.printer.idea.PositionUtil;
import com.intellij.vcs.log.printer.idea.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRender;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends JBTable
implements DataProvider,
CopyProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogGraphTable.class);
    public static final int ROOT_INDICATOR_COLORED_WIDTH = 8;
    public static final int ROOT_INDICATOR_WHITE_WIDTH = 5;
    private static final int ROOT_INDICATOR_WIDTH = 13;
    private static final int ROOT_NAME_MAX_WIDTH = 200;
    private static final int MAX_DEFAULT_AUTHOR_COLUMN_WIDTH = 200;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    private static final int MAX_ROWS_TO_CALC_OFFSET = 100;
    @NotNull
    private final VcsLogUiImpl myUI;
    private final VcsLogDataHolder myLogDataHolder;
    private final MyDummyTableCellEditor myDummyEditor;
    @NotNull
    private final TableCellRenderer myDummyRenderer;
    private final GraphCommitCellRender myGraphCommitCellRenderer;
    private boolean myColumnsSizeInitialized;
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters;
    private final GraphCellPainter myGraphCellPainter;

    public VcsLogGraphTable(@NotNull VcsLogUiImpl UI2, @NotNull VcsLogDataHolder logDataHolder, @NotNull VisiblePack initialDataPack) {
        if (UI2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "UI", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "<init>"));
        }
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "<init>"));
        }
        this.myDummyEditor = new MyDummyTableCellEditor();
        this.myDummyRenderer = new DefaultTableCellRenderer();
        this.myColumnsSizeInitialized = false;
        this.myHighlighters = ContainerUtil.newArrayList();
        this.myGraphCellPainter = new SimpleGraphCellPainter(new ColorGenerator(){

            @Override
            public Color getColor(int colorId) {
                return com.intellij.vcs.log.graph.ColorGenerator.getColor(colorId);
            }
        }){

            @Override
            protected int getRowHeight() {
                return VcsLogGraphTable.this.getRowHeight();
            }
        };
        this.myUI = UI2;
        this.myLogDataHolder = logDataHolder;
        this.myGraphCommitCellRenderer = new GraphCommitCellRender(logDataHolder, this.myGraphCellPainter, this);
        this.setDefaultRenderer(VirtualFile.class, new RootCellRenderer(this.myUI));
        this.setDefaultRenderer(GraphCommitCell.class, (TableCellRenderer)((Object)this.myGraphCommitCellRenderer));
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringCellRenderer()));
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.setTableHeader((JTableHeader)((Object)new InvisibleResizableHeader()));
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        ScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
        GraphTableModel model = new GraphTableModel(initialDataPack, this.myLogDataHolder, this.myUI);
        this.setModel(model);
        this.initColumnSize();
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permGraphChanged) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "updateDataPack"));
        }
        Selection previousSelection = this.getSelection();
        this.getGraphTableModel().setVisiblePack(visiblePack);
        previousSelection.restore(visiblePack.getVisibleGraph(), true);
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            highlighter.update((VcsLogDataPack)visiblePack, permGraphChanged);
        }
        this.setPaintBusy(false);
        this.initColumnSize();
    }

    boolean initColumnSize() {
        if (!this.myColumnsSizeInitialized && this.getModel().getRowCount() > 0) {
            this.myColumnsSizeInitialized = this.setColumnPreferredSize();
            if (this.myColumnsSizeInitialized) {
                this.setAutoCreateColumnsFromModel(false);
                for (int column = 0; column < this.getColumnCount(); ++column) {
                    this.getColumnModel().getColumn(column).setResizable(column != 0);
                }
            }
            return this.myColumnsSizeInitialized;
        }
        return false;
    }

    private boolean setColumnPreferredSize() {
        boolean sizeCalculated = false;
        Font tableFont = UIManager.getFont("Table.font");
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            if (i == 0) {
                this.setRootColumnSize(column);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(Short.MAX_VALUE);
                continue;
            }
            if (i == 2) {
                int maxRowsToCheck = Math.min(1000, this.getRowCount() - 100);
                if (maxRowsToCheck < 0) {
                    maxRowsToCheck = this.getRowCount();
                }
                int maxWidth = 0;
                for (int row = 0; row < maxRowsToCheck; ++row) {
                    String value = this.getModel().getValueAt(row, i).toString();
                    maxWidth = Math.max(this.getFontMetrics(tableFont).stringWidth(value), maxWidth);
                    if (value.isEmpty()) continue;
                    sizeCalculated = true;
                }
                column.setMinWidth(Math.min(maxWidth + 10, 200));
                column.setWidth(column.getMinWidth());
                continue;
            }
            if (i != 3) continue;
            column.setMinWidth(this.getFontMetrics(tableFont).stringWidth("mm" + DateFormatUtil.formatDateTime((Date)new Date())));
            column.setWidth(column.getMinWidth());
        }
        return sizeCalculated;
    }

    private void setRootColumnSize(TableColumn column) {
        int rootWidth = !this.myUI.isMultipleRoots() ? 0 : (!this.myUI.isShowRootNames() ? 13 : Math.min(this.calculateMaxRootWidth(), 200));
        column.setMinWidth(rootWidth);
        column.setMaxWidth(rootWidth);
        column.setPreferredWidth(rootWidth);
    }

    private int calculateMaxRootWidth() {
        int width = 0;
        for (VirtualFile file2 : this.myLogDataHolder.getRoots()) {
            Font tableFont = UIManager.getFont("Table.font");
            width = Math.max(this.getFontMetrics(tableFont).stringWidth(file2.getName() + "  "), width);
        }
        return width;
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        Object at;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getToolTipText"));
        }
        int row = this.rowAtPoint(event.getPoint());
        int column = this.columnAtPoint(event.getPoint());
        if (column < 0 || row < 0) {
            return null;
        }
        if (column == 0 && (at = this.getValueAt(row, column)) instanceof VirtualFile) {
            return "<html><b>" + ((VirtualFile)at).getPresentableUrl() + "</b><br/>Click to " + (this.myUI.isShowRootNames() ? "collapse" : "expand") + "</html>";
        }
        return null;
    }

    public void jumpToRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        List<VcsFullCommitDetails> details;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "performCopy"));
        }
        VcsLog log = (VcsLog)VcsLogDataKeys.VCS_LOG.getData(dataContext);
        if (log != null && !(details = VcsLogUtil.collectFirstPackOfLoadedSelectedDetails(log)).isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(details, (Function)new Function<VcsFullCommitDetails, String>(){

                public String fun(VcsFullCommitDetails details) {
                    return details.getSubject();
                }
            }, (String)"\n")));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "isCopyEnabled"));
        }
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "isCopyVisible"));
        }
        return true;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "addHighlighter"));
        }
        this.myHighlighters.add(highlighter);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "removeHighlighter"));
        }
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    public SimpleTextAttributes applyHighlighters(@NotNull Component rendererComponent, int row, int column, String text, boolean hasFocus, boolean selected) {
        if (rendererComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rendererComponent", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "applyHighlighters"));
        }
        VcsLogHighlighter.VcsCommitStyle style = this.getStyle(row, column, text, hasFocus, selected);
        assert (style.getBackground() != null && style.getForeground() != null && style.getTextStyle() != null);
        rendererComponent.setBackground(style.getBackground());
        rendererComponent.setForeground(style.getForeground());
        switch (style.getTextStyle()) {
            case BOLD: {
                return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            case ITALIC: {
                return SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    private VcsLogHighlighter.VcsCommitStyle getStyle(int row, int column, String text, boolean hasFocus, final boolean selected) {
        Component dummyRendererComponent = this.myDummyRenderer.getTableCellRendererComponent((JTable)((Object)this), text, selected, hasFocus, row, column);
        VisibleGraph<Integer> visibleGraph = this.getVisibleGraph();
        if (row < 0 || row >= visibleGraph.getVisibleCommitCount()) {
            LOG.error("Visible graph has " + visibleGraph.getVisibleCommitCount() + " commits, yet we want row " + row);
            return VcsCommitStyleFactory.createStyle((Color)dummyRendererComponent.getForeground(), (Color)dummyRendererComponent.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        }
        RowInfo rowInfo = visibleGraph.getRowInfo(row);
        VcsLogHighlighter.VcsCommitStyle defaultStyle = VcsCommitStyleFactory.createStyle((Color)(rowInfo.getRowType() == RowType.UNMATCHED ? JBColor.GRAY : dummyRendererComponent.getForeground()), (Color)dummyRendererComponent.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        final VcsShortCommitDetails details = this.myLogDataHolder.getMiniDetailsGetter().getCommitDataIfAvailable((Integer)rowInfo.getCommit());
        if (details == null || details instanceof LoadingDetails) {
            return defaultStyle;
        }
        List styles = ContainerUtil.map(this.myHighlighters, (Function)new Function<VcsLogHighlighter, VcsLogHighlighter.VcsCommitStyle>(){

            public VcsLogHighlighter.VcsCommitStyle fun(VcsLogHighlighter highlighter) {
                return highlighter.getStyle(details, selected);
            }
        });
        return VcsCommitStyleFactory.combine((Collection)ContainerUtil.append((List)styles, (Object[])new VcsLogHighlighter.VcsCommitStyle[]{defaultStyle}));
    }

    public void viewportSet(JViewport viewport) {
        viewport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TableModel model = VcsLogGraphTable.this.getModel();
                if (model instanceof AbstractTableModel) {
                    Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)VcsLogGraphTable.this));
                    ((AbstractTableModel)model).fireTableChanged(new TableModelEvent(model, (Integer)visibleRows.first - 1, (Integer)visibleRows.second, 0));
                }
            }
        });
    }

    private boolean expandOrCollapseRoots(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "expandOrCollapseRoots"));
        }
        TableColumn column = this.getRootColumnOrNull(e);
        if (column != null) {
            this.myUI.setShowRootNames(!this.myUI.isShowRootNames());
            return true;
        }
        return false;
    }

    public void rootColumnUpdated() {
        this.setColumnPreferredSize();
        this.setRootColumnSize(this.getColumnModel().getColumn(0));
    }

    @Nullable
    private TableColumn getRootColumnOrNull(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getRootColumnOrNull"));
        }
        if (!this.myLogDataHolder.isMultiRoot()) {
            return null;
        }
        int column = this.convertColumnIndexToModel(this.columnAtPoint(e.getPoint()));
        if (column == 0) {
            return this.getColumnModel().getColumn(column);
        }
        return null;
    }

    public static JBColor getRootBackgroundColor(@NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getRootBackgroundColor"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getRootBackgroundColor"));
        }
        return VcsLogColorManagerImpl.getBackgroundColor(colorManager.getRootColor(root));
    }

    public void handleAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange, @Nullable Selection previousSelection) {
        Integer row;
        if (dataCouldChange) {
            GraphTableModel graphTableModel = (GraphTableModel)this.getModel();
            graphTableModel.fireTableDataChanged();
            if (previousSelection != null) {
                previousSelection.restore(this.getVisibleGraph(), answer == null || answer.getCommitToJump() != null);
            }
        }
        this.myUI.repaintUI();
        if (answer == null) {
            return;
        }
        if (answer.getCursorToSet() != null) {
            this.setCursor(answer.getCursorToSet());
        }
        if (answer.getCommitToJump() != null && (row = this.getGraphTableModel().getVisiblePack().getVisibleGraph().getVisibleRowIndex(answer.getCommitToJump())) != null && row >= 0) {
            this.jumpToRow(row);
        }
    }

    @NotNull
    public GraphTableModel getGraphTableModel() {
        GraphTableModel graphTableModel = (GraphTableModel)this.getModel();
        if (graphTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getGraphTableModel"));
        }
        return graphTableModel;
    }

    @NotNull
    public Selection getSelection() {
        Selection selection = new Selection(this);
        if (selection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getSelection"));
        }
        return selection;
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.getGraphTableModel().getVisiblePack().getVisibleGraph();
        if (visibleGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getVisibleGraph"));
        }
        return visibleGraph;
    }

    @NotNull
    private Point calcPoint4Graph(@NotNull Point clickPoint) {
        if (clickPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clickPoint", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "calcPoint4Graph"));
        }
        Point point = new Point(clickPoint.x - this.getXOffset(), PositionUtil.getYInsideRow(clickPoint, this.getRowHeight()));
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "calcPoint4Graph"));
        }
        return point;
    }

    private int getXOffset() {
        TableColumn rootColumn = this.getColumnModel().getColumn(0);
        return this.myLogDataHolder.isMultiRoot() ? rootColumn.getWidth() : 0;
    }

    public TableCellEditor getCellEditor() {
        return this.myDummyEditor;
    }

    public int getRowHeight() {
        return this.myGraphCommitCellRenderer.getPreferredHeight();
    }

    private static class MyBasicTableHeaderUI
    extends BasicTableHeaderUI
    implements MouseInputListener {
        public MyBasicTableHeaderUI(@NotNull JTableHeader tableHeader) {
            if (tableHeader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableHeader", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "<init>"));
            }
            this.header = tableHeader;
            this.mouseInputListener = this.createMouseInputListener();
        }

        @NotNull
        private MouseEvent convertMouseEvent(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "convertMouseEvent"));
            }
            MouseEvent mouseEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), 0, e.getXOnScreen(), this.header.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            if (mouseEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "convertMouseEvent"));
            }
            return mouseEvent;
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseClicked"));
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "mousePressed"));
            }
            this.mouseInputListener.mousePressed(this.convertMouseEvent(e));
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseReleased"));
            }
            this.mouseInputListener.mouseReleased(this.convertMouseEvent(e));
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseEntered"));
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseExited"));
            }
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseDragged"));
            }
            this.mouseInputListener.mouseDragged(this.convertMouseEvent(e));
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseMoved"));
            }
            this.mouseInputListener.mouseMoved(this.convertMouseEvent(e));
        }
    }

    private static class EmptyTableCellRenderer
    implements TableCellRenderer {
        private EmptyTableCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setMaximumSize(new Dimension(0, 0));
            JPanel jPanel = panel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$EmptyTableCellRenderer", "getTableCellRendererComponent"));
            }
            return jPanel;
        }
    }

    private class InvisibleResizableHeader
    extends JBTable.JBTableHeader {
        @NotNull
        private final MyBasicTableHeaderUI myHeaderUI;
        @Nullable
        private Cursor myCursor;

        public InvisibleResizableHeader() {
            super((JBTable)VcsLogGraphTable.this);
            this.myCursor = null;
            this.myHeaderUI = new MyBasicTableHeaderUI((JTableHeader)((Object)this));
            this.setDefaultRenderer(new EmptyTableCellRenderer());
            this.setReorderingAllowed(false);
        }

        public void setTable(JTable table) {
            JTable oldTable = this.getTable();
            if (oldTable != null) {
                oldTable.removeMouseListener(this.myHeaderUI);
                oldTable.removeMouseMotionListener(this.myHeaderUI);
            }
            super.setTable(table);
            if (table != null) {
                table.addMouseListener(this.myHeaderUI);
                table.addMouseMotionListener(this.myHeaderUI);
            }
        }

        public void setCursor(@Nullable Cursor cursor) {
            JTable table = this.getTable();
            if (table != null) {
                table.setCursor(cursor);
                this.myCursor = cursor;
            } else {
                super.setCursor(cursor);
            }
        }

        public Cursor getCursor() {
            if (this.myCursor == null) {
                JTable table = this.getTable();
                if (table == null) {
                    return super.getCursor();
                }
                return table.getCursor();
            }
            return this.myCursor;
        }

        @NotNull
        public Rectangle getHeaderRect(int column) {
            Rectangle headerRect = super.getHeaderRect(column);
            Rectangle rectangle = new Rectangle(headerRect.x, headerRect.y, headerRect.width, 1);
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$InvisibleResizableHeader", "getHeaderRect"));
            }
            return rectangle;
        }
    }

    private class MyDummyTableCellEditor
    implements TableCellEditor {
        private MyDummyTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (!(anEvent instanceof MouseEvent)) {
                return true;
            }
            MouseEvent e = (MouseEvent)anEvent;
            int row = PositionUtil.getRowIndex(e.getPoint(), VcsLogGraphTable.this.getRowHeight());
            if (row > VcsLogGraphTable.this.getRowCount() - 1) {
                return false;
            }
            Point point = VcsLogGraphTable.this.calcPoint4Graph(e.getPoint());
            Collection printElements = VcsLogGraphTable.this.getVisibleGraph().getRowInfo(row).getPrintElements();
            PrintElement printElement = VcsLogGraphTable.this.myGraphCellPainter.mouseOver(printElements, point.x, point.y);
            return printElement == null;
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class StringCellRenderer
    extends ColoredTableCellRenderer {
        private StringCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return;
            }
            this.append(value.toString(), VcsLogGraphTable.this.applyHighlighters((Component)((Object)this), row, column, value.toString(), hasFocus, selected));
            this.setBorder(null);
        }
    }

    private static class RootCellRenderer
    extends JBLabel
    implements TableCellRenderer {
        @NotNull
        private final VcsLogUiImpl myUi;
        @NotNull
        private Color myColor;
        @NotNull
        private Color myBorderColor;
        private boolean isNarrow;

        RootCellRenderer(@NotNull VcsLogUiImpl ui) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$RootCellRenderer", "<init>"));
            }
            super("", 0);
            this.myColor = UIUtil.getTableBackground();
            this.myBorderColor = UIUtil.getTableBackground();
            this.isNarrow = true;
            this.myUi = ui;
        }

        protected void paintComponent(Graphics g) {
            this.setFont(UIManager.getFont("Table.font"));
            g.setColor(this.myColor);
            int width = this.getWidth();
            if (this.isNarrow) {
                g.fillRect(0, 0, width - 5, this.myUi.getTable().getRowHeight());
                g.setColor(this.myBorderColor);
                g.fillRect(width - 5, 0, 5, this.myUi.getTable().getRowHeight());
            } else {
                g.fillRect(0, 0, width, this.myUi.getTable().getRowHeight());
            }
            super.paintComponent(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            String text;
            if (value instanceof VirtualFile) {
                VirtualFile root = (VirtualFile)value;
                int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)this.myUi.getTable().getRowHeight() * 0.5f));
                text = row < readableRow ? "" : (row == 0 || !value.equals(table.getModel().getValueAt(row - 1, column)) || readableRow == row ? root.getName() : "");
                color = VcsLogGraphTable.getRootBackgroundColor(root, this.myUi.getColorManager());
            } else {
                text = null;
                color = UIUtil.getTableBackground((boolean)isSelected);
            }
            this.myColor = color;
            Color background = ((VcsLogGraphTable)((Object)table)).getStyle(row, column, text, hasFocus, isSelected).getBackground();
            assert (background != null);
            this.myBorderColor = background;
            this.setForeground(UIUtil.getTableForeground((boolean)false));
            if (this.myUi.isShowRootNames()) {
                this.setText(text);
                this.isNarrow = false;
            } else {
                this.setText("");
                this.isNarrow = true;
            }
            return this;
        }

        public void setBackground(Color bg) {
            this.myBorderColor = bg;
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private final TableLinkMouseListener myLinkListener = new TableLinkMouseListener();

        MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            if (e.getClickCount() == 1 && !VcsLogGraphTable.this.expandOrCollapseRoots(e)) {
                this.performAction(e, GraphAction.Type.MOUSE_CLICK);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isAboveLink(e) || this.isAboveRoots(e)) {
                VcsLogGraphTable.this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (VcsLogGraphTable.this.getCursor() != Cursor.getPredefinedCursor(11)) {
                this.performAction(e, GraphAction.Type.MOUSE_OVER);
            }
        }

        private void performAction(@NotNull MouseEvent e, @NotNull GraphAction.Type actionType) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyMouseAdapter", "performAction"));
            }
            if (actionType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionType", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyMouseAdapter", "performAction"));
            }
            int row = PositionUtil.getRowIndex(e.getPoint(), VcsLogGraphTable.this.getRowHeight());
            if (row < 0 || row > VcsLogGraphTable.this.getRowCount() - 1) {
                return;
            }
            Point point = VcsLogGraphTable.this.calcPoint4Graph(e.getPoint());
            Collection printElements = VcsLogGraphTable.this.getVisibleGraph().getRowInfo(row).getPrintElements();
            PrintElement printElement = VcsLogGraphTable.this.myGraphCellPainter.mouseOver(printElements, point.x, point.y);
            Selection previousSelection = VcsLogGraphTable.this.getSelection();
            GraphAnswer answer = VcsLogGraphTable.this.getVisibleGraph().getActionController().performAction((GraphAction)new GraphAction.GraphActionImpl(printElement, actionType));
            VcsLogGraphTable.this.handleAnswer((GraphAnswer<Integer>)answer, actionType == GraphAction.Type.MOUSE_CLICK && printElement != null, previousSelection);
        }

        private boolean isAboveLink(MouseEvent e) {
            return this.myLinkListener.getTagAt(e) != null;
        }

        private boolean isAboveRoots(MouseEvent e) {
            TableColumn column = VcsLogGraphTable.this.getRootColumnOrNull(e);
            int row = VcsLogGraphTable.this.rowAtPoint(e.getPoint());
            return column != null && row >= 0 && row < VcsLogGraphTable.this.getRowCount();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static class Selection {
        @NotNull
        private final VcsLogGraphTable myTable;
        @NotNull
        private final TIntHashSet mySelectedCommits;
        @Nullable
        private final Integer myVisibleSelectedCommit;
        @Nullable
        private final Integer myDelta;
        private final boolean myScrollToTop;

        public Selection(@NotNull VcsLogGraphTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$Selection", "<init>"));
            }
            this.myTable = table;
            List selectedRows = ContainerUtil.sorted((Collection)Ints.asList((int[])this.myTable.getSelectedRows()));
            Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this.myTable));
            this.myScrollToTop = (Integer)visibleRows.first - 1 == 0;
            VisibleGraph<Integer> graph = this.myTable.getVisibleGraph();
            this.mySelectedCommits = new TIntHashSet();
            Integer visibleSelectedCommit = null;
            Integer delta = null;
            Iterator iterator = selectedRows.iterator();
            while (iterator.hasNext()) {
                int row = (Integer)iterator.next();
                if (row >= graph.getVisibleCommitCount()) continue;
                Integer commit = (Integer)graph.getRowInfo(row).getCommit();
                this.mySelectedCommits.add(commit.intValue());
                if ((Integer)visibleRows.first - 1 > row || row > (Integer)visibleRows.second || visibleSelectedCommit != null) continue;
                visibleSelectedCommit = commit;
                delta = this.myTable.getCellRect((int)row, (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
            }
            if (visibleSelectedCommit == null && (Integer)visibleRows.first - 1 >= 0) {
                visibleSelectedCommit = (Integer)graph.getRowInfo((Integer)visibleRows.first - 1).getCommit();
                delta = this.myTable.getCellRect((int)(((Integer)visibleRows.first).intValue() - 1), (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
            }
            this.myVisibleSelectedCommit = visibleSelectedCommit;
            this.myDelta = delta;
        }

        public void restore(@NotNull VisibleGraph<Integer> newVisibleGraph, boolean scrollToSelection) {
            if (newVisibleGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibleGraph", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$Selection", "restore"));
            }
            Pair<TIntHashSet, Integer> toSelectAndScroll = this.findRowsToSelectAndScroll(this.myTable.getGraphTableModel(), newVisibleGraph);
            if (!((TIntHashSet)toSelectAndScroll.first).isEmpty()) {
                this.myTable.getSelectionModel().setValueIsAdjusting(true);
                ((TIntHashSet)toSelectAndScroll.first).forEach(new TIntProcedure(){

                    public boolean execute(int row) {
                        myTable.addRowSelectionInterval(row, row);
                        return true;
                    }
                });
                this.myTable.getSelectionModel().setValueIsAdjusting(false);
            }
            if (scrollToSelection) {
                if (this.myScrollToTop) {
                    this.scrollToRow(0, 0);
                } else if (toSelectAndScroll.second != null) {
                    assert (this.myDelta != null);
                    this.scrollToRow((Integer)toSelectAndScroll.second, this.myDelta);
                }
            }
        }

        private void scrollToRow(Integer row, Integer delta) {
            Rectangle startRect = this.myTable.getCellRect(row, 0, true);
            this.myTable.scrollRectToVisible(new Rectangle(startRect.x, Math.max(startRect.y - delta, 0), startRect.width, this.myTable.getVisibleRect().height));
        }

        @NotNull
        private Pair<TIntHashSet, Integer> findRowsToSelectAndScroll(@NotNull GraphTableModel model, @NotNull VisibleGraph<Integer> visibleGraph) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
            }
            if (visibleGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
            }
            TIntHashSet rowsToSelect = new TIntHashSet();
            if (model.getRowCount() == 0) {
                Pair pair = Pair.create((Object)rowsToSelect, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
                }
                return pair;
            }
            Integer rowToScroll = null;
            for (int row = 0; row < visibleGraph.getVisibleCommitCount() && (rowsToSelect.size() < this.mySelectedCommits.size() || rowToScroll == null); ++row) {
                int commit = (Integer)visibleGraph.getRowInfo(row).getCommit();
                if (this.mySelectedCommits.contains(commit)) {
                    rowsToSelect.add(row);
                }
                if (this.myVisibleSelectedCommit == null || this.myVisibleSelectedCommit != commit) continue;
                rowToScroll = row;
            }
            Pair pair = Pair.create((Object)rowsToSelect, rowToScroll);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
            }
            return pair;
        }
    }
}

