/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.actions.ChooseDebugConfigurationPopupAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class ResumeAction
extends XDebuggerActionBase
implements DumbAware {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (session != null && !session.isStopped()) {
            return session.isPaused();
        }
        return !"DebuggerToolbar".equals(e.getPlace());
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project2;
        if (!this.performWithHandler(e) && (project2 = ResumeAction.getEventProject((AnActionEvent)e)) != null && !DumbService.isDumb((Project)project2)) {
            new ChooseDebugConfigurationPopupAction().actionPerformed(e);
        }
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSupport", "com/intellij/xdebugger/impl/actions/ResumeAction", "getHandler"));
        }
        DebuggerActionHandler debuggerActionHandler = debuggerSupport.getResumeActionHandler();
        if (debuggerActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/ResumeAction", "getHandler"));
        }
        return debuggerActionHandler;
    }
}

