/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.settings.XDebuggerDataViewSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DataViewsConfigurableUi {
    public static final String DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_KEY = "debugger.valueTooltipAutoShow";
    public static final String DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_ON_SELECTION_KEY = "debugger.valueTooltipAutoShowOnSelection";
    private JCheckBox enableAutoExpressionsCheckBox;
    private JFormattedTextField valueTooltipDelayTextField;
    private JPanel panel;
    private JCheckBox sortAlphabeticallyCheckBox;
    private JPanel myEditorSettingsPanel;
    private JCheckBox myShowValuesInlineCheckBox;
    private JCheckBox myShowValueTooltipCheckBox;
    private JCheckBox myShowValueTooltipOnCheckBox;
    private JBLabel myTooltipLabel;

    public DataViewsConfigurableUi() {
        this.$$$setupUI$$$();
        UIUtil.configureNumericFormattedTextField((JFormattedTextField)this.valueTooltipDelayTextField);
    }

    private int getValueTooltipDelay() {
        Object value = this.valueTooltipDelayTextField.getValue();
        return value instanceof Number ? ((Number)value).intValue() : StringUtilRt.parseInt((String)((String)value), (int)700);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "getComponent"));
        }
        return jPanel;
    }

    public boolean isModified(@NotNull XDebuggerDataViewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "isModified"));
        }
        return this.getValueTooltipDelay() != settings.getValueLookupDelay() || this.sortAlphabeticallyCheckBox.isSelected() != settings.isSortValues() || this.enableAutoExpressionsCheckBox.isSelected() != settings.isAutoExpressions() || this.myShowValuesInlineCheckBox.isSelected() != settings.isShowValuesInline() || this.myShowValueTooltipCheckBox.isSelected() != Registry.is((String)DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_KEY) || this.myShowValueTooltipOnCheckBox.isSelected() != Registry.is((String)DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_ON_SELECTION_KEY);
    }

    public void reset(@NotNull XDebuggerDataViewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "reset"));
        }
        this.valueTooltipDelayTextField.setValue(settings.getValueLookupDelay());
        this.sortAlphabeticallyCheckBox.setSelected(settings.isSortValues());
        this.enableAutoExpressionsCheckBox.setSelected(settings.isAutoExpressions());
        this.myShowValuesInlineCheckBox.setSelected(settings.isShowValuesInline());
        this.myShowValueTooltipCheckBox.setSelected(Registry.is((String)DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_KEY));
        this.myShowValueTooltipOnCheckBox.setSelected(Registry.is((String)DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_ON_SELECTION_KEY));
        this.myTooltipLabel.setText(XDebuggerBundle.message((String)"settings.tooltip.label", (Object[])new Object[]{Registry.stringValue((String)"ide.forcedShowTooltip")}));
    }

    public void apply(@NotNull XDebuggerDataViewSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xdebugger/impl/settings/DataViewsConfigurableUi", "apply"));
        }
        settings.setValueLookupDelay(this.getValueTooltipDelay());
        settings.setSortValues(this.sortAlphabeticallyCheckBox.isSelected());
        settings.setAutoExpressions(this.enableAutoExpressionsCheckBox.isSelected());
        settings.setShowValuesInline(this.myShowValuesInlineCheckBox.isSelected());
        Registry.get((String)DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_KEY).setValue(this.myShowValueTooltipCheckBox.isSelected());
        Registry.get((String)DEBUGGER_VALUE_TOOLTIP_AUTO_SHOW_ON_SELECTION_KEY).setValue(this.myShowValueTooltipOnCheckBox.isSelected());
    }

    private void createUIComponents() {
        this.myEditorSettingsPanel = new JPanel();
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)"Editor", (boolean)false);
        this.myEditorSettingsPanel.setBorder((Border)titledBorder);
        titledBorder.acceptMinimumSize((Component)this.myEditorSettingsPanel);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JFormattedTextField jFormattedTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.enableAutoExpressionsCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.enable.auto.expressions.label"));
        jPanel.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.sortAlphabeticallyCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.sort.alphabetically.label"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = this.myEditorSettingsPanel;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShowValuesInlineCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.show.values.inline"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myShowValueTooltipCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.show.value.tooltip"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowValueTooltipOnCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.show.tooltip.on.selection"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.valueTooltipDelayTextField = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setColumns(4);
        jPanel2.add((Component)jFormattedTextField, new GridConstraints(1, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("setting.value.tooltip.delay.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTooltipLabel = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("settings.tooltip.label"));
        jBLabel.setEnabled(false);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

