/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final boolean myIgnoreInAssertStatements;
    private int m_count;
    private boolean ignoring;

    public NegationCountVisitor(boolean ignoreInAssertStatements) {
        this.myIgnoreInAssertStatements = ignoreInAssertStatements;
    }

    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/methodmetrics/NegationCountVisitor", "visitPolyadicExpression"));
        }
        super.visitPolyadicExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        if (!this.ignoring && tokenType.equals(JavaTokenType.NE)) {
            this.m_count += expression.getOperands().length - 1;
        }
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/methodmetrics/NegationCountVisitor", "visitAnonymousClass"));
        }
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/methodmetrics/NegationCountVisitor", "visitPrefixExpression"));
        }
        super.visitPrefixExpression(expression);
        if (!this.ignoring && expression.getOperationTokenType().equals(JavaTokenType.EXCL)) {
            ++this.m_count;
        }
    }

    public void visitAssertStatement(PsiAssertStatement statement2) {
        if (this.myIgnoreInAssertStatements) {
            this.ignoring = true;
        }
        super.visitAssertStatement(statement2);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/methodmetrics/NegationCountVisitor", "elementFinished"));
        }
        super.elementFinished(element);
        if (element instanceof PsiAssertStatement) {
            this.ignoring = false;
        }
    }

    public int getCount() {
        return this.m_count;
    }
}

