/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugProcessImpl$WhenMappings;
import org.jetbrains.debugger.LineBreakpointHandler;
import org.jetbrains.debugger.LineBreakpointManager;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010E\u001a\u00020F2\u0006\u0010A\u001a\u00020BH\u0004J\u0010\u0010G\u001a\u00020F2\u0006\u0010A\u001a\u00020BH\u0014J\b\u0010H\u001a\u00020\u001cH\u0016J\u0006\u0010I\u001a\u00020\u001cJ\u0016\u0010J\u001a\b\u0012\u0002\b\u0003\u0018\u00010K2\u0006\u0010L\u001a\u00020,H\u0014J\u0017\u0010M\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH$\u00a2\u0006\u0002\u0010\u0012J\b\u0010N\u001a\u000205H\u0014J\u0010\u0010O\u001a\u00020F2\u0006\u0010P\u001a\u00020\u001cH\u0014JA\u0010Q\u001a8\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 R*\b\u0012\u0002\b\u0003\u0018\u00010\u00100\u0010 R*\u001c\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 R*\b\u0012\u0002\b\u0003\u0018\u00010\u00100\u0010\u0018\u00010\u000f0\u000f\u00a2\u0006\u0002\u0010\u0012J\r\u0010S\u001a\t\u0018\u00010T\u00a2\u0006\u0002\bUJ\u000b\u0010V\u001a\u00070W\u00a2\u0006\u0002\bXJ\u0006\u0010Y\u001a\u00020\bJ\u001a\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[2\n\u0010]\u001a\u0006\u0012\u0002\b\u00030^H\u0016J\f\u0010_\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nJ\u0010\u0010`\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020\u001cH\u0004J\b\u0010a\u001a\u00020\u001cH\u0016J\u0006\u0010b\u001a\u00020\u001cJ\b\u0010c\u001a\u00020\u001cH\u0014J\b\u0010d\u001a\u00020FH\u0016J\u0016\u0010e\u001a\u00020F2\u0006\u0010f\u001a\u00020=2\u0006\u0010g\u001a\u00020>J\u0014\u0010h\u001a\u00020F2\n\u0010i\u001a\u0006\u0012\u0002\b\u00030jH\u0004J\u0006\u0010k\u001a\u00020FJ\u0006\u0010l\u001a\u00020FJ\u0006\u0010m\u001a\u00020FJ\u0006\u0010n\u001a\u00020FJ\u0006\u0010o\u001a\u00020FJ\b\u0010p\u001a\u00020FH\u0002R$\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001c8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u001c8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 R \u0010%\u001a\u0004\u0018\u00010&8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R \u0010+\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001e\"\u0004\b3\u0010 R\u0016\u00104\u001a\u0004\u0018\u0001058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020>0<X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0013\u0010A\u001a\u0004\u0018\u00010B8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u00a8\u0006q"}, d2={"Lorg/jetbrains/debugger/DebugProcessImpl;", "C", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lcom/intellij/xdebugger/XDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "connection", "editorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "smartStepIntoHandler", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;Lcom/intellij/execution/ExecutionResult;)V", "_breakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "get_breakpointHandlers", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "_breakpointHandlers$delegate", "Lkotlin/Lazy;", "breakpointsInitiated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectedListenerAdded", "getConnection", "()Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/connection/VmConnection;", "disableDoNotStepIntoLibraries", "", "getDisableDoNotStepIntoLibraries", "()Z", "setDisableDoNotStepIntoLibraries", "(Z)V", "getExecutionResult", "()Lcom/intellij/execution/ExecutionResult;", "isForceStep", "setForceStep", "lastCallFrame", "Lorg/jetbrains/debugger/CallFrame;", "getLastCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "setLastCallFrame", "(Lorg/jetbrains/debugger/CallFrame;)V", "lastStep", "Lorg/jetbrains/debugger/StepAction;", "getLastStep", "()Lorg/jetbrains/debugger/StepAction;", "setLastStep", "(Lorg/jetbrains/debugger/StepAction;)V", "processBreakpointConditionsAtIdeSide", "getProcessBreakpointConditionsAtIdeSide", "setProcessBreakpointConditionsAtIdeSide", "realProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "getRealProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "repeatStepInto", "getRepeatStepInto", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "urlToFileCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/Url;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUrlToFileCache", "()Ljava/util/concurrent/ConcurrentMap;", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "addChildVm", "", "beforeInitBreakpoints", "checkCanInitBreakpoints", "checkCanPerformCommands", "continueVm", "Lorg/jetbrains/concurrency/Promise;", "stepAction", "createBreakpointHandlers", "doGetProcessHandler", "doInitBreakpoints", "setBreakpoints", "getBreakpointHandlers", "kotlin.jvm.PlatformType", "getCurrentStateHyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "Lorg/jetbrains/annotations/Nullable;", "getCurrentStateMessage", "", "Lorg/jetbrains/annotations/NotNull;", "getEditorsProvider", "getLocationsForBreakpoint", "", "Lorg/jetbrains/debugger/Location;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getSmartStepIntoHandler", "initBreakpoints", "isLibraryFrameFilterSupported", "isValuesCustomSorted", "isVmStepOutCorrect", "resume", "saveResolvedFile", "url", "file", "setOverlay", "context", "Lorg/jetbrains/debugger/SuspendContext;", "startForceStepInto", "startPausing", "startStepInto", "startStepOut", "startStepOver", "updateLastCallFrame", "script-debugger-ui"})
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess {
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final AtomicBoolean connectedListenerAdded;
    private final AtomicBoolean breakpointsInitiated;
    private final Lazy<XBreakpointHandler<?>[]> _breakpointHandlers$delegate;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    public final StepAction getLastStep() {
        return this.lastStep;
    }

    public final void setLastStep(@Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean isForceStep() {
        return this.isForceStep;
    }

    protected final void setForceStep(boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    public final boolean getProcessBreakpointConditionsAtIdeSide() {
        return this.processBreakpointConditionsAtIdeSide;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(boolean bl) {
        this.processBreakpointConditionsAtIdeSide = bl;
    }

    /*
     * WARNING - void declaration
     */
    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        void $receiver$iv;
        Lazy<XBreakpointHandler<?>[]> lazy = this._breakpointHandlers$delegate;
        DebugProcessImpl debugProcessImpl = this;
        KProperty property$iv = $$delegatedProperties[0];
        return (XBreakpointHandler[])$receiver$iv.getValue();
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        XBreakpointHandler[] xBreakpointHandlerArray;
        switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$1[((VmConnection)this.connection).getState().getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                xBreakpointHandlerArray = XBreakpointHandler.EMPTY_ARRAY;
                break;
            }
            default: {
                xBreakpointHandlerArray = this.get_breakpointHandlers();
            }
        }
        return xBreakpointHandlerArray;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame() {
        Object object = this.getVm();
        this.lastCallFrame = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null ? object.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver() {
        this.updateLastCallFrame();
        this.continueVm(StepAction.OVER);
    }

    public final void startForceStepInto() {
        this.isForceStep = true;
        this.startStepInto();
    }

    public final void startStepInto() {
        this.updateLastCallFrame();
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        this.continueVm(vm.getCaptureAsyncStackTraces() ? StepAction.IN_ASYNC : StepAction.IN);
    }

    public final void startStepOut() {
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame();
        }
        this.continueVm(StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public void resume() {
        this.continueVm(StepAction.CONTINUE);
    }

    @Nullable
    protected Promise<?> continueVm(@NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContextManager<? extends CallFrame> suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return null;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        return suspendContextManager.continueVm(stepAction, 1);
    }

    protected final void setOverlay(@NotNull SuspendContext<?> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (context.getWorkerId() == null) {
            Vm vm = this.getVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
        }
    }

    public final void startPausing() {
        Object t = ((VmConnection)this.connection).getVm();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        t.getSuspendContextManager().suspend().rejected((Consumer)new RejectErrorReporter(this.getSession(), "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    @Nullable
    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@NotNull Url url, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file2);
    }

    @NotNull
    public List<Location> getLocationsForBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        throw (Throwable)new UnsupportedOperationException();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    public boolean checkCanInitBreakpoints() {
        if (Intrinsics.areEqual((Object)((Object)((VmConnection)this.connection).getState().getStatus()), (Object)((Object)ConnectionStatus.CONNECTED))) {
            return this.initBreakpoints(false);
        }
        if (this.connectedListenerAdded.compareAndSet(false, true)) {
            ((VmConnection)this.connection).stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(this){
                final /* synthetic */ DebugProcessImpl this$0;

                public final void invoke(@NotNull ConnectionState it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.CONNECTED))) {
                        this.this$0.initBreakpoints(true);
                    }
                }
                {
                    this.this$0 = debugProcessImpl;
                    super(1);
                }
            }));
        }
        return false;
    }

    protected final boolean initBreakpoints(boolean setBreakpoints) {
        if (this.breakpointsInitiated.compareAndSet(false, true)) {
            this.doInitBreakpoints(setBreakpoints);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitBreakpoints(boolean setBreakpoints) {
        if (setBreakpoints) {
            Vm vm = this.getVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            this.beforeInitBreakpoints(vm);
            AccessToken token$iv = ReadAction.start();
            try {
                this.getSession().initBreakpoints();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                token$iv.finish();
            }
        }
    }

    protected void beforeInitBreakpoints(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addChildVm(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        this.beforeInitBreakpoints(vm);
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)this.getSession().getProject()).getBreakpointManager();
        XBreakpointHandler<?>[] xBreakpointHandlerArray = this.getBreakpointHandlers();
        for (int i = 0; i < xBreakpointHandlerArray.length; ++i) {
            Collection collection;
            XBreakpointHandler<?> breakpointHandler = xBreakpointHandlerArray[i];
            if (!(breakpointHandler instanceof LineBreakpointHandler)) continue;
            AccessToken token$iv = ReadAction.start();
            try {
                collection = breakpointManager.getBreakpoints(((LineBreakpointHandler)breakpointHandler).getBreakpointTypeClass());
            }
            finally {
                token$iv.finish();
            }
            Collection breakpoints = collection;
            for (XLineBreakpoint breakpoint : breakpoints) {
                LineBreakpointManager lineBreakpointManager = ((LineBreakpointHandler)breakpointHandler).getManager$script_debugger_ui();
                XLineBreakpoint xLineBreakpoint = breakpoint;
                Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
                lineBreakpointManager.setBreakpoint(vm, xLineBreakpoint);
            }
        }
    }

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public DebugProcessImpl(@NotNull XDebugSession session, @NotNull C connection, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this.connectedListenerAdded = new AtomicBoolean();
        this.breakpointsInitiated = new AtomicBoolean();
        this._breakpointHandlers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        }));
        ((VmConnection)this.connection).stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(){

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$0[it.getStatus().ordinal()]) {
                    case 1: 
                    case 2: {
                        if (Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.DETACHED)) && this.getRealProcessHandler() != null) {
                            this.getProcessHandler().detachProcess();
                        }
                        this.getSession().stop();
                        break;
                    }
                    case 3: {
                        this.getSession().reportError(it.getMessage());
                        this.getSession().stop();
                        break;
                    }
                    default: {
                        this.getSession().rebuildViews();
                    }
                }
            }
        }));
    }

    public /* synthetic */ DebugProcessImpl(XDebugSession xDebugSession, VmConnection vmConnection, XDebuggerEditorsProvider xDebuggerEditorsProvider, XSmartStepIntoHandler xSmartStepIntoHandler, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            xSmartStepIntoHandler = null;
        }
        if ((n & 0x10) != 0) {
            executionResult = null;
        }
        this(xDebugSession, vmConnection, xDebuggerEditorsProvider, xSmartStepIntoHandler, executionResult);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DebugProcessImpl.class), "_breakpointHandlers", "get_breakpointHandlers()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;"))};
    }
}

