/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc.socket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.nio.channels.ClosedChannelException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;

public class SocketClient
extends Client {
    protected SocketClient(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/jsonRpc/socket/SocketClient", "<init>"));
        }
        super(channel);
    }

    @Override
    @NotNull
    public ChannelFuture send(@NotNull ByteBuf message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/jsonRpc/socket/SocketClient", "send"));
        }
        if (this.channel.isOpen()) {
            ByteBuf lengthBuffer = this.channel.alloc().ioBuffer(4);
            lengthBuffer.writeInt(message.readableBytes());
            this.channel.write((Object)lengthBuffer);
            ChannelFuture channelFuture = this.channel.writeAndFlush((Object)message);
            if (channelFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/socket/SocketClient", "send"));
            }
            return channelFuture;
        }
        ChannelFuture channelFuture = this.channel.newFailedFuture((Throwable)new ClosedChannelException());
        if (channelFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/socket/SocketClient", "send"));
        }
        return channelFuture;
    }

    @Override
    public void sendHeartbeat() {
    }
}

