/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.batik.script.Window;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;

public class WindowWrapper
extends ImporterTopLevel {
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected RhinoInterpreter interpreter;
    protected Window window;

    public WindowWrapper(Context context) {
        super(context);
        String[] stringArray = new String[]{"setInterval", "setTimeout", "clearInterval", "clearTimeout", "parseXML", "getURL", "postURL", "alert", "confirm", "prompt"};
        this.defineFunctionProperties(stringArray, WindowWrapper.class, 2);
    }

    public String getClassName() {
        return "Window";
    }

    public String toString() {
        return "[object Window]";
    }

    public static Object setInterval(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        Window window = windowWrapper.window;
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        long l = (Long)Context.jsToJava((Object)objectArray[1], Long.TYPE);
        if (objectArray[0] instanceof Function) {
            RhinoInterpreter rhinoInterpreter = (RhinoInterpreter)window.getInterpreter();
            FunctionWrapper functionWrapper = new FunctionWrapper(rhinoInterpreter, (Function)objectArray[0], EMPTY_ARGUMENTS);
            return Context.toObject((Object)window.setInterval(functionWrapper, l), (Scriptable)scriptable);
        }
        String string = (String)Context.jsToJava((Object)objectArray[0], String.class);
        return Context.toObject((Object)window.setInterval(string, l), (Scriptable)scriptable);
    }

    public static Object setTimeout(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        Window window = windowWrapper.window;
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        long l = (Long)Context.jsToJava((Object)objectArray[1], Long.TYPE);
        if (objectArray[0] instanceof Function) {
            RhinoInterpreter rhinoInterpreter = (RhinoInterpreter)window.getInterpreter();
            FunctionWrapper functionWrapper = new FunctionWrapper(rhinoInterpreter, (Function)objectArray[0], EMPTY_ARGUMENTS);
            return Context.toObject((Object)window.setTimeout(functionWrapper, l), (Scriptable)scriptable);
        }
        String string = (String)Context.jsToJava((Object)objectArray[0], String.class);
        return Context.toObject((Object)window.setTimeout(string, l), (Scriptable)scriptable);
    }

    public static void clearInterval(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        Window window = windowWrapper.window;
        if (n >= 1) {
            window.clearInterval(Context.jsToJava((Object)objectArray[0], Object.class));
        }
    }

    public static void clearTimeout(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        Window window = windowWrapper.window;
        if (n >= 1) {
            window.clearTimeout(Context.jsToJava((Object)objectArray[0], Object.class));
        }
    }

    public static Object parseXML(Context context, Scriptable scriptable, final Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        final Window window = windowWrapper.window;
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        AccessControlContext accessControlContext = ((RhinoInterpreter)window.getInterpreter()).getAccessControlContext();
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return window.parseXML((String)Context.jsToJava((Object)objectArray[0], String.class), (Document)Context.jsToJava((Object)objectArray[1], Document.class));
            }
        }, accessControlContext);
        return Context.toObject(t, (Scriptable)scriptable);
    }

    public static void getURL(Context context, Scriptable scriptable, final Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        final Window window = windowWrapper.window;
        if (n < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        RhinoInterpreter rhinoInterpreter = (RhinoInterpreter)window.getInterpreter();
        final String string = (String)Context.jsToJava((Object)objectArray[0], String.class);
        Window.URLResponseHandler uRLResponseHandler = null;
        uRLResponseHandler = objectArray[1] instanceof Function ? new GetURLFunctionWrapper(rhinoInterpreter, (Function)objectArray[1], windowWrapper) : new GetURLObjectWrapper(rhinoInterpreter, (ScriptableObject)((NativeObject)objectArray[1]), windowWrapper);
        final Window.URLResponseHandler uRLResponseHandler2 = uRLResponseHandler;
        AccessControlContext accessControlContext = ((RhinoInterpreter)window.getInterpreter()).getAccessControlContext();
        if (n == 2) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    window.getURL(string, uRLResponseHandler2);
                    return null;
                }
            }, accessControlContext);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    window.getURL(string, uRLResponseHandler2, (String)Context.jsToJava((Object)objectArray[2], String.class));
                    return null;
                }
            }, accessControlContext);
        }
    }

    public static void postURL(Context context, Scriptable scriptable, final Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        final Window window = windowWrapper.window;
        if (n < 3) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        RhinoInterpreter rhinoInterpreter = (RhinoInterpreter)window.getInterpreter();
        final String string = (String)Context.jsToJava((Object)objectArray[0], String.class);
        final String string2 = (String)Context.jsToJava((Object)objectArray[1], String.class);
        Window.URLResponseHandler uRLResponseHandler = null;
        uRLResponseHandler = objectArray[2] instanceof Function ? new GetURLFunctionWrapper(rhinoInterpreter, (Function)objectArray[2], windowWrapper) : new GetURLObjectWrapper(rhinoInterpreter, (ScriptableObject)((NativeObject)objectArray[2]), windowWrapper);
        final Window.URLResponseHandler uRLResponseHandler2 = uRLResponseHandler;
        AccessControlContext accessControlContext = rhinoInterpreter.getAccessControlContext();
        switch (n) {
            case 3: {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        window.postURL(string, string2, uRLResponseHandler2);
                        return null;
                    }
                }, accessControlContext);
                break;
            }
            case 4: {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        window.postURL(string, string2, uRLResponseHandler2, (String)Context.jsToJava((Object)objectArray[3], String.class));
                        return null;
                    }
                }, accessControlContext);
                break;
            }
            default: {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        window.postURL(string, string2, uRLResponseHandler2, (String)Context.jsToJava((Object)objectArray[3], String.class), (String)Context.jsToJava((Object)objectArray[4], String.class));
                        return null;
                    }
                }, accessControlContext);
            }
        }
    }

    public static void alert(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        Window window = windowWrapper.window;
        if (n >= 1) {
            String string = (String)Context.jsToJava((Object)objectArray[0], String.class);
            window.alert(string);
        }
    }

    public static Object confirm(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = objectArray.length;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        Window window = windowWrapper.window;
        if (n >= 1) {
            String string = (String)Context.jsToJava((Object)objectArray[0], String.class);
            if (window.confirm(string)) {
                return Context.toObject((Object)Boolean.TRUE, (Scriptable)scriptable);
            }
            return Context.toObject((Object)Boolean.FALSE, (Scriptable)scriptable);
        }
        return Context.toObject((Object)Boolean.FALSE, (Scriptable)scriptable);
    }

    public static Object prompt(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string;
        WindowWrapper windowWrapper = (WindowWrapper)scriptable;
        Window window = windowWrapper.window;
        switch (objectArray.length) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                String string2 = (String)Context.jsToJava((Object)objectArray[0], String.class);
                string = window.prompt(string2);
                break;
            }
            default: {
                String string3 = (String)Context.jsToJava((Object)objectArray[0], String.class);
                String string4 = (String)Context.jsToJava((Object)objectArray[1], String.class);
                string = window.prompt(string3, string4);
            }
        }
        if (string == null) {
            return null;
        }
        return Context.toObject((Object)string, (Scriptable)scriptable);
    }

    static class GetURLDoneArgBuilder
    implements RhinoInterpreter.ArgumentsBuilder {
        boolean success;
        String mime;
        String content;
        WindowWrapper windowWrapper;

        public GetURLDoneArgBuilder(boolean bl, String string, String string2, WindowWrapper windowWrapper) {
            this.success = bl;
            this.mime = string;
            this.content = string2;
            this.windowWrapper = windowWrapper;
        }

        @Override
        public Object[] buildArguments() {
            NativeObject nativeObject = new NativeObject();
            nativeObject.put("success", (Scriptable)nativeObject, (Object)(this.success ? Boolean.TRUE : Boolean.FALSE));
            if (this.mime != null) {
                nativeObject.put("contentType", (Scriptable)nativeObject, (Object)Context.toObject((Object)this.mime, (Scriptable)this.windowWrapper));
            }
            if (this.content != null) {
                nativeObject.put("content", (Scriptable)nativeObject, (Object)Context.toObject((Object)this.content, (Scriptable)this.windowWrapper));
            }
            return new Object[]{nativeObject};
        }
    }

    private static class GetURLObjectWrapper
    implements Window.URLResponseHandler {
        private RhinoInterpreter interpreter;
        private ScriptableObject object;
        private WindowWrapper windowWrapper;
        private static final String COMPLETE = "operationComplete";

        public GetURLObjectWrapper(RhinoInterpreter rhinoInterpreter, ScriptableObject scriptableObject, WindowWrapper windowWrapper) {
            this.interpreter = rhinoInterpreter;
            this.object = scriptableObject;
            this.windowWrapper = windowWrapper;
        }

        @Override
        public void getURLDone(boolean bl, String string, String string2) {
            this.interpreter.callMethod(this.object, COMPLETE, new GetURLDoneArgBuilder(bl, string, string2, this.windowWrapper));
        }
    }

    protected static class GetURLFunctionWrapper
    implements Window.URLResponseHandler {
        protected RhinoInterpreter interpreter;
        protected Function function;
        protected WindowWrapper windowWrapper;

        public GetURLFunctionWrapper(RhinoInterpreter rhinoInterpreter, Function function, WindowWrapper windowWrapper) {
            this.interpreter = rhinoInterpreter;
            this.function = function;
            this.windowWrapper = windowWrapper;
        }

        @Override
        public void getURLDone(boolean bl, String string, String string2) {
            this.interpreter.callHandler(this.function, new GetURLDoneArgBuilder(bl, string, string2, this.windowWrapper));
        }
    }

    protected static class FunctionWrapper
    implements Runnable {
        protected RhinoInterpreter interpreter;
        protected Function function;
        protected Object[] arguments;

        public FunctionWrapper(RhinoInterpreter rhinoInterpreter, Function function, Object[] objectArray) {
            this.interpreter = rhinoInterpreter;
            this.function = function;
            this.arguments = objectArray;
        }

        @Override
        public void run() {
            this.interpreter.callHandler(this.function, this.arguments);
        }
    }
}

