/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.transfer;

import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.transfer.MetadataTransferException;

public class MetadataNotFoundException
extends MetadataTransferException {
    public MetadataNotFoundException(Metadata metadata, LocalRepository repository) {
        super(metadata, null, "Could not find metadata " + metadata + MetadataNotFoundException.getString(" in ", repository));
    }

    private static String getString(String prefix, LocalRepository repository) {
        if (repository == null) {
            return "";
        }
        return prefix + repository.getId() + " (" + repository.getBasedir() + ")";
    }

    public MetadataNotFoundException(Metadata metadata, RemoteRepository repository) {
        super(metadata, repository, "Could not find metadata " + metadata + MetadataNotFoundException.getString(" in ", repository));
    }

    public MetadataNotFoundException(Metadata metadata, RemoteRepository repository, String message) {
        super(metadata, repository, message);
    }
}

