/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class OnOffButton
extends JToggleButton {
    private String myOnText;
    private String myOffText;

    public OnOffButton() {
        this.setUI(OnOffButtonUI.createUI(this));
        this.setOpaque(false);
        this.setBorder(null);
    }

    public String getOnText() {
        return this.myOnText == null ? "ON" : this.myOnText;
    }

    public void setOnText(String onText) {
        this.myOnText = onText;
    }

    public String getOffText() {
        return this.myOffText == null ? "OFF" : this.myOffText;
    }

    public void setOffText(String offText) {
        this.myOffText = offText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public static class OnOffButtonUI
    extends BasicToggleButtonUI {
        private final OnOffButton myButton;

        public OnOffButtonUI(OnOffButton checkBox) {
            this.myButton = checkBox;
        }

        public static ComponentUI createUI(JComponent c) {
            c.setOpaque(false);
            c.setAlignmentY(0.5f);
            return new OnOffButtonUI((OnOffButton)c);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            OnOffButton button = (OnOffButton)c;
            String text = button.getOffText().length() > button.getOnText().length() ? button.getOffText() : button.getOnText();
            text = text.toUpperCase();
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int w = fm.stringWidth(text);
            int h = fm.getHeight();
            return new Dimension(w += 3 * (h += 8) / 2, h);
        }

        @Override
        public void paint(Graphics gr, JComponent c) {
            OnOffButton button = (OnOffButton)c;
            Dimension size = button.getSize();
            int w = size.width - 8;
            int h = size.height - 6;
            if (h % 2 == 1) {
                --h;
            }
            Graphics2D g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int xOff = (this.myButton.getWidth() - w) / 2;
            int yOff = (this.myButton.getHeight() - h) / 2;
            g.translate(xOff, yOff);
            if (button.isSelected()) {
                g.setColor((Color)new JBColor(new Color(74, 146, 73), new Color(77, 105, 76)));
                g.fillRoundRect(0, 0, w, h, 5, 5);
                g.setColor((Color)new JBColor((Color)Gray._192, (Color)Gray._80));
                g.drawRoundRect(0, 0, w, h, 5, 5);
                g.setColor((Color)new JBColor((Color)Gray._200, (Color)Gray._100));
                g.fillRoundRect(w - h, 1, h, h - 1, 3, 3);
                g.setColor(UIUtil.getListForeground((boolean)true));
                g.drawString(button.getOnText(), h / 2, h - 4);
            } else {
                g.setColor(UIUtil.getPanelBackground());
                g.fillRoundRect(0, 0, w, h, 5, 5);
                g.setColor((Color)new JBColor((Color)Gray._192, (Color)Gray._100));
                g.drawRoundRect(0, 0, w, h, 5, 5);
                g.setColor(UIUtil.getLabelDisabledForeground());
                g.drawString(button.getOffText(), h + 4, h - 4);
                g.setColor(UIUtil.getBorderColor());
                g.setPaint(new GradientPaint(h, 0.0f, (Color)new JBColor((Color)Gray._158, (Color)Gray._100), 0.0f, h, (Color)new JBColor((Color)Gray._210, (Color)Gray._100)));
                g.fillRoundRect(0, 0, h, h, 3, 3);
            }
            g.translate(-xOff, -yOff);
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }
    }
}

