/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.nio.charset.Charset;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalker;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.resource.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryWalkerFactory
implements Factory<DirectoryWalker> {
    private final ClassLoader classLoader;
    private final JavaVersion javaVersion;
    private DirectoryWalker instance;

    DefaultDirectoryWalkerFactory(ClassLoader classLoader, JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
        this.classLoader = classLoader;
        this.reset();
    }

    DefaultDirectoryWalkerFactory() {
        this(DefaultDirectoryWalkerFactory.class.getClassLoader(), JavaVersion.current());
    }

    public DirectoryWalker create() {
        return this.instance;
    }

    private void reset() {
        this.instance = this.createInstance();
    }

    private DirectoryWalker createInstance() {
        if (this.javaVersion.isJava8Compatible() || this.javaVersion.isJava7Compatible() && this.defaultEncodingContainsPlatformEncoding()) {
            try {
                Class<?> clazz = this.classLoader.loadClass("org.gradle.api.internal.file.collections.jdk7.Jdk7DirectoryWalker");
                return (DirectoryWalker)Cast.uncheckedCast((Object)DirectInstantiator.instantiate(clazz, (Object[])new Object[0]));
            }
            catch (ClassNotFoundException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return new DefaultDirectoryWalker();
    }

    private boolean defaultEncodingContainsPlatformEncoding() {
        String platformEncoding = System.getProperty("sun.jnu.encoding");
        Charset platformCharset = platformEncoding != null && Charset.isSupported(platformEncoding) ? Charset.forName(platformEncoding) : null;
        Charset requiredCharset = platformCharset != null ? platformCharset : CharsetUtil.UTF_8;
        return Charset.defaultCharset().contains(requiredCharset);
    }
}

