/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

class SoftKeywordsHighlightingVisitor
extends KtVisitorVoid {
    private final AnnotationHolder holder;

    SoftKeywordsHighlightingVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public void visitElement(PsiElement element2) {
        if (element2 instanceof LeafPsiElement) {
            IElementType elementType = ((LeafPsiElement)element2).getElementType();
            if (KtTokens.SOFT_KEYWORDS.contains(elementType)) {
                TextAttributesKey attributes = KotlinHighlightingColors.KEYWORD;
                if (KtTokens.MODIFIER_KEYWORDS.contains(elementType)) {
                    attributes = KotlinHighlightingColors.BUILTIN_ANNOTATION;
                }
                this.holder.createInfoAnnotation(element2, null).setTextAttributes(attributes);
            }
            if (((Object)((Object)KtTokens.SAFE_ACCESS)).equals(elementType)) {
                this.holder.createInfoAnnotation(element2, null).setTextAttributes(KotlinHighlightingColors.SAFE_ACCESS);
            }
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        PsiElement arrow;
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "org/jetbrains/kotlin/idea/highlighter/SoftKeywordsHighlightingVisitor", "visitLambdaExpression"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        KtFunctionLiteral functionLiteral = lambdaExpression.getFunctionLiteral();
        this.holder.createInfoAnnotation(functionLiteral.getLBrace(), null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            this.holder.createInfoAnnotation(closingBrace, null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
        if ((arrow = functionLiteral.getArrow()) != null) {
            this.holder.createInfoAnnotation(arrow, null).setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_BRACES_AND_ARROW);
        }
    }
}

