/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tJ.\u0010\u0015\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/validation/DeprecatedSymbolValidator;", "Lorg/jetbrains/kotlin/resolve/validation/SymbolUsageValidator;", "()V", "PROPERTY_SET_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "deprecation", "Lorg/jetbrains/kotlin/resolve/Deprecation;", "propertyGetterWorkaround", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "validateCall", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "validateTypeUsage", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "kotlin-compiler"})
public final class DeprecatedSymbolValidator
implements SymbolUsageValidator {
    private final TokenSet PROPERTY_SET_OPERATIONS = TokenSet.create(KtTokens.EQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PERCEQ, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS);

    @Override
    public void validateCall(@Nullable ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        Deprecation deprecation = DeprecationUtilKt.getDeprecation(targetDescriptor);
        if (targetDescriptor instanceof PropertySetterDescriptor && Intrinsics.areEqual(DeprecationUtilKt.getDeprecation(((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty()), deprecation)) {
            return;
        }
        if (deprecation != null) {
            trace.report(this.createDeprecationDiagnostic(element, deprecation));
        } else if (targetDescriptor instanceof PropertyDescriptor) {
            this.propertyGetterWorkaround(resolvedCall2, (PropertyDescriptor)targetDescriptor, trace, element);
        }
    }

    @Override
    public void validateTypeUsage(@NotNull ClassifierDescriptor targetDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement element) {
        KtSuperTypeCallEntry superExpression;
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        KtAnnotationEntry annotationEntry = KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotationEntry.class, true);
        if (annotationEntry != null) {
            KtConstructorCalleeExpression ktConstructorCalleeExpression = annotationEntry.getCalleeExpression();
            if (ktConstructorCalleeExpression == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual(ktConstructorCalleeExpression.getConstructorReferenceExpression(), element)) {
                return;
            }
        }
        if ((superExpression = KtStubbedPsiUtil.getPsiOrStubParent(element, KtSuperTypeCallEntry.class, true)) != null && Intrinsics.areEqual(superExpression.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        Deprecation deprecation = DeprecationUtilKt.getDeprecation(targetDescriptor);
        if (deprecation != null) {
            trace.report(this.createDeprecationDiagnostic(element, deprecation));
        }
    }

    private final Diagnostic createDeprecationDiagnostic(PsiElement element, Deprecation deprecation) {
        DeclarationDescriptor targetOriginal = deprecation.getTarget().getOriginal();
        if (Intrinsics.areEqual((Object)deprecation.getDeprecationLevel(), (Object)DeprecationLevelValue.ERROR)) {
            Diagnostic diagnostic = Errors.DEPRECATION_ERROR.on(element, targetOriginal, deprecation.getMessage());
            Intrinsics.checkExpressionValueIsNotNull(diagnostic, "Errors.DEPRECATION_ERROR\u2026nal, deprecation.message)");
            return diagnostic;
        }
        Diagnostic diagnostic = Errors.DEPRECATION.on(element, targetOriginal, deprecation.getMessage());
        Intrinsics.checkExpressionValueIsNotNull(diagnostic, "Errors.DEPRECATION.on(el\u2026nal, deprecation.message)");
        return diagnostic;
    }

    /*
     * WARNING - void declaration
     */
    public final void propertyGetterWorkaround(@Nullable ResolvedCall<?> resolvedCall2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull BindingTrace trace, @NotNull PsiElement expression) {
        Unit unit;
        KtUnaryExpression unaryExpression;
        Object expr;
        IElementType operation;
        Intrinsics.checkParameterIsNotNull(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        KtBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression) && (operation = binaryExpression.getOperationToken()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
                return;
            }
            KtReferenceExpression[] jetReferenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, KtReferenceExpression.class);
            if (jetReferenceExpressions != null) {
                for (int i = 0; i < jetReferenceExpressions.length; ++i) {
                    IElementType operation2;
                    expr = jetReferenceExpressions[i];
                    if (!Intrinsics.areEqual(expr, expression) || (operation2 = binaryExpression.getOperationToken()) == null || !this.PROPERTY_SET_OPERATIONS.contains(operation2)) continue;
                    return;
                }
            }
        }
        if ((unaryExpression = PsiTreeUtil.getParentOfType(expression, KtUnaryExpression.class)) != null && (operation = unaryExpression.getOperationReference().getReferencedNameElementType()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
            return;
        }
        KtCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, KtCallableReferenceExpression.class);
        if (callableExpression != null && Intrinsics.areEqual(callableExpression.getCallableReference(), expression)) {
            return;
        }
        PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
        if (propertyGetterDescriptor != null) {
            void $receiver$iv;
            expr = propertyGetterDescriptor;
            PropertyGetterDescriptor it = (PropertyGetterDescriptor)$receiver$iv;
            CallableDescriptor callableDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "it");
            this.validateCall(resolvedCall2, callableDescriptor, trace, expression);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }
}

