/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.util.XmlUtil;
import com.intellij.xml.util.documentation.XmlDocumentationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.dom.attrs.StyleableDefinitionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeDefinitionsImpl
implements AttributeDefinitions {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl");
    private static final int ATTR_GROUP_MAX_CHARACTERS = 40;
    private Map<String, AttributeDefinition> myAttrs;
    private Map<String, StyleableDefinitionImpl> myStyleables;
    private final List<StyleableDefinition> myStateStyleables;
    private final Map<String, Map<String, Integer>> myEnumMap;

    public AttributeDefinitionsImpl(XmlFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl", "<init>"));
        }
        this.myAttrs = new HashMap();
        this.myStyleables = new HashMap();
        this.myStateStyleables = new ArrayList<StyleableDefinition>();
        this.myEnumMap = new HashMap();
        for (XmlFile file : files) {
            this.addAttrsFromFile(file);
        }
    }

    private void addAttrsFromFile(XmlFile file) {
        HashMap parentMap = new HashMap();
        XmlDocument document = file.getDocument();
        if (document == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null || !"resources".equals(rootTag.getName())) {
            return;
        }
        String attrGroup = null;
        for (XmlTag tag : rootTag.getSubTags()) {
            String newAttrGroup;
            Object def;
            String tagName = tag.getName();
            if ("attr".equals(tagName)) {
                def = this.parseAttrTag(tag, null);
                if (def == null) continue;
                ((AttributeDefinition)def).setAttrGroup(attrGroup);
                continue;
            }
            if ("declare-styleable".equals(tagName)) {
                def = this.parseDeclareStyleableTag(tag, (Map<StyleableDefinitionImpl, String[]>)parentMap);
                if (def == null || !((StyleableDefinitionImpl)def).getName().equals("Theme")) continue;
                this.parseAndAddAttrGroups(tag);
                continue;
            }
            if (!"eat-comment".equals(tagName) || (newAttrGroup = AttributeDefinitionsImpl.getCommentBeforeEatComment(tag)) == null || newAttrGroup.length() > 40) continue;
            attrGroup = newAttrGroup;
        }
        for (Map.Entry entry : parentMap.entrySet()) {
            String[] parentNames;
            StyleableDefinitionImpl definition = (StyleableDefinitionImpl)entry.getKey();
            for (String parentName : parentNames = (String[])entry.getValue()) {
                StyleableDefinitionImpl parent = this.getStyleableByName(parentName);
                if (parent != null) {
                    definition.addParent(parent);
                    parent.addChild(definition);
                    continue;
                }
                LOG.info("Found tag with unknown parent: " + parentName);
            }
        }
    }

    @Nullable
    private AttributeDefinition parseAttrTag(XmlTag tag, @Nullable String parentStyleable) {
        XmlTag[] values;
        List<AttributeFormat> parsedFormats;
        String name = tag.getAttributeValue("name");
        if (name == null) {
            LOG.info("Found attr tag with no name: " + tag.getText());
            return null;
        }
        ArrayList<AttributeFormat> formats = new ArrayList<AttributeFormat>();
        String format = tag.getAttributeValue("format");
        if (format != null && (parsedFormats = AttributeDefinitionsImpl.parseAttrFormat(format)) != null) {
            formats.addAll(parsedFormats);
        }
        if ((values = tag.findSubTags("enum")).length > 0) {
            formats.add(AttributeFormat.Enum);
        } else {
            values = tag.findSubTags("flag");
            if (values.length > 0) {
                formats.add(AttributeFormat.Flag);
            }
        }
        AttributeDefinition def = this.myAttrs.get(name);
        if (def == null) {
            def = new AttributeDefinition(name, parentStyleable, Collections.emptySet());
            this.myAttrs.put(def.getName(), def);
        }
        def.addFormats(formats);
        AttributeDefinitionsImpl.parseDocComment(tag, def, parentStyleable);
        this.parseAndAddValues(def, values);
        return def;
    }

    private static void parseDocComment(XmlTag tag, AttributeDefinition def, @Nullable String styleable) {
        String docValue;
        PsiElement comment = XmlDocumentationProvider.findPreviousComment((PsiElement)tag);
        if (comment != null && (docValue = XmlUtil.getCommentText((XmlComment)((XmlComment)comment))) != null && !StringUtil.isEmpty((String)docValue)) {
            def.addDocValue(docValue, styleable);
        }
    }

    @Nullable
    private static String getCommentBeforeEatComment(XmlTag tag) {
        PsiElement comment = XmlDocumentationProvider.findPreviousComment((PsiElement)tag);
        for (int i = 0; i < 5 && comment != null; ++i) {
            String value = StringUtil.trim((String)XmlUtil.getCommentText((XmlComment)((XmlComment)comment)));
            if (!StringUtil.isEmpty((String)value) && value.charAt(0) != '*' && value.charAt(0) != '=') {
                return value;
            }
            comment = XmlDocumentationProvider.findPreviousComment((PsiElement)comment.getPrevSibling());
        }
        return null;
    }

    @Nullable
    private static List<AttributeFormat> parseAttrFormat(String formatString) {
        String[] formats;
        ArrayList<AttributeFormat> result = new ArrayList<AttributeFormat>();
        for (String format : formats = formatString.split("\\|")) {
            AttributeFormat attributeFormat;
            try {
                attributeFormat = AttributeFormat.valueOf(StringUtil.capitalize((String)format));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            result.add(attributeFormat);
        }
        return result;
    }

    private void parseAndAddValues(AttributeDefinition def, XmlTag[] values) {
        for (XmlTag value : values) {
            String strIntValue;
            String docValue;
            String valueName = value.getAttributeValue("name");
            if (valueName == null) {
                LOG.info("Unknown value for tag: " + value.getText());
                continue;
            }
            def.addValue(valueName);
            PsiElement comment = XmlDocumentationProvider.findPreviousComment((PsiElement)value);
            if (comment != null && !StringUtil.isEmpty((String)(docValue = XmlUtil.getCommentText((XmlComment)((XmlComment)comment))))) {
                def.addValueDoc(valueName, docValue);
            }
            if ((strIntValue = value.getAttributeValue("value")) == null) continue;
            try {
                int intValue = (int)Long.decode(strIntValue).longValue();
                HashMap value2Int = this.myEnumMap.get(def.getName());
                if (value2Int == null) {
                    value2Int = new HashMap();
                    this.myEnumMap.put(def.getName(), (Map<String, Integer>)value2Int);
                }
                value2Int.put(valueName, intValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private StyleableDefinitionImpl parseDeclareStyleableTag(XmlTag tag, Map<StyleableDefinitionImpl, String[]> parentMap) {
        String name = tag.getAttributeValue("name");
        if (name == null) {
            LOG.info("Found declare-styleable tag with no name: " + tag.getText());
            return null;
        }
        StyleableDefinitionImpl def = new StyleableDefinitionImpl(name);
        String parentNameAttributeValue = tag.getAttributeValue("parent");
        if (parentNameAttributeValue != null) {
            String[] parentNames = parentNameAttributeValue.split("\\s+");
            parentMap.put(def, parentNames);
        }
        this.myStyleables.put(name, def);
        if (name.endsWith("State")) {
            this.myStateStyleables.add(def);
        }
        for (XmlTag subTag : tag.findSubTags("attr")) {
            this.parseStyleableAttr(def, subTag);
        }
        return def;
    }

    private void parseStyleableAttr(StyleableDefinitionImpl def, XmlTag tag) {
        String name = tag.getAttributeValue("name");
        if (name == null) {
            LOG.info("Found attr tag with no name: " + tag.getText());
            return;
        }
        AttributeDefinition attr = this.parseAttrTag(tag, def.getName());
        if (attr != null) {
            def.addAttribute(attr);
        }
    }

    private void parseAndAddAttrGroups(XmlTag tag) {
        String attrGroup = null;
        for (XmlTag subTag : tag.getSubTags()) {
            String newAttrGroup;
            String subTagName = subTag.getName();
            if ("attr".equals(subTagName)) {
                AttributeDefinition def = this.myAttrs.get(subTag.getAttributeValue("name"));
                if (def == null) continue;
                def.setAttrGroup(attrGroup);
                continue;
            }
            if (!"eat-comment".equals(subTagName) || (newAttrGroup = AttributeDefinitionsImpl.getCommentBeforeEatComment(subTag)) == null || newAttrGroup.length() > 40) continue;
            attrGroup = newAttrGroup;
        }
    }

    @Override
    @Nullable
    public StyleableDefinitionImpl getStyleableByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl", "getStyleableByName"));
        }
        return this.myStyleables.get(name);
    }

    @Override
    @NotNull
    public Set<String> getAttributeNames() {
        Set<String> set = this.myAttrs.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl", "getAttributeNames"));
        }
        return set;
    }

    @Override
    @Nullable
    public AttributeDefinition getAttrDefByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl", "getAttrDefByName"));
        }
        return this.myAttrs.get(name);
    }

    @Override
    @Nullable
    public String getAttrGroupByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl", "getAttrGroupByName"));
        }
        if (this.myAttrs.get(name) == null) {
            return null;
        }
        return this.myAttrs.get(name).getAttrGroup();
    }

    @Override
    @NotNull
    public StyleableDefinition[] getStateStyleables() {
        StyleableDefinition[] styleableDefinitionArray = this.myStateStyleables.toArray(new StyleableDefinition[this.myStateStyleables.size()]);
        if (styleableDefinitionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl", "getStateStyleables"));
        }
        return styleableDefinitionArray;
    }

    @NotNull
    public Map<String, Map<String, Integer>> getEnumMap() {
        Map<String, Map<String, Integer>> map = this.myEnumMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/attrs/AttributeDefinitionsImpl", "getEnumMap"));
        }
        return map;
    }
}

