/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;

public class XsltIncludeIndex {
    private XsltIncludeIndex() {
    }

    public static boolean isReachableFrom(XmlFile which, XmlFile from) {
        return from == which || XsltIncludeIndex._isReachableFrom(from.getVirtualFile(), FileIncludeManager.getManager((Project)which.getProject()).getIncludingFiles(which.getVirtualFile(), true));
    }

    private static boolean _isReachableFrom(VirtualFile from, VirtualFile[] which) {
        for (int i = 0; i < which.length; ++i) {
            VirtualFile file = which[i];
            if (!Comparing.equal((Object)file, (Object)from)) continue;
            return true;
        }
        return false;
    }

    public static boolean processForwardDependencies(@NotNull XmlFile file, Processor<XmlFile> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/xslt/impl/XsltIncludeIndex", "processForwardDependencies"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        Project project = file.getProject();
        VirtualFile[] files = FileIncludeManager.getManager((Project)project).getIncludedFiles(virtualFile, true);
        return XsltIncludeIndex._process(files, project, processor);
    }

    public static boolean processBackwardDependencies(@NotNull XmlFile file, Processor<XmlFile> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/xslt/impl/XsltIncludeIndex", "processBackwardDependencies"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        Project project = file.getProject();
        VirtualFile[] files = FileIncludeManager.getManager((Project)project).getIncludingFiles(virtualFile, true);
        return XsltIncludeIndex._process(files, project, processor);
    }

    private static boolean _process(VirtualFile[] files, Project project, Processor<XmlFile> processor) {
        PsiFile[] psiFiles;
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (PsiFile psiFile : psiFiles = (PsiFile[])ContainerUtil.map2Array((Object[])files, PsiFile.class, (Function)new NullableFunction<VirtualFile, PsiFile>(){

            public PsiFile fun(VirtualFile file) {
                return psiManager.findFile(file);
            }
        })) {
            if (!XsltSupport.isXsltFile(psiFile) || processor.process((Object)((XmlFile)psiFile))) continue;
            return false;
        }
        return true;
    }
}

