/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogCatMessageParser {
    private static final Pattern sLogHeaderPattern = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):\\s*(\\S+)\\s([VDIWEAF])/(.*[^\\s])\\s+\\]$");
    LogCatHeader mPrevHeader;

    public LogCatHeader processLogHeader(String line, IDevice device) {
        Log.LogLevel logLevel;
        Matcher matcher = sLogHeaderPattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(matcher.group(2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int tid = -1;
        try {
            tid = Integer.decode(matcher.group(3));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String pkgName = null;
        if (device != null && pid != -1) {
            pkgName = device.getClientName(pid);
        }
        if (pkgName == null || pkgName.isEmpty()) {
            pkgName = "?";
        }
        if ((logLevel = Log.LogLevel.getByLetterString(matcher.group(4))) == null && matcher.group(4).equals("F")) {
            logLevel = Log.LogLevel.ASSERT;
        }
        if (logLevel == null) {
            logLevel = Log.LogLevel.WARN;
        }
        this.mPrevHeader = new LogCatHeader(logLevel, pid, tid, pkgName, matcher.group(5), LogCatTimestamp.fromString(matcher.group(1)));
        return this.mPrevHeader;
    }

    public List<LogCatMessage> processLogLines(String[] lines, IDevice device) {
        ArrayList<LogCatMessage> messages = new ArrayList<LogCatMessage>(lines.length);
        for (String line : lines) {
            if (line.isEmpty() || this.processLogHeader(line, device) != null) continue;
            if (this.mPrevHeader == null) {
                throw new IllegalStateException("No logcat header processed yet, failed to parse line: " + line);
            }
            messages.add(new LogCatMessage(this.mPrevHeader, line));
        }
        return messages;
    }
}

