/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.element;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.filters.ClassFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModifierFilter
extends ClassFilter {
    public final List<ModifierRestriction> myModifierRestrictions = new ArrayList<ModifierRestriction>();

    private ModifierFilter() {
        super(PsiModifierListOwner.class);
    }

    public ModifierFilter(@PsiModifier.ModifierConstant String modifier, boolean hasToBe) {
        this();
        this.addModiferRestriction(modifier, hasToBe);
    }

    public ModifierFilter(String ... modifiers) {
        this();
        for (String modifier : modifiers) {
            this.addModiferRestriction(modifier, true);
        }
    }

    private void addModiferRestriction(@PsiModifier.ModifierConstant String mod, boolean hasToBe) {
        this.myModifierRestrictions.add(new ModifierRestriction(mod, hasToBe));
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        if (element instanceof PsiModifierListOwner) {
            PsiModifierList list2 = ((PsiModifierListOwner)element).getModifierList();
            if (list2 == null) {
                return true;
            }
            Iterator<ModifierRestriction> iterator2 = this.myModifierRestrictions.iterator();
            while (iterator2.hasNext()) {
                ModifierRestriction myModifierRestriction;
                ModifierRestriction psiModifer = myModifierRestriction = iterator2.next();
                boolean shouldHave = psiModifer.myIsSet;
                if (shouldHave == list2.hasModifierProperty(psiModifer.myModifierName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        String ret = "modifiers(";
        Iterator<ModifierRestriction> iter = this.myModifierRestrictions.iterator();
        while (iter.hasNext()) {
            ModifierRestriction rest = iter.next();
            ret = ret + rest.myModifierName + "=" + rest.myIsSet;
            if (!iter.hasNext()) continue;
            ret = ret + ", ";
        }
        ret = ret + ")";
        return ret;
    }

    protected static final class ModifierRestriction {
        @PsiModifier.ModifierConstant
        public final String myModifierName;
        public final boolean myIsSet;

        ModifierRestriction(@PsiModifier.ModifierConstant String modifierName, boolean isSet) {
            this.myModifierName = modifierName;
            this.myIsSet = isSet;
        }
    }
}

