/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectScope;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsScopesKt;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import com.google.dart.compiler.backend.js.ast.metadata.TypeCheck;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.ManglingUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class Namer {
    public static final String KOTLIN_NAME = "Kotlin";
    public static final String KOTLIN_LOWER_NAME = "Kotlin".toLowerCase();
    public static final JsNameRef KOTLIN_OBJECT_REF = new JsNameRef("Kotlin");
    public static final JsNameRef KOTLIN_LONG_NAME_REF = new JsNameRef("Long", (JsExpression)KOTLIN_OBJECT_REF);
    public static final String EQUALS_METHOD_NAME = ManglingUtils.getStableMangledNameForDescriptor(JsPlatform.INSTANCE.getBuiltIns().getAny(), "equals");
    public static final String COMPARE_TO_METHOD_NAME = ManglingUtils.getStableMangledNameForDescriptor(JsPlatform.INSTANCE.getBuiltIns().getComparable(), "compareTo");
    public static final String NUMBER_RANGE = "NumberRange";
    public static final String CHAR_RANGE = "CharRange";
    public static final String LONG_FROM_NUMBER = "fromNumber";
    public static final String LONG_TO_NUMBER = "toNumber";
    public static final String LONG_FROM_INT = "fromInt";
    public static final String LONG_ZERO = "ZERO";
    public static final String LONG_ONE = "ONE";
    public static final String LONG_NEG_ONE = "NEG_ONE";
    public static final String PRIMITIVE_COMPARE_TO = "primitiveCompareTo";
    public static final String IS_CHAR = "isChar";
    public static final String IS_NUMBER = "isNumber";
    public static final String CALLEE_NAME = "$fun";
    public static final String CALL_FUNCTION = "call";
    public static final String ANOTHER_THIS_PARAMETER_NAME = "$this";
    public static final String CAPTURED_VAR_FIELD = "v";
    public static final JsNameRef CREATE_INLINE_FUNCTION = new JsNameRef("defineInlineFunction", (JsExpression)KOTLIN_OBJECT_REF);
    @NotNull
    public static final JsExpression UNDEFINED_EXPRESSION = new JsPrefixOperation(JsUnaryOperator.VOID, JsNumberLiteral.ZERO);
    private static final JsNameRef JS_OBJECT = new JsNameRef("Object");
    private static final JsNameRef JS_OBJECT_CREATE_FUNCTION = new JsNameRef("create", (JsExpression)JS_OBJECT);
    @NotNull
    private final JsName kotlinName;
    @NotNull
    private final JsObjectScope kotlinScope;
    @NotNull
    private final JsName className;
    @NotNull
    private final JsName enumClassName;
    @NotNull
    private final JsName traitName;
    @NotNull
    private final JsExpression definePackage;
    @NotNull
    private final JsExpression defineRootPackage;
    @NotNull
    private final JsName objectName;
    @NotNull
    private final JsName callableRefForMemberFunctionName;
    @NotNull
    private final JsName callableRefForExtensionFunctionName;
    @NotNull
    private final JsName callableRefForLocalExtensionFunctionName;
    @NotNull
    private final JsName callableRefForConstructorName;
    @NotNull
    private final JsName callableRefForTopLevelProperty;
    @NotNull
    private final JsName callableRefForMemberProperty;
    @NotNull
    private final JsName callableRefForExtensionProperty;
    @NotNull
    private final JsExpression callGetProperty;
    @NotNull
    private final JsExpression callSetProperty;
    @NotNull
    private final JsName isTypeName;
    @NotNull
    private final JsExpression modulesMap;

    public static boolean isUndefined(@NotNull JsExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/kotlin/js/translate/context/Namer", "isUndefined"));
        }
        if (expr instanceof JsPrefixOperation) {
            JsUnaryOperator op = ((JsPrefixOperation)expr).getOperator();
            return op == JsUnaryOperator.VOID;
        }
        return false;
    }

    @NotNull
    public static String getFunctionTag(@NotNull CallableDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionTag"));
        }
        String moduleName = JsDescriptorUtils.getModuleName(functionDescriptor);
        FqNameUnsafe fqNameParent = DescriptorUtils.getFqName(functionDescriptor).parent();
        String qualifier2 = null;
        if (!fqNameParent.isRoot()) {
            qualifier2 = fqNameParent.asString();
        }
        String mangledName = ManglingUtils.getSuggestedName((DeclarationDescriptor)functionDescriptor);
        String string = StringUtil.join(Arrays.asList(moduleName, qualifier2, mangledName), ".");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionTag"));
        }
        return string;
    }

    @NotNull
    public static String getReceiverParameterName() {
        if ("$receiver" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getReceiverParameterName"));
        }
        return "$receiver";
    }

    @NotNull
    public static String getRootPackageName() {
        if ("_" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getRootPackageName"));
        }
        return "_";
    }

    @NotNull
    public static JsNameRef superMethodNameRef(@NotNull JsName superClassJsName) {
        if (superClassJsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassJsName", "org/jetbrains/kotlin/js/translate/context/Namer", "superMethodNameRef"));
        }
        JsNameRef jsNameRef = new JsNameRef("baseInitializer", (JsExpression)superClassJsName.makeRef());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "superMethodNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getNameForAccessor(@NotNull String propertyName, boolean isGetter, boolean useNativeAccessor) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
        }
        if (useNativeAccessor) {
            String string = propertyName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        if (isGetter) {
            String string = Namer.getNameForGetter(propertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
            }
            return string;
        }
        String string = Namer.getNameForSetter(propertyName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForAccessor"));
        }
        return string;
    }

    @NotNull
    public static String getKotlinBackingFieldName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "$");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getKotlinBackingFieldName"));
        }
        return string;
    }

    @NotNull
    private static String getNameForGetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForGetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "get_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForGetter"));
        }
        return string;
    }

    @NotNull
    private static String getNameForSetter(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForSetter"));
        }
        String string = Namer.getNameWithPrefix(propertyName, "set_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForSetter"));
        }
        return string;
    }

    @NotNull
    public static JsExpression getCompanionObjectAccessor(@NotNull JsExpression referenceToClass) {
        if (referenceToClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceToClass", "org/jetbrains/kotlin/js/translate/context/Namer", "getCompanionObjectAccessor"));
        }
        JsNameRef jsNameRef = new JsNameRef("object", referenceToClass);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getCompanionObjectAccessor"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getNameForCompanionObjectInitializer() {
        if ("object_initializer$" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameForCompanionObjectInitializer"));
        }
        return "object_initializer$";
    }

    @NotNull
    public static String getPrototypeName() {
        if ("prototype" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getPrototypeName"));
        }
        return "prototype";
    }

    @NotNull
    public static JsNameRef getRefToPrototype(@NotNull JsExpression classOrTraitExpression) {
        if (classOrTraitExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrTraitExpression", "org/jetbrains/kotlin/js/translate/context/Namer", "getRefToPrototype"));
        }
        JsNameRef jsNameRef = new JsNameRef(Namer.getPrototypeName(), classOrTraitExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getRefToPrototype"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String getDelegatePrefix() {
        if ("$delegate" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegatePrefix"));
        }
        return "$delegate";
    }

    @NotNull
    public static String getDelegateName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegateName"));
        }
        String string = propertyName + "$delegate";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegateName"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getDelegateNameRef(String propertyName) {
        JsNameRef jsNameRef = new JsNameRef(Namer.getDelegateName(propertyName), (JsExpression)JsLiteral.THIS);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getDelegateNameRef"));
        }
        return jsNameRef;
    }

    @NotNull
    private static String getNameWithPrefix(@NotNull String name, @NotNull String prefix) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameWithPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameWithPrefix"));
        }
        String string = prefix + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getNameWithPrefix"));
        }
        return string;
    }

    @NotNull
    public static JsNameRef getFunctionCallRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionCallRef"));
        }
        JsNameRef jsNameRef = new JsNameRef(CALL_FUNCTION, functionExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionCallRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef getFunctionApplyRef(@NotNull JsExpression functionExpression) {
        if (functionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionExpression", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionApplyRef"));
        }
        JsNameRef jsNameRef = new JsNameRef("apply", functionExpression);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getFunctionApplyRef"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation createObjectWithPrototypeFrom(JsNameRef referenceToClass) {
        JsInvocation jsInvocation = new JsInvocation((JsExpression)JS_OBJECT_CREATE_FUNCTION, Namer.getRefToPrototype(referenceToClass));
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "createObjectWithPrototypeFrom"));
        }
        return jsInvocation;
    }

    @NotNull
    public static JsNameRef getCapturedVarAccessor(@NotNull JsExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/js/translate/context/Namer", "getCapturedVarAccessor"));
        }
        JsNameRef jsNameRef = new JsNameRef(CAPTURED_VAR_FIELD, ref);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getCapturedVarAccessor"));
        }
        return jsNameRef;
    }

    @NotNull
    public static String isInstanceSuggestedName(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceSuggestedName"));
        }
        String string = "is" + descriptor2.getName().getIdentifier();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceSuggestedName"));
        }
        return string;
    }

    @NotNull
    public static Namer newInstance(@NotNull JsScope rootScope2) {
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/Namer", "newInstance"));
        }
        Namer namer = new Namer(rootScope2);
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "newInstance"));
        }
        return namer;
    }

    private Namer(@NotNull JsScope rootScope2) {
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/Namer", "<init>"));
        }
        this.kotlinName = rootScope2.declareName(KOTLIN_NAME);
        this.kotlinScope = JsScopesKt.JsObjectScope(rootScope2, "Kotlin standard object");
        this.traitName = this.kotlinScope.declareName("createTrait");
        this.definePackage = this.kotlin("definePackage");
        this.defineRootPackage = this.kotlin("defineRootPackage");
        this.callGetProperty = this.kotlin("callGetter");
        this.callSetProperty = this.kotlin("callSetter");
        this.className = this.kotlinScope.declareName("createClass");
        this.enumClassName = this.kotlinScope.declareName("createEnumClass");
        this.objectName = this.kotlinScope.declareName("createObject");
        this.callableRefForMemberFunctionName = this.kotlinScope.declareName("getCallableRefForMemberFunction");
        this.callableRefForExtensionFunctionName = this.kotlinScope.declareName("getCallableRefForExtensionFunction");
        this.callableRefForLocalExtensionFunctionName = this.kotlinScope.declareName("getCallableRefForLocalExtensionFunction");
        this.callableRefForConstructorName = this.kotlinScope.declareName("getCallableRefForConstructor");
        this.callableRefForTopLevelProperty = this.kotlinScope.declareName("getCallableRefForTopLevelProperty");
        this.callableRefForMemberProperty = this.kotlinScope.declareName("getCallableRefForMemberProperty");
        this.callableRefForExtensionProperty = this.kotlinScope.declareName("getCallableRefForExtensionProperty");
        this.isTypeName = this.kotlinScope.declareName("isType");
        this.modulesMap = this.kotlin("modules");
    }

    @NotNull
    public JsExpression classCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.className);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression enumClassCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.enumClassName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "enumClassCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression traitCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.traitName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "traitCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression packageDefinitionMethodReference() {
        JsExpression jsExpression = this.definePackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "packageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression rootPackageDefinitionMethodReference() {
        JsExpression jsExpression = this.defineRootPackage;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "rootPackageDefinitionMethodReference"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression objectCreationMethodReference() {
        JsNameRef jsNameRef = this.kotlin(this.objectName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "objectCreationMethodReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForMemberFunctionReference() {
        JsNameRef jsNameRef = this.kotlin(this.callableRefForMemberFunctionName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForMemberFunctionReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForExtensionFunctionReference() {
        JsNameRef jsNameRef = this.kotlin(this.callableRefForExtensionFunctionName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForExtensionFunctionReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForLocalExtensionFunctionReference() {
        JsNameRef jsNameRef = this.kotlin(this.callableRefForLocalExtensionFunctionName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForLocalExtensionFunctionReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForConstructorReference() {
        JsNameRef jsNameRef = this.kotlin(this.callableRefForConstructorName);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForConstructorReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForTopLevelPropertyReference() {
        JsNameRef jsNameRef = this.kotlin(this.callableRefForTopLevelProperty);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForTopLevelPropertyReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForMemberPropertyReference() {
        JsNameRef jsNameRef = this.kotlin(this.callableRefForMemberProperty);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForMemberPropertyReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression callableRefForExtensionPropertyReference() {
        JsNameRef jsNameRef = this.kotlin(this.callableRefForExtensionProperty);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "callableRefForExtensionPropertyReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression throwNPEFunctionRef() {
        JsNameRef jsNameRef = new JsNameRef("throwNPE", (JsExpression)this.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "throwNPEFunctionRef"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsNameRef kotlin(@NotNull JsName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = new JsNameRef(name, (JsExpression)this.kotlinObject());
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression kotlin(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        JsNameRef jsNameRef = this.kotlin(this.kotlinScope.declareName(name));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlin"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef kotlinObject() {
        JsNameRef jsNameRef = this.kotlinName.makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "kotlinObject"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression isTypeOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/context/Namer", "isTypeOf"));
        }
        JsInvocation invocation = new JsInvocation(this.kotlin("isTypeOf"), type2);
        MetadataProperties.setTypeCheck(invocation, TypeCheck.TYPEOF);
        JsInvocation jsInvocation = invocation;
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isTypeOf"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsExpression isInstanceOf(@NotNull JsExpression type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        JsInvocation invocation = new JsInvocation(this.kotlin("isInstanceOf"), type2);
        MetadataProperties.setTypeCheck(invocation, TypeCheck.INSTANCEOF);
        JsInvocation jsInvocation = invocation;
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        return jsInvocation;
    }

    @NotNull
    public JsExpression isInstanceOf(@NotNull JsExpression instance, @NotNull JsExpression type2) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)this.kotlin(this.isTypeName), instance, type2);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "isInstanceOf"));
        }
        return jsInvocation;
    }

    @NotNull
    JsObjectScope getKotlinScope() {
        JsObjectScope jsObjectScope = this.kotlinScope;
        if (jsObjectScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getKotlinScope"));
        }
        return jsObjectScope;
    }

    @NotNull
    static String generatePackageName(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/Namer", "generatePackageName"));
        }
        String string = packageFqName.isRoot() ? Namer.getRootPackageName() : packageFqName.shortName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "generatePackageName"));
        }
        return string;
    }

    @NotNull
    public JsExpression classCreateInvocation(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
        }
        switch (descriptor2.getKind()) {
            case INTERFACE: {
                JsExpression jsExpression = this.traitCreationMethodReference();
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsExpression;
            }
            case ENUM_CLASS: {
                JsExpression jsExpression = this.enumClassCreationMethodReference();
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsExpression;
            }
            case ENUM_ENTRY: 
            case OBJECT: {
                JsExpression jsExpression = this.objectCreationMethodReference();
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsExpression;
            }
            case ANNOTATION_CLASS: 
            case CLASS: {
                JsExpression jsExpression = DescriptorUtils.isAnonymousObject(descriptor2) ? this.objectCreationMethodReference() : this.classCreationMethodReference();
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "classCreateInvocation"));
                }
                return jsExpression;
            }
        }
        throw new UnsupportedOperationException("Unsupported class kind: " + descriptor2);
    }

    @NotNull
    public JsExpression getUndefinedExpression() {
        JsExpression jsExpression = UNDEFINED_EXPRESSION;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getUndefinedExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getCallGetProperty() {
        JsExpression jsExpression = this.callGetProperty;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getCallGetProperty"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getCallSetProperty() {
        JsExpression jsExpression = this.callSetProperty;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getCallSetProperty"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression getModuleReference(@NotNull JsStringLiteral moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/kotlin/js/translate/context/Namer", "getModuleReference"));
        }
        JsArrayAccess jsArrayAccess = new JsArrayAccess(this.modulesMap, moduleName);
        if (jsArrayAccess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/Namer", "getModuleReference"));
        }
        return jsArrayAccess;
    }
}

