/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.NoResolveFileClassesProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmOverloadFilter;", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "()V", "filterPackageMemberOverloads", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overloads", "kotlin-compiler"})
public final class JvmOverloadFilter
implements OverloadFilter {
    public static final JvmOverloadFilter INSTANCE;

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> filterPackageMemberOverloads(@NotNull Collection<? extends CallableMemberDescriptor> overloads) {
        Intrinsics.checkParameterIsNotNull(overloads, "overloads");
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>();
        HashSet<FqName> sourceClassesFQNs = new HashSet<FqName>();
        for (CallableMemberDescriptor callableMemberDescriptor : overloads) {
            KtFile file;
            if (DescriptorToSourceUtils.getContainingFile(callableMemberDescriptor) == null) {
                continue;
            }
            result2.add(callableMemberDescriptor);
            sourceClassesFQNs.add(FileClasses.getFileClassFqName(NoResolveFileClassesProvider.INSTANCE, file));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : overloads) {
            Name implClassName;
            if (!(callableMemberDescriptor instanceof DeserializedCallableMemberDescriptor)) continue;
            DeclarationDescriptor containingDeclaration = ((DeserializedCallableMemberDescriptor)callableMemberDescriptor).getContainingDeclaration();
            if (!(containingDeclaration instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)("Package member expected; got " + callableMemberDescriptor + " with containing declaration " + containingDeclaration)));
            }
            if (JvmFileClassUtil.getImplClassName((DeserializedCallableMemberDescriptor)callableMemberDescriptor) == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No implClassName: " + callableMemberDescriptor)));
            }
            FqName implClassFQN = ((PackageFragmentDescriptor)containingDeclaration).getFqName().child(implClassName);
            if (sourceClassesFQNs.contains(implClassFQN)) continue;
            result2.add(callableMemberDescriptor);
        }
        return result2;
    }

    private JvmOverloadFilter() {
        INSTANCE = this;
    }

    static {
        new JvmOverloadFilter();
    }
}

