/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;

public class RenderUtils {
    public static void drawImage(Component c, Graphics g, Image image, int x, int y, int w, int h) {
        int imageWidth = image.getWidth(c);
        int imageHeight = image.getHeight(c);
        float f = Math.min((float)w / (float)imageWidth, (float)h / (float)imageHeight);
        imageWidth = (int)(f * (float)imageWidth);
        imageHeight = (int)(f * (float)imageHeight);
        g.drawImage(image, x + (w - imageWidth) / 2, y + (h - imageHeight) / 2, imageWidth, imageHeight, c);
    }

    public static void drawIcon(Component c, Graphics g, Icon icon, int x, int y, int w, int h) {
        icon.paintIcon(c, g, x + (w - icon.getIconWidth()) / 2, y + (h - icon.getIconHeight()) / 2);
    }

    public static void drawCroppedImage(Component c, Graphics g, Image image, int x, int y, int w, int h) {
        int imageWidth = image.getWidth(c);
        int imageHeight = image.getHeight(c);
        float f = Math.max((float)w / (float)imageWidth, (float)h / (float)imageHeight);
        int offsetX = (int)(-Math.min(0.0f, (float)w - f * (float)imageWidth) / 2.0f / f);
        int offsetY = (int)((float)(-Math.min(0, h - (int)(f * (float)imageHeight)) / 2) / f);
        g.drawImage(image, x, y, x + w, y + h, offsetX, offsetY, imageWidth - offsetX, imageHeight - offsetY, c);
    }
}

