/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.ExecutionInfo;
import org.jetbrains.plugins.gradle.execution.NodeProgressAnimator;

public class ExecutionNode
extends CachingSimpleNode {
    @NotNull
    private ExecutionInfo myInfo;
    private final List<ExecutionNode> myNodes = ContainerUtil.newArrayList();

    protected ExecutionNode(Project project, @Nullable String workingDir) {
        super(project, null);
        this.myInfo = new ExecutionInfo(null, "--", workingDir);
    }

    public void add(ExecutionNode node) {
        this.myNodes.add(node);
        this.cleanUpCache();
    }

    @NotNull
    public ExecutionInfo getInfo() {
        ExecutionInfo executionInfo = this.myInfo;
        if (executionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/ExecutionNode", "getInfo"));
        }
        return executionInfo;
    }

    public void setInfo(@NotNull ExecutionInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/plugins/gradle/execution/ExecutionNode", "setInfo"));
        }
        this.myInfo = info;
    }

    public String getName() {
        return this.myInfo.getDisplayName();
    }

    @Nullable
    public String getDuration() {
        if (this.myInfo.isRunning()) {
            long duration = this.myInfo.getStartTime() == 0L ? 0L : System.currentTimeMillis() - this.myInfo.getStartTime();
            return "Running for " + StringUtil.formatDuration((long)duration);
        }
        return this.myInfo.isSkipped() ? null : StringUtil.formatDuration((long)(this.myInfo.getEndTime() - this.myInfo.getStartTime()));
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    protected ExecutionNode[] buildChildren() {
        return (ExecutionNode[])ContainerUtil.toArray(this.myNodes, (Object[])new ExecutionNode[this.myNodes.size()]);
    }

    protected void doUpdate() {
        this.setNameAndTooltip(this.getName(), null, this.myInfo.isUpToDate() ? "UP-TO-DATE" : null);
        this.setIcon(this.myInfo.isRunning() ? NodeProgressAnimator.getCurrentFrame() : (this.myInfo.isFailed() ? AllIcons.Process.State.RedExcl : (this.myInfo.isSkipped() ? AllIcons.Process.State.YellowStr : AllIcons.Process.State.GreenOK)));
    }

    protected void setNameAndTooltip(String name, @Nullable String tooltip) {
        this.setNameAndTooltip(name, tooltip, (String)null);
    }

    protected void setNameAndTooltip(String name, @Nullable String tooltip, @Nullable String hint) {
        SimpleTextAttributes textAttributes = this.getPlainAttributes();
        this.setNameAndTooltip(name, tooltip, textAttributes);
        if (!StringUtil.isEmptyOrSpaces((String)hint)) {
            this.addColoredFragment(" " + hint, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    protected void setNameAndTooltip(String name, @Nullable String tooltip, SimpleTextAttributes attributes) {
        this.clearColoredText();
        this.addColoredFragment(name, ExecutionNode.prepareAttributes(attributes));
        String s = tooltip != null ? tooltip + "\n\r" : "";
        this.getTemplatePresentation().setTooltip(s);
    }

    private static SimpleTextAttributes prepareAttributes(SimpleTextAttributes from) {
        return new SimpleTextAttributes(from.getBgColor(), from.getFgColor(), null, from.getStyle());
    }

    public String getMenuId() {
        return "RunContextGroup";
    }
}

