/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.util.attachment.AttachmentUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluationBuilder;", "Lcom/intellij/debugger/engine/evaluation/expression/EvaluatorBuilder;", "()V", "build", "Lcom/intellij/debugger/engine/evaluation/expression/ExpressionEvaluator;", "codeFragment", "Lcom/intellij/psi/PsiElement;", "position", "Lcom/intellij/debugger/SourcePosition;", "idea"})
public final class KotlinEvaluationBuilder
implements EvaluatorBuilder {
    public static final KotlinEvaluationBuilder INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ExpressionEvaluator build(@NotNull PsiElement codeFragment, @Nullable SourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        if (!(codeFragment instanceof KtCodeFragment) || position == null) {
            EvaluatorBuilder evaluatorBuilder = EvaluatorBuilderImpl.getInstance();
            if (evaluatorBuilder == null) {
                Intrinsics.throwNpe();
            }
            ExpressionEvaluator expressionEvaluator = evaluatorBuilder.build(codeFragment, position);
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionEvaluator, (String)"EvaluatorBuilderImpl.get\u2026d(codeFragment, position)");
            return expressionEvaluator;
        }
        PsiFile file = position.getFile();
        if (!(file instanceof KtFile)) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression in non-kotlin context");
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026n in non-kotlin context\")");
            throw throwable;
        }
        if (position.getLine() < 0) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)("Couldn't evaluate kotlin expression at " + position));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026expression at $position\")");
            throw throwable;
        }
        Document document = PsiDocumentManager.getInstance((Project)((KtFile)file).getProject()).getDocument(file);
        if (document == null || document.getLineCount() < position.getLine()) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)("Couldn't evaluate kotlin expression: breakpoint is placed outside the file. " + "It may happen when you've changed source file after starting a debug process."));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026arting a debug process.\")");
            throw throwable;
        }
        if (!(((KtCodeFragment)codeFragment).getContext() instanceof KtElement)) {
            void elements$iv;
            Attachment[] attachmentArray = new Attachment[]{AttachmentUtilsKt.attachmentByPsiFile(position.getFile()), AttachmentUtilsKt.attachmentByPsiFile((PsiFile)codeFragment), new Attachment("breakpoint.info", "line: " + position.getLine())};
            Attachment[] attachments = (Attachment[])((Object[])elements$iv);
            PsiElement psiElement2 = ((KtCodeFragment)codeFragment).getContext();
            KotlinEvaluationBuilderKt.getLOG().error("Trying to evaluate " + ((KtCodeFragment)codeFragment).getClass() + " with context " + (psiElement2 != null ? psiElement2.getClass() : null), new Attachment[]{AttachmentUtilsKt.mergeAttachments(Arrays.copyOf(attachments, attachments.length))});
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)"Couldn't evaluate kotlin expression in this context");
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ression in this context\")");
            throw throwable;
        }
        return (ExpressionEvaluator)new ExpressionEvaluatorImpl((Evaluator)new KotlinEvaluator((KtCodeFragment)codeFragment, position));
    }

    private KotlinEvaluationBuilder() {
        INSTANCE = this;
    }

    static {
        new KotlinEvaluationBuilder();
    }
}

