/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class JavaRuntimePresentationProvider
extends LibraryPresentationProvider<LibraryVersionProperties> {
    public static JavaRuntimePresentationProvider getInstance() {
        return (JavaRuntimePresentationProvider)((Object)LibraryPresentationProvider.EP_NAME.findExtension(JavaRuntimePresentationProvider.class));
    }

    protected JavaRuntimePresentationProvider() {
        super(JavaRuntimeLibraryDescription.KOTLIN_JAVA_RUNTIME_KIND);
    }

    @Nullable
    public Icon getIcon() {
        return KotlinIcons.SMALL_LOGO_13;
    }

    @Nullable
    public LibraryVersionProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JavaRuntimePresentationProvider", "detect"));
        }
        String version = JavaRuntimeDetectionUtil.getJavaRuntimeVersion(classesRoots);
        return version == null ? null : new LibraryVersionProperties(version);
    }

    @Nullable
    public static VirtualFile getRuntimeSrcJar(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "org/jetbrains/kotlin/idea/framework/JavaRuntimePresentationProvider", "getRuntimeSrcJar"));
        }
        return LibraryUtils.getJarFile(classesRoots, "kotlin-runtime-sources.jar");
    }

    @Nullable
    public static VirtualFile getRuntimeJar(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JavaRuntimePresentationProvider", "getRuntimeJar"));
        }
        return JavaRuntimeDetectionUtil.getRuntimeJar(Arrays.asList(library.getFiles(OrderRootType.CLASSES)));
    }

    @Nullable
    public static VirtualFile getReflectJar(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JavaRuntimePresentationProvider", "getReflectJar"));
        }
        return LibraryUtils.getJarFile(Arrays.asList(library.getFiles(OrderRootType.CLASSES)), "kotlin-reflect.jar");
    }

    @Nullable
    public static VirtualFile getRuntimeSrcJar(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JavaRuntimePresentationProvider", "getRuntimeSrcJar"));
        }
        return JavaRuntimePresentationProvider.getRuntimeSrcJar(Arrays.asList(library.getFiles(OrderRootType.SOURCES)));
    }

    @Nullable
    public static VirtualFile getTestJar(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/framework/JavaRuntimePresentationProvider", "getTestJar"));
        }
        return LibraryUtils.getJarFile(Arrays.asList(library.getFiles(OrderRootType.CLASSES)), "kotlin-test.jar");
    }
}

