/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.ErrorDuringFileAnalyzeNotificationProviderKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.inspections.UnusedSymbolInspection;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;

public class KotlinPsiCheckerAndHighlightingUpdater
extends KotlinPsiChecker {
    @Override
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/KotlinPsiCheckerAndHighlightingUpdater", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/kotlin/idea/highlighter/KotlinPsiCheckerAndHighlightingUpdater", "annotate"));
        }
        try {
            super.annotate(element2, holder);
            if (element2 instanceof KtFile) {
                ErrorDuringFileAnalyzeNotificationProviderKt.updateHighlightingResult((KtFile)element2, false);
            }
        }
        catch (ProcessCanceledException e) {
            ErrorDuringFileAnalyzeNotificationProviderKt.updateHighlightingResult((KtFile)element2.getContainingFile(), false);
            throw e;
        }
    }

    @Override
    protected boolean shouldSuppressUnusedParameter(@NotNull KtParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/KotlinPsiCheckerAndHighlightingUpdater", "shouldSuppressUnusedParameter"));
        }
        PsiElement grandParent = parameter.getParent().getParent();
        if (grandParent instanceof KtNamedFunction) {
            KtNamedFunction function2 = (KtNamedFunction)grandParent;
            return UnusedSymbolInspection.Companion.isEntryPoint(function2);
        }
        return false;
    }
}

