/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0016J#\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceCallFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "classToReplace", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getClassToReplace", "()Ljava/lang/Class;", "operation", "", "getOperation", "()Ljava/lang/String;", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "getCallExpression", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "idea"})
public abstract class ReplaceCallFix
implements IntentionAction {
    @NotNull
    private final PsiElement psiElement;

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file instanceof KtFile) {
            return this.getCallExpression() != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtQualifiedExpression ktQualifiedExpression = this.getCallExpression();
        if (ktQualifiedExpression == null) {
            return;
        }
        KtQualifiedExpression callExpression2 = ktQualifiedExpression;
        KtExpression selector = callExpression2.getSelectorExpression();
        if (selector != null) {
            KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory((PsiElement)callExpression2).createExpression(callExpression2.getReceiverExpression().getText() + this.getOperation() + selector.getText());
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
            }
            KtQualifiedExpression newElement = (KtQualifiedExpression)ktExpression;
            callExpression2.replace((PsiElement)newElement);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private final KtQualifiedExpression getCallExpression() {
        return (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)this.psiElement, this.getClassToReplace());
    }

    @NotNull
    public abstract String getOperation();

    @NotNull
    public abstract Class<? extends KtQualifiedExpression> getClassToReplace();

    @NotNull
    public final PsiElement getPsiElement() {
        return this.psiElement;
    }

    protected ReplaceCallFix(@NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        this.psiElement = psiElement2;
    }
}

