/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class LazyUiDisposable<T extends Disposable>
implements Activatable {
    private Throwable myAllocation;
    private boolean myWasEverShown;
    private final Disposable myParent;
    private final T myChild;

    public LazyUiDisposable(@Nullable Disposable parent, @NotNull JComponent ui, @NotNull T child) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/util/ui/update/LazyUiDisposable", "<init>"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/util/ui/update/LazyUiDisposable", "<init>"));
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("idea.is.internal"))) {
            this.myAllocation = new Exception();
        }
        this.myParent = parent;
        this.myChild = child;
        new UiNotifyConnector.Once(ui, this);
    }

    @Override
    public final void showNotify() {
        if (this.myWasEverShown) {
            return;
        }
        try {
            this.findParentDisposable().done(new Consumer<Disposable>(){

                public void consume(Disposable parent) {
                    Project project = null;
                    if (ApplicationManager.getApplication() != null) {
                        project = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
                    }
                    LazyUiDisposable.this.initialize(parent, LazyUiDisposable.this.myChild, project);
                    Disposer.register((Disposable)parent, (Disposable)LazyUiDisposable.this.myChild);
                }
            });
        }
        finally {
            this.myWasEverShown = true;
        }
    }

    @Override
    public final void hideNotify() {
    }

    protected abstract void initialize(@NotNull Disposable var1, @NotNull T var2, @Nullable Project var3);

    @NotNull
    private Promise<Disposable> findParentDisposable() {
        Promise<Disposable> promise = LazyUiDisposable.findDisposable(this.myParent, PlatformDataKeys.UI_DISPOSABLE);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/update/LazyUiDisposable", "findParentDisposable"));
        }
        return promise;
    }

    private static Promise<Disposable> findDisposable(Disposable defaultValue, final DataKey<? extends Disposable> key) {
        if (defaultValue == null) {
            if (ApplicationManager.getApplication() != null) {
                final AsyncPromise<Disposable> result = new AsyncPromise<Disposable>();
                DataManager.getInstance().getDataContextFromFocus().doWhenDone(new Consumer<DataContext>(){

                    public void consume(DataContext context) {
                        Disposable disposable = (Disposable)key.getData(context);
                        if (disposable == null) {
                            disposable = Disposer.get((String)"ui");
                        }
                        result.setResult(disposable);
                    }
                });
                return result;
            }
            return null;
        }
        return Promise.resolve(defaultValue);
    }
}

